/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import jakarta.inject.Inject;
import java.util.Set;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.CountedClassBean;
import org.eclipse.microprofile.metrics.tck.util.MetricsUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CountedClassBeanTest {
    private static final String CONSTRUCTOR_NAME = "CountedClassBean";
    private static final String CONSTRUCTOR_COUNTER_NAME = MetricsUtil.absoluteMetricName(CountedClassBean.class, "countedClass", "CountedClassBean");
    private static MetricID constructorMID;
    private static final String[] METHOD_NAMES;
    private static final Set<String> METHOD_COUNTER_NAMES;
    private static final Set<String> COUNTER_NAMES;
    private static Set<MetricID> counterMIDs;
    private static final MetricFilter METHOD_COUNTERS;
    @Inject
    private MetricRegistry registry;
    @Inject
    private CountedClassBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{CountedClassBean.class, MetricsUtil.class})).addAsWebInfResource("META-INF/beans.xml", "beans.xml");
    }

    @Before
    public void instantiateTest() {
        constructorMID = new MetricID(CONSTRUCTOR_COUNTER_NAME);
        counterMIDs = MetricsUtil.createMetricIDs(COUNTER_NAMES);
    }

    @Test
    @InSequence(value=1)
    public void countedMethodsNotCalledYet() {
        Assert.assertThat((String)"Counters are not registered correctly", this.registry.getCounters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(counterMIDs)));
        Assert.assertThat((String)"Method counter counts are incorrect", this.registry.getCounters(METHOD_COUNTERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    @InSequence(value=2)
    public void callCountedMethodsOnce() {
        Assert.assertThat((String)"Counters are not registered correctly", this.registry.getCounters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(counterMIDs)));
        this.bean.countedMethodOne();
        this.bean.countedMethodTwo();
        this.bean.countedMethodProtected();
        this.bean.countedMethodPackagedPrivate();
        Assert.assertThat((String)"Method counter counts are incorrect", this.registry.getCounters(METHOD_COUNTERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)1L))));
        Assert.assertThat((String)"Constructor's metric should be incremented at least once", (Object)this.registry.getCounter(constructorMID).getCount(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L))));
    }

    static {
        METHOD_NAMES = new String[]{"countedMethodOne", "countedMethodTwo", "countedMethodProtected", "countedMethodPackagedPrivate"};
        METHOD_COUNTER_NAMES = MetricsUtil.absoluteMetricNames(CountedClassBean.class, "countedClass", METHOD_NAMES);
        COUNTER_NAMES = MetricsUtil.absoluteMetricNames(CountedClassBean.class, "countedClass", METHOD_NAMES, new String[]{CONSTRUCTOR_NAME});
        METHOD_COUNTERS = new MetricFilter(){

            public boolean matches(MetricID metricID, Metric metric) {
                return METHOD_COUNTER_NAMES.contains(metricID.getName());
            }
        };
    }
}

