/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.inheritance;

import jakarta.inject.Inject;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.inheritance.VisibilityTimedMethodBean;
import org.eclipse.microprofile.metrics.tck.util.MetricsUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class VisibilityTimedMethodBeanTest {
    private static final String[] TIMER_NAMES = new String[]{"publicTimedMethod", "packagePrivateTimedMethod", "protectedTimedMethod"};
    @Inject
    private MetricRegistry registry;
    @Inject
    private VisibilityTimedMethodBean bean;

    private Set<String> absoluteMetricNames() {
        return MetricsUtil.absoluteMetricNames(VisibilityTimedMethodBean.class, TIMER_NAMES);
    }

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{VisibilityTimedMethodBean.class, MetricsUtil.class})).addAsWebInfResource("META-INF/beans.xml", "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void timedMethodsNotCalledYet() {
        Assert.assertThat((String)"Timers are not registered correctly", this.registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(MetricsUtil.createMetricIDs(this.absoluteMetricNames()))));
        Assert.assertThat((String)"Timer counts are incorrect", this.registry.getTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    @InSequence(value=2)
    public void callTimedMethodsOnce() {
        Assert.assertThat((String)"Timers are not registered correctly", this.registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(MetricsUtil.createMetricIDs(this.absoluteMetricNames()))));
        this.bean.publicTimedMethod();
        this.bean.protectedTimedMethod();
        this.bean.packagePrivateTimedMethod();
        Assert.assertThat((String)"Timer counts are incorrect", this.registry.getTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)1L))));
    }
}

