/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.HistogramFieldBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class HistogramFieldBeanTest {
    private static final String HISTOGRAM_NAME = MetricRegistry.name(HistogramFieldBean.class, (String[])new String[]{"histogramName"});
    private static MetricID histogramMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private HistogramFieldBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(HistogramFieldBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        histogramMID = new MetricID(HISTOGRAM_NAME);
    }

    @Test
    @InSequence(value=1)
    public void histogramFieldRegistered() {
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistogram(histogramMID), (Matcher)Matchers.notNullValue());
    }

    @Test
    @InSequence(value=2)
    public void updateHistogramField() {
        Histogram histogram = this.registry.getHistogram(histogramMID);
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)histogram, (Matcher)Matchers.notNullValue());
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.update(value);
        Assert.assertThat((String)"Histogram count is incorrect", (Object)histogram.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Histogram sum is incorrect", (Object)histogram.getSum(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
        Assert.assertThat((String)"Histogram size is incorrect", (Object)histogram.getSnapshot().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Histogram max value is incorrect", (Object)histogram.getSnapshot().getMax(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
    }
}

