/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.inheritance;

import jakarta.inject.Inject;
import java.util.Arrays;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.inheritance.InheritedChildGaugeMethodBean;
import org.eclipse.microprofile.metrics.tck.inheritance.InheritedParentGaugeMethodBean;
import org.eclipse.microprofile.metrics.tck.metrics.GaugeMethodBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InheritedGaugeMethodBeanTest {
    private static final String PARENT_GAUGE_NAME = MetricRegistry.name(InheritedParentGaugeMethodBean.class, (String[])new String[]{"inheritedParentGaugeMethod"});
    private static final String CHILD_GAUGE_NAME = MetricRegistry.name(InheritedChildGaugeMethodBean.class, (String[])new String[]{"inheritedChildGaugeMethod"});
    private static MetricID parentMID;
    private static MetricID childMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private InheritedChildGaugeMethodBean bean;
    @Inject
    private InheritedParentGaugeMethodBean pBean;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{GaugeMethodBean.class, InheritedParentGaugeMethodBean.class, InheritedChildGaugeMethodBean.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBean() {
        this.pBean.getGauge();
        this.bean.getChildGauge();
        parentMID = new MetricID(PARENT_GAUGE_NAME);
        childMID = new MetricID(CHILD_GAUGE_NAME);
    }

    @Test
    @InSequence(value=1)
    public void gaugesCalledWithDefaultValues() {
        Gauge parentGauge = this.registry.getGauge(parentMID);
        Gauge childGauge = this.registry.getGauge(childMID);
        Assert.assertThat((String)"Gauges are not registered correctly", (Object)parentGauge, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Gauges are not registered correctly", (Object)childGauge, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Gauge values are incorrect", Arrays.asList((Long)parentGauge.getValue(), (Long)childGauge.getValue()), (Matcher)Matchers.contains((Object[])new Long[]{0L, 0L}));
    }

    @Test
    @InSequence(value=2)
    public void callGaugesAfterSetterCalls() {
        Gauge parentGauge = this.registry.getGauge(parentMID);
        Gauge childGauge = this.registry.getGauge(childMID);
        Assert.assertThat((String)"Gauges are not registered correctly", (Object)parentGauge, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Gauges are not registered correctly", (Object)childGauge, (Matcher)Matchers.notNullValue());
        long parentValue = Math.round(Math.random() * 9.223372036854776E18);
        this.pBean.setGauge(parentValue);
        long childValue = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.setChildGauge(childValue);
        Assert.assertThat((String)"Gauge values are incorrect", Arrays.asList((Long)parentGauge.getValue(), (Long)childGauge.getValue()), (Matcher)Matchers.contains((Object[])new Long[]{parentValue, childValue}));
    }
}

