/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.cdi;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.tck.cdi.MetricProducerFieldBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MetricProducerFieldBeanTest {
    private static MetricID counter1MID;
    private static MetricID counter2MID;
    private static MetricID ratioGaugeMID;
    private static MetricID notRegMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private MetricProducerFieldBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(MetricProducerFieldBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBean() {
        this.bean.toString();
        counter1MID = new MetricID("counter1");
        counter2MID = new MetricID("counter2");
        ratioGaugeMID = new MetricID("ratioGauge");
        notRegMID = new MetricID("not_registered_counter");
    }

    @Test
    @InSequence(value=1)
    public void countersNotIncrementedYet() {
        Assert.assertThat((String)"Counters are not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)counter1MID), (Matcher)Matchers.hasKey((Object)counter2MID), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)notRegMID))));
        Counter counter1 = this.registry.getCounter(counter1MID);
        Counter counter2 = this.registry.getCounter(counter2MID);
        Gauge gauge = this.registry.getGauge(ratioGaugeMID);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)gauge, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((double)counter1.getCount() / (double)counter2.getCount()))));
    }

    @Test
    @InSequence(value=2)
    public void incrementCountersFromRegistry() {
        Assert.assertThat((String)"Counters are not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)counter1MID), (Matcher)Matchers.hasKey((Object)counter2MID), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)notRegMID))));
        Counter counter1 = this.registry.getCounter(counter1MID);
        Counter counter2 = this.registry.getCounter(counter2MID);
        Gauge gauge = this.registry.getGauge(ratioGaugeMID);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)gauge, (Matcher)Matchers.notNullValue());
        counter1.inc(Math.round(Math.random() * 2.147483647E9));
        counter2.inc(Math.round(Math.random() * 2.147483647E9));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((double)counter1.getCount() / (double)counter2.getCount()))));
    }

    @InSequence(value=3)
    public void incrementCountersFromInjection(@Metric(name="ratioGauge", absolute=true) Gauge<Double> gauge, @Metric(name="counter1", absolute=true) Counter counter1, @Metric(name="counter2", absolute=true) Counter counter2) {
        counter1.inc(Math.round(Math.random() * 2.147483647E9));
        counter2.inc(Math.round(Math.random() * 2.147483647E9));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((double)counter1.getCount() / (double)counter2.getCount()))));
        Gauge gaugeFromRegistry = this.registry.getGauge(new MetricID("ratioGauge"));
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)gaugeFromRegistry, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Gauge values from registry and injection do not match", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)gaugeFromRegistry.getValue())));
    }
}

