/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.ConcurrentGaugedClassBean;
import org.eclipse.microprofile.metrics.tck.util.MetricsUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ConcurrentGaugedClassBeanTest {
    private static final String CONSTRUCTOR_NAME = "ConcurrentGaugedClassBean";
    private static final String[] METHOD_NAMES = new String[]{"countedMethodOne", "countedMethodTwo", "countedMethodProtected", "countedMethodPackagedPrivate"};
    private static final Set<String> C_GAUGED_NAMES = MetricsUtil.absoluteMetricNames(ConcurrentGaugedClassBean.class, "cGaugedClass", METHOD_NAMES, new String[]{"ConcurrentGaugedClassBean"});
    private static Set<MetricID> counterMIDs;
    @Inject
    private MetricRegistry registry;
    @Inject
    private ConcurrentGaugedClassBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{ConcurrentGaugedClassBean.class, MetricsUtil.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        counterMIDs = MetricsUtil.createMetricIDs(C_GAUGED_NAMES);
    }

    @Test
    @InSequence(value=1)
    public void countedMethodsNotCalledYet() {
        SortedMap concurrentGauges = this.registry.getConcurrentGauges();
        Assert.assertThat((String)"Concurrent Gauges are not registered correctly", concurrentGauges.keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(counterMIDs)));
        MetricID constructorMetricID = new MetricID(MetricsUtil.absoluteMetricName(ConcurrentGaugedClassBean.class, CONSTRUCTOR_NAME));
        for (Map.Entry entry : concurrentGauges.entrySet()) {
            if (!((MetricID)entry.getKey()).equals((Object)constructorMetricID)) {
                Assert.assertEquals((String)("Max value of metric " + ((MetricID)entry.getKey()).toString() + " should be 0"), (long)0L, (long)((ConcurrentGauge)entry.getValue()).getMax());
            }
            Assert.assertEquals((String)("Min value of metric " + ((MetricID)entry.getKey()).toString() + " should be 0"), (long)0L, (long)((ConcurrentGauge)entry.getValue()).getMin());
            Assert.assertEquals((String)("Current count of metric " + ((MetricID)entry.getKey()).toString() + " should be 0"), (long)0L, (long)((ConcurrentGauge)entry.getValue()).getCount());
        }
    }

    @Test
    @InSequence(value=2)
    public void callCountedMethodsOnce() {
        Assert.assertThat((String)"Concurrent Gauges are not registered correctly", this.registry.getConcurrentGauges().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(counterMIDs)));
        this.bean.countedMethodOne();
        this.bean.countedMethodTwo();
        this.bean.countedMethodProtected();
        this.bean.countedMethodPackagedPrivate();
        Assert.assertThat((String)"Concurrent Gauges counts should return to zero", this.registry.getConcurrentGauges().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }
}

