/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.MetricProducerMethodBean;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MetricProducerMethodBeanTest {
    private static final String CALLS_METRIC = MetricRegistry.name(MetricProducerMethodBean.class, (String[])new String[]{"calls"});
    private static MetricID callsMID;
    private static final String HITS_METRIC;
    private static MetricID hitsMID;
    private static final String CACHE_HITS_METRIC;
    private static MetricID cacheHitsMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private MetricProducerMethodBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(MetricProducerMethodBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBean() {
        this.bean.toString();
        callsMID = new MetricID(CALLS_METRIC);
        hitsMID = new MetricID(HITS_METRIC);
        cacheHitsMID = new MetricID(CACHE_HITS_METRIC);
    }

    @Test
    @InSequence(value=1)
    public void cachedMethodNotCalledYet() {
        Assert.assertThat((String)"Metrics are not registered correctly", (Object)this.registry.getMetrics(), (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)callsMID), (Matcher)Matchers.hasKey((Object)hitsMID), (Matcher)Matchers.hasKey((Object)cacheHitsMID)));
        Timer calls = (Timer)this.registry.getTimers().get(callsMID);
        Meter hits = (Meter)this.registry.getMeters().get(hitsMID);
        Gauge gauge = (Gauge)this.registry.getGauges().get(cacheHitsMID);
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((double)hits.getCount() / (double)calls.getCount()))));
    }

    @Test
    @InSequence(value=2)
    public void callCachedMethodMultipleTimes() {
        Assert.assertThat((String)"Metrics are not registered correctly", (Object)this.registry.getMetrics(), (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)callsMID), (Matcher)Matchers.hasKey((Object)hitsMID), (Matcher)Matchers.hasKey((Object)cacheHitsMID)));
        Timer calls = (Timer)this.registry.getTimers().get(callsMID);
        Meter hits = (Meter)this.registry.getMeters().get(hitsMID);
        Gauge gauge = (Gauge)this.registry.getGauges().get(cacheHitsMID);
        long count = 10L + Math.round(Math.random() * 10.0);
        int i = 0;
        while ((long)i < count) {
            this.bean.cachedMethod(Math.random() < 0.5);
            ++i;
        }
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((double)hits.getCount() / (double)calls.getCount()))));
    }

    static {
        HITS_METRIC = MetricRegistry.name(MetricProducerMethodBean.class, (String[])new String[]{"hits"});
        CACHE_HITS_METRIC = MetricRegistry.name(MetricProducerMethodBean.class, (String[])new String[]{"cache-hits"});
    }
}

