/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
public class MetricProducerMethodBean {
    @Inject
    private Meter hits;

    @Timed(name="calls")
    public void cachedMethod(boolean hit) {
        if (hit) {
            this.hits.mark();
        }
    }

    @Produces
    @Metric(name="cache-hits")
    Gauge<Double> cacheHitRatioGauge(final @Metric(name="hits") Meter hits, final @Metric(name="calls") Timer calls) {
        return new Gauge<Double>(){

            public Double getValue() {
                return (double)hits.getCount() / (double)calls.getCount();
            }
        };
    }

    @Produces
    @Metric(name="not_registered_metric")
    Counter notRegisteredMetric(MetricRegistry registry, InjectionPoint ip) {
        return registry.counter("not_registered_metric");
    }
}

