/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.MeteredMethodBean1;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MeteredMethodBeanTest {
    private static final String METER_NAME = MetricRegistry.name(MeteredMethodBean1.class, (String[])new String[]{"meteredMethod"});
    private static MetricID meterMID;
    private static final AtomicLong METER_COUNT;
    @Inject
    private MetricRegistry registry;
    @Inject
    private MeteredMethodBean1 bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(MeteredMethodBean1.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        meterMID = new MetricID(METER_NAME);
    }

    @Test
    @InSequence(value=1)
    public void meteredMethodNotCalledYet() {
        Assert.assertThat((String)"Meter is not registered correctly", (Object)this.registry.getMeters(), (Matcher)Matchers.hasKey((Object)meterMID));
        Meter meter = (Meter)this.registry.getMeters().get(meterMID);
        Assert.assertThat((String)"Meter count is incorrect", (Object)meter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNT.get())));
    }

    @Test
    @InSequence(value=2)
    public void callMeteredMethodOnce() {
        Assert.assertThat((String)"Meter is not registered correctly", (Object)this.registry.getMeters(), (Matcher)Matchers.hasKey((Object)meterMID));
        Meter meter = (Meter)this.registry.getMeters().get(meterMID);
        this.bean.meteredMethod();
        Assert.assertThat((String)"Timer count is incorrect", (Object)meter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNT.incrementAndGet())));
    }

    @Test
    @InSequence(value=3)
    public void removeMeterFromRegistry() {
        Assert.assertThat((String)"Meter is not registered correctly", (Object)this.registry.getMeters(), (Matcher)Matchers.hasKey((Object)meterMID));
        Meter meter = (Meter)this.registry.getMeters().get(meterMID);
        this.registry.remove(meterMID);
        try {
            this.bean.meteredMethod();
        }
        catch (RuntimeException cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
            Assert.assertThat((String)"Meter count is incorrect", (Object)meter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)METER_COUNT.get())));
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }

    static {
        METER_COUNT = new AtomicLong();
    }
}

