/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.MeteredConstructorBean;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MeteredConstructorBeanTest {
    private static final String METER_NAME = "meteredConstructor";
    private static MetricID meterMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private Instance<MeteredConstructorBean> instance;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(MeteredConstructorBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        meterMID = new MetricID(METER_NAME);
    }

    @Test
    @InSequence(value=1)
    public void meteredConstructorCalled() {
        long count = 1L + Math.round(Math.random() * 10.0);
        int i = 0;
        while ((long)i < count) {
            this.instance.get();
            ++i;
        }
        Assert.assertThat((String)"Meter is not registered correctly", (Object)this.registry.getMeters(), (Matcher)Matchers.hasKey((Object)meterMID));
        Meter meter = (Meter)this.registry.getMeters().get(meterMID);
        Assert.assertThat((String)"Meter count is incorrect", (Object)meter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)count)));
    }
}

