/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricRegistry;

public final class MetricsUtil {
    private MetricsUtil() {
    }

    public static Set<String> absoluteMetricNames(Class<?> clazz, String ... names) {
        HashSet<String> set = new HashSet<String>(names.length);
        for (String name : names) {
            set.add(MetricsUtil.absoluteMetricName(clazz, name));
        }
        return set;
    }

    public static Set<String> absoluteMetricNames(Class<?> clazz, String prefix, String ... names) {
        HashSet<String> set = new HashSet<String>(names.length);
        for (String name : names) {
            set.add(MetricsUtil.absoluteMetricName(clazz, prefix, name));
        }
        return set;
    }

    public static Set<String> absoluteMetricNames(Class<?> clazz, String[] array, String ... names) {
        HashSet<String> set = new HashSet<String>(MetricsUtil.absoluteMetricNames(clazz, array));
        for (String name : names) {
            set.add(MetricsUtil.absoluteMetricName(clazz, name));
        }
        return set;
    }

    public static Set<String> absoluteMetricNames(Class<?> clazz, String prefix, String[] array, String ... names) {
        HashSet<String> set = new HashSet<String>(MetricsUtil.absoluteMetricNames(clazz, prefix, array));
        for (String name : names) {
            set.add(MetricsUtil.absoluteMetricName(clazz, prefix, name));
        }
        return set;
    }

    public static String absoluteMetricName(Class<?> clazz, String name) {
        return MetricRegistry.name(clazz, (String[])new String[]{name});
    }

    public static String absoluteMetricName(Class<?> clazz, String metric, String name) {
        return MetricRegistry.name((String)(clazz.getPackage().getName() + "." + metric), (String[])new String[]{name});
    }
}

