/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.CountedClassBean;
import io.astefanutti.metrics.cdi.se.util.MetricsUtil;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CountedClassBeanTest {
    private static final String CONSTRUCTOR_NAME = "CountedClassBean";
    private static final String[] METHOD_NAMES = new String[]{"countedMethodOne", "countedMethodTwo", "countedMethodProtected", "countedMethodPackagedPrivate"};
    private static final Set<String> COUNTER_NAMES = MetricsUtil.absoluteMetricNames(CountedClassBean.class, "countedClass", METHOD_NAMES, new String[]{"CountedClassBean"});
    @Inject
    private MetricRegistry registry;
    @Inject
    private CountedClassBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{CountedClassBean.class, MetricsUtil.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void countedMethodsNotCalledYet() {
        Assert.assertThat((String)"Counters are not registered correctly", this.registry.getCounters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(COUNTER_NAMES)));
        Assert.assertThat((String)"Counter counts are incorrect", this.registry.getCounters().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    @InSequence(value=2)
    public void callCountedMethodsOnce() {
        Assert.assertThat((String)"Counters are not registered correctly", this.registry.getCounters().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(COUNTER_NAMES)));
        this.bean.countedMethodOne();
        this.bean.countedMethodTwo();
        this.bean.countedMethodProtected();
        this.bean.countedMethodPackagedPrivate();
        Assert.assertThat((String)"Counter counts are incorrect", this.registry.getCounters().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }
}

