/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.TimedConstructorBean;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TimedConstructorBeanTest {
    private static final String TIMER_NAME = MetricRegistry.name(TimedConstructorBean.class, (String[])new String[]{"timedConstructor"});
    @Inject
    private MetricRegistry registry;
    @Inject
    private Instance<TimedConstructorBean> instance;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(TimedConstructorBean.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void timedConstructorCalled() {
        long count = 1L + Math.round(Math.random() * 10.0);
        int i = 0;
        while ((long)i < count) {
            this.instance.get();
            ++i;
        }
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)TIMER_NAME));
        Timer timer = (Timer)this.registry.getTimers().get(TIMER_NAME);
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)count)));
    }
}

