/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.InheritedTimedMethodBean;
import io.astefanutti.metrics.cdi.se.VisibilityTimedMethodBean;
import io.astefanutti.metrics.cdi.se.util.MetricsUtil;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InheritedTimedMethodBeanTest {
    private static final String[] PARENT_TIMER_NAMES = new String[]{"publicTimedMethod", "packagePrivateTimedMethod", "protectedTimedMethod"};
    private static final String[] CHILD_TIMER_NAMES = new String[]{"timedMethodOne", "timedMethodTwo", "timedMethodProtected", "timedMethodPackagedPrivate"};
    @Inject
    private MetricRegistry registry;
    @Inject
    private InheritedTimedMethodBean bean;

    private Set<String> absoluteMetricNames() {
        Set<String> names = MetricsUtil.absoluteMetricNames(VisibilityTimedMethodBean.class, PARENT_TIMER_NAMES);
        names.addAll(MetricsUtil.absoluteMetricNames(InheritedTimedMethodBean.class, CHILD_TIMER_NAMES));
        return names;
    }

    @Deployment
    static Archive<?> createTestArchive() {
        return ((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{VisibilityTimedMethodBean.class, InheritedTimedMethodBean.class, MetricsUtil.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void timedMethodsNotCalledYet() {
        Assert.assertThat((String)"Timers are not registered correctly", this.registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        Assert.assertThat((String)"Timer counts are incorrect", this.registry.getTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    @InSequence(value=2)
    public void callTimedMethodsOnce() {
        Assert.assertThat((String)"Timers are not registered correctly", this.registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(this.absoluteMetricNames())));
        this.bean.publicTimedMethod();
        this.bean.protectedTimedMethod();
        this.bean.packagePrivateTimedMethod();
        this.bean.timedMethodOne();
        this.bean.timedMethodTwo();
        this.bean.timedMethodProtected();
        this.bean.timedMethodPackagedPrivate();
        Assert.assertThat((String)"Timer counts are incorrect", this.registry.getTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)1L))));
    }
}

