/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck;

import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TagsTest {
    private Metadata metadata;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUpMetadata() {
        this.metadata = new Metadata("count", "countMe", "countMe tags test", MetricType.COUNTER, "percent", "colour=blue");
    }

    @Test
    public void tagsTest() {
        Assert.assertNotNull((Object)this.metadata);
        Assert.assertTrue((boolean)this.metadata.getTags().containsValue("blue"));
    }

    @Test
    public void addTagsTest() {
        this.metadata.addTags("colour=green,size=medium");
        this.metadata.addTag("number=5");
        Assert.assertNotNull((Object)this.metadata);
        Assert.assertTrue((boolean)this.metadata.getTags().containsKey("size"));
        Assert.assertTrue((boolean)this.metadata.getTags().containsValue("green"));
        Assert.assertFalse((boolean)this.metadata.getTags().containsValue("blue"));
        Assert.assertTrue((boolean)this.metadata.getTags().containsKey("number"));
    }
}

