/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MetricRegistryTest {
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="nameTest", absolute=true)
    private Counter nameTest;
    @Inject
    private Counter countTemp;
    @Inject
    private Histogram histoTemp;
    @Inject
    private Timer timerTemp;
    @Inject
    private Meter meterTemp;
    @Inject
    private MetricRegistry metrics;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void nameTest() {
        Assert.assertNotNull((Object)this.metrics);
        Assert.assertTrue((boolean)this.metrics.getNames().contains("nameTest"));
    }

    @Test
    @InSequence(value=2)
    public void registerTest() {
        this.metrics.register("regCountTemp", (Metric)this.countTemp);
        Assert.assertTrue((boolean)this.metrics.getCounters().containsKey("regCountTemp"));
        this.metrics.register("regHistoTemp", (Metric)this.histoTemp);
        Assert.assertTrue((boolean)this.metrics.getHistograms().containsKey("regHistoTemp"));
        this.metrics.register("regTimerTemp", (Metric)this.timerTemp);
        Assert.assertTrue((boolean)this.metrics.getTimers().containsKey("regTimerTemp"));
        this.metrics.register("regMeterTemp", (Metric)this.meterTemp);
        Assert.assertTrue((boolean)this.metrics.getMeters().containsKey("regMeterTemp"));
    }

    @Test
    @InSequence(value=3)
    public void removeTest() {
        this.metrics.remove("nameTest");
        Assert.assertFalse((boolean)this.metrics.getNames().contains("nameTest"));
    }
}

