/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.MonotonicCountedMethodBean;
import java.util.concurrent.Callable;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MonotonicCountedMethodBeanTest {
    private static final String COUNTER_NAME = "monotonicCountedMethod";
    private static final AtomicLong COUNTER_COUNT = new AtomicLong();
    @Inject
    private MetricRegistry registry;
    @Inject
    private MonotonicCountedMethodBean<Long> bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(MonotonicCountedMethodBean.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void countedMethodNotCalledYet() {
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_NAME));
        Counter counter = (Counter)this.registry.getCounters().get(COUNTER_NAME);
        Assert.assertThat((String)"Counter count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.get())));
    }

    @Test
    @InSequence(value=2)
    public void countedMethodNotCalledYet(@Metric(name="monotonicCountedMethod", absolute=true) Counter instance) {
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_NAME));
        Counter counter = (Counter)this.registry.getCounters().get(COUNTER_NAME);
        Assert.assertThat((String)"Counter and bean instance are not equal", (Object)instance, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)counter)));
    }

    @Test
    @InSequence(value=3)
    public void callCountedMethodOnce() throws InterruptedException, TimeoutException {
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_NAME));
        Counter counter = (Counter)this.registry.getCounters().get(COUNTER_NAME);
        final Exchanger<Long> exchanger = new Exchanger<Long>();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    exchanger.exchange(MonotonicCountedMethodBeanTest.this.bean.monotonicCountedMethod(new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            exchanger.exchange(0L);
                            return exchanger.exchange(0L);
                        }
                    }));
                }
                catch (InterruptedException cause) {
                    throw new RuntimeException(cause);
                }
            }
        });
        final AtomicInteger uncaught = new AtomicInteger();
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                uncaught.incrementAndGet();
            }
        });
        thread.start();
        exchanger.exchange(0L, 5L, TimeUnit.SECONDS);
        Assert.assertThat((String)"Counter count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.incrementAndGet())));
        Long random = 1L + Math.round(Math.random() * 9.223372036854776E18);
        exchanger.exchange(random, 5L, TimeUnit.SECONDS);
        Assert.assertThat((String)"Counted method return value is incorrect", (Object)exchanger.exchange(0L), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)random)));
        Assert.assertThat((String)"Counter count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.get())));
        thread.join();
        Assert.assertThat((String)"Exception thrown in method call thread", (Object)uncaught.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    @InSequence(value=4)
    public void removeMonotonicCounterFromRegistry() {
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_NAME));
        Counter counter = (Counter)this.registry.getCounters().get(COUNTER_NAME);
        this.registry.remove(COUNTER_NAME);
        try {
            this.bean.monotonicCountedMethod(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return null;
                }
            });
        }
        catch (Exception cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
            Assert.assertThat((Object)cause.getMessage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)("No counter with name [monotonicCountedMethod] found in registry [" + this.registry + "]"))));
            Assert.assertThat((String)"Counter count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.get())));
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }
}

