/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.util;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import org.eclipse.microprofile.jwt.Claims;

public class TokenUtils {
    private TokenUtils() {
    }

    public static String generateTokenString(String jsonResName) throws Exception {
        return TokenUtils.generateTokenString(jsonResName, Collections.emptySet());
    }

    public static String generateTokenString(String jsonResName, Set<InvalidClaims> invalidClaims) throws Exception {
        return TokenUtils.generateTokenString(jsonResName, invalidClaims, null);
    }

    public static String generateTokenString(String jsonResName, Set<InvalidClaims> invalidClaims, Map<String, Long> timeClaims) throws Exception {
        PrivateKey pk;
        if (invalidClaims == null) {
            invalidClaims = Collections.emptySet();
        }
        InputStream contentIS = TokenUtils.class.getResourceAsStream(jsonResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        byte[] content = new byte[length];
        System.arraycopy(tmp, 0, content, 0, length);
        JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        JSONObject jwtContent = (JSONObject)parser.parse(content);
        if (invalidClaims.contains((Object)InvalidClaims.ISSUER)) {
            jwtContent.put((Object)Claims.iss.name(), (Object)"INVALID_ISSUER");
        }
        long currentTimeInSecs = TokenUtils.currentTimeInSecs();
        long exp = currentTimeInSecs + 300L;
        jwtContent.put((Object)Claims.iat.name(), (Object)currentTimeInSecs);
        jwtContent.put((Object)Claims.auth_time.name(), (Object)currentTimeInSecs);
        if (!invalidClaims.contains((Object)InvalidClaims.EXP)) {
            jwtContent.put((Object)Claims.exp.name(), (Object)exp);
        }
        if (timeClaims != null) {
            timeClaims.put(Claims.iat.name(), currentTimeInSecs);
            timeClaims.put(Claims.auth_time.name(), currentTimeInSecs);
            timeClaims.put(Claims.exp.name(), exp);
        }
        if (invalidClaims.contains((Object)InvalidClaims.SIGNER)) {
            KeyPair keyPair = TokenUtils.generateKeyPair(2048);
            pk = keyPair.getPrivate();
        } else {
            pk = TokenUtils.readPrivateKey("/privateKey.pem");
        }
        RSASSASigner signer = new RSASSASigner(pk);
        JWTClaimsSet claimsSet = JWTClaimsSet.parse((JSONObject)jwtContent);
        JWSAlgorithm alg = JWSAlgorithm.RS256;
        if (invalidClaims.contains((Object)InvalidClaims.ALG)) {
            alg = JWSAlgorithm.HS256;
            SecureRandom random = new SecureRandom();
            BigInteger secret = BigInteger.probablePrime(256, random);
            signer = new MACSigner(secret.toByteArray());
        }
        JWSHeader jwtHeader = new JWSHeader.Builder(alg).keyID("/privateKey.pem").type(JOSEObjectType.JWT).build();
        SignedJWT signedJWT = new SignedJWT(jwtHeader, claimsSet);
        signedJWT.sign((JWSSigner)signer);
        String jwt = signedJWT.serialize();
        return jwt;
    }

    public static PrivateKey readPrivateKey(String pemResName) throws Exception {
        InputStream contentIS = TokenUtils.class.getResourceAsStream(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        PrivateKey privateKey = TokenUtils.decodePrivateKey(new String(tmp, 0, length));
        return privateKey;
    }

    public static PublicKey readPublicKey(String pemResName) throws Exception {
        InputStream contentIS = TokenUtils.class.getResourceAsStream(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        PublicKey publicKey = TokenUtils.decodePublicKey(new String(tmp, 0, length));
        return publicKey;
    }

    public static KeyPair generateKeyPair(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        return keyPair;
    }

    public static PrivateKey decodePrivateKey(String pemEncoded) throws Exception {
        pemEncoded = TokenUtils.removeBeginEnd(pemEncoded);
        byte[] pkcs8EncodedBytes = Base64.getDecoder().decode(pemEncoded);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8EncodedBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privKey = kf.generatePrivate(keySpec);
        return privKey;
    }

    public static PublicKey decodePublicKey(String pemEncoded) throws Exception {
        pemEncoded = TokenUtils.removeBeginEnd(pemEncoded);
        byte[] encodedBytes = Base64.getDecoder().decode(pemEncoded);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }

    private static String removeBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN (.*)-----", "");
        pem = pem.replaceAll("-----END (.*)----", "");
        pem = pem.replaceAll("\r\n", "");
        pem = pem.replaceAll("\n", "");
        return pem.trim();
    }

    private static int currentTimeInSecs() {
        long currentTimeMS = System.currentTimeMillis();
        int currentTimeSec = (int)(currentTimeMS / 1000L);
        return currentTimeSec;
    }

    public static enum InvalidClaims {
        ISSUER,
        EXP,
        SIGNER,
        ALG;

    }
}

