/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck.cdi;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.tck.cdi.AbstractBean;
import org.eclipse.microprofile.context.tck.cdi.ConversationScopeBean;
import org.eclipse.microprofile.context.tck.cdi.RequestScopedBean;
import org.eclipse.microprofile.context.tck.cdi.SessionScopedBean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CDIContextTest
extends Arquillian {
    static final int TIMEOUT_MIN = 2;
    @Inject
    RequestScopedBean requestBean;
    @Inject
    SessionScopedBean sessionBean;
    @Inject
    ConversationScopeBean conversationBean;

    @AfterMethod
    public void afterMethod(Method m, ITestResult result) {
        System.out.println("<<< END " + m.getClass().getSimpleName() + '.' + m.getName() + (result.isSuccess() ? " SUCCESS" : " FAILED"));
        Throwable failure = result.getThrowable();
        if (failure != null) {
            failure.printStackTrace(System.out);
        }
    }

    @BeforeMethod
    public void beforeMethod(Method m) {
        System.out.println(">>> BEGIN " + m.getClass().getSimpleName() + '.' + m.getName());
    }

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(CDIContextTest.class.getSimpleName() + ".war"))).addClass(AbstractBean.class)).addClass(RequestScopedBean.class)).addClass(SessionScopedBean.class)).addClass(ConversationScopeBean.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        System.out.println(war.toString(true));
        return war;
    }

    @Test
    public void testCDIMECtxPropagate() throws Exception {
        ManagedExecutor propagateCDI = ManagedExecutor.builder().propagated(new String[]{"CDI"}).cleared(new String[]{"Remaining"}).build();
        try {
            this.checkCDIPropagation(true, "testCDI_ME_Ctx_Propagate-REQUEST", propagateCDI, this.requestBean);
            this.checkCDIPropagation(true, "testCDI_ME_Ctx_Propagate-SESSION", propagateCDI, this.sessionBean);
            this.checkCDIPropagation(true, "testCDI_ME_Ctx_Propagate-CONVERSATION", propagateCDI, this.conversationBean);
        }
        finally {
            propagateCDI.shutdown();
        }
    }

    @Test
    public void testCDIMECtxClear() throws Exception {
        ManagedExecutor propagatedNone = ManagedExecutor.builder().propagated(new String[0]).cleared(new String[]{"Remaining"}).build();
        try {
            this.checkCDIPropagation(false, "testCDI_ME_Ctx_Clear-REQUEST", propagatedNone, this.requestBean);
            this.checkCDIPropagation(false, "testCDI_ME_Ctx_Clear-SESSION", propagatedNone, this.sessionBean);
            this.checkCDIPropagation(false, "testCDI_ME_Ctx_Clear-CONVERSATION", propagatedNone, this.conversationBean);
        }
        finally {
            propagatedNone.shutdown();
        }
    }

    private void checkCDIPropagation(boolean expectPropagate, String stateToPropagate, ManagedExecutor me, AbstractBean bean) throws Exception {
        bean.setState(stateToPropagate);
        CompletableFuture cf = me.supplyAsync(() -> {
            String state = bean.getState();
            return state;
        });
        Assert.assertEquals((String)((String)cf.get(2L, TimeUnit.MINUTES)), (String)(expectPropagate ? stateToPropagate : "UNINITIALIZED"));
    }

    @Test
    public void testCDITCCtxPropagate() throws Exception {
        ThreadContext defaultTC = ThreadContext.builder().propagated(new String[]{"CDI"}).cleared(new String[]{"Remaining"}).unchanged(new String[0]).build();
        this.requestBean.setState("testCDIContextPropagate-STATE2");
        Callable getState = defaultTC.contextualCallable(() -> {
            String state = this.requestBean.getState();
            return state;
        });
        Assert.assertEquals((String)((String)getState.call()), (String)"testCDIContextPropagate-STATE2");
    }

    @Test
    public void testCDITCCtxClear() throws Exception {
        ThreadContext clearAllCtx = ThreadContext.builder().propagated(new String[0]).cleared(new String[]{"Remaining"}).unchanged(new String[0]).build();
        this.requestBean.setState("testCDIThreadCtxClear-STATE1");
        Callable getState = clearAllCtx.contextualCallable(() -> {
            String state = this.requestBean.getState();
            return state;
        });
        Assert.assertEquals((String)((String)getState.call()), (String)"UNINITIALIZED");
    }
}

