/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;
import org.eclipse.microprofile.config.tck.base.AbstractTest;
import org.eclipse.microprofile.config.tck.configsources.CustomConfigSourceProvider;
import org.eclipse.microprofile.config.tck.configsources.CustomDbConfigSource;
import org.eclipse.microprofile.config.tck.converters.Donald;
import org.eclipse.microprofile.config.tck.converters.Duck;
import org.eclipse.microprofile.config.tck.converters.DuckConverter;
import org.eclipse.microprofile.config.tck.converters.UpperCaseDuckConverter;
import org.eclipse.microprofile.config.tck.util.AdditionalAssertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConverterTest
extends Arquillian {
    @Inject
    private Config config;
    @Inject
    private InjectingBean bean;

    @Deployment
    public static WebArchive deploy() {
        WebArchive testWar = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"converterTest.war")).addClass(ConverterTest.class)).addPackage(CustomDbConfigSource.class.getPackage())).addClasses(new Class[]{DuckConverter.class, Duck.class, Donald.class, UpperCaseDuckConverter.class, AdditionalAssertions.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsServiceProvider(ConfigSource.class, new Class[]{CustomDbConfigSource.class})).addAsServiceProvider(ConfigSourceProvider.class, new Class[]{CustomConfigSourceProvider.class})).addAsServiceProvider(Converter.class, new Class[]{DuckConverter.class})).as(WebArchive.class);
        AbstractTest.addFile(testWar, "META-INF/microprofile-config.properties");
        AbstractTest.addFile(testWar, "sampleconfig.yaml");
        return testWar;
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDonaldNotConvertedByDefault() {
        this.config.getValue("tck.config.test.javaconfig.converter.donaldname", Donald.class);
    }

    @Test
    public void testNoDonaldConverterByDefault() {
        Assert.assertFalse((boolean)this.config.getConverter(Donald.class).isPresent());
    }

    @Test
    public void testDonaldConversionWithLambdaConverter() {
        Config newConfig = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverter(Donald.class, 100, (Converter & Serializable)s -> Donald.iLikeDonald(s)).build();
        Donald donald = (Donald)newConfig.getValue("tck.config.test.javaconfig.converter.donaldname", Donald.class);
        Assert.assertNotNull((Object)donald);
        Assert.assertEquals((String)donald.getName(), (String)"Duck");
    }

    @Test
    public void testGetDonaldConverterWithLambdaConverter() {
        Config newConfig = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverter(Donald.class, 100, (Converter & Serializable)s -> Donald.iLikeDonald(s)).build();
        Donald donald = (Donald)((Converter)newConfig.getConverter(Donald.class).get()).convert("Duck");
        Assert.assertNotNull((Object)donald);
        Assert.assertEquals((String)donald.getName(), (String)"Duck");
    }

    @Test
    public void testDonaldConversionWithMultipleLambdaConverters() {
        Config config1 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverter(Donald.class, 101, (Converter & Serializable)s -> Donald.iLikeDonald(s.toUpperCase())).withConverter(Donald.class, 100, (Converter & Serializable)s -> Donald.iLikeDonald(s)).build();
        Config config2 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverter(Donald.class, 100, (Converter & Serializable)s -> Donald.iLikeDonald(s)).withConverter(Donald.class, 101, (Converter & Serializable)s -> Donald.iLikeDonald(s.toUpperCase())).build();
        Donald donald = (Donald)((Converter)config1.getConverter(Donald.class).get()).convert("Duck");
        Assert.assertNotNull((Object)donald);
        Assert.assertEquals((String)donald.getName(), (String)"DUCK", (String)"The converter with the highest priority (using upper case) must be used.");
        donald = (Donald)((Converter)config2.getConverter(Donald.class).get()).convert("Duck");
        Assert.assertNotNull((Object)donald);
        Assert.assertEquals((String)donald.getName(), (String)"DUCK", (String)"The converter with the highest priority (using upper case) must be used.");
    }

    @Test
    public void testGetDonaldConverterWithMultipleLambdaConverters() {
        Config config1 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverter(Donald.class, 101, (Converter & Serializable)s -> Donald.iLikeDonald(s.toUpperCase())).withConverter(Donald.class, 100, (Converter & Serializable)s -> Donald.iLikeDonald(s)).build();
        Config config2 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverter(Donald.class, 100, (Converter & Serializable)s -> Donald.iLikeDonald(s)).withConverter(Donald.class, 101, (Converter & Serializable)s -> Donald.iLikeDonald(s.toUpperCase())).build();
        Donald donald = (Donald)config1.getValue("tck.config.test.javaconfig.converter.donaldname", Donald.class);
        Assert.assertNotNull((Object)donald);
        Assert.assertEquals((String)donald.getName(), (String)"DUCK", (String)"The converter with the highest priority (using upper case) must be used.");
        donald = (Donald)config2.getValue("tck.config.test.javaconfig.converter.donaldname", Donald.class);
        Assert.assertNotNull((Object)donald);
        Assert.assertEquals((String)donald.getName(), (String)"DUCK", (String)"The converter with the highest priority (using upper case) must be used.");
    }

    @Test
    public void testByte() {
        Byte value = (Byte)this.config.getValue("tck.config.test.javaconfig.converter.bytevalue", Byte.class);
        Assert.assertEquals((Object)value, (Object)123);
    }

    @Test
    public void testbyte() {
        byte value = (Byte)this.config.getValue("tck.config.test.javaconfig.converter.bytevalue", Byte.TYPE);
        Assert.assertEquals((byte)value, (byte)123);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testByte_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.bytevalue.broken", Byte.class);
    }

    @Test
    public void testGetByteConverter() {
        Byte value = (Byte)((Converter)this.config.getConverter(Byte.class).get()).convert("123");
        Assert.assertEquals((Object)value, (Object)123);
    }

    @Test
    public void testGetbyteConverter() {
        byte value = (Byte)((Converter)this.config.getConverter(Byte.TYPE).get()).convert("123");
        Assert.assertEquals((byte)value, (byte)123);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetByteConverter_Broken() {
        ((Converter)this.config.getConverter(Byte.class).get()).convert("xxx");
    }

    @Test
    public void testShort() {
        Short value = (Short)this.config.getValue("tck.config.test.javaconfig.converter.shortvalue", Short.class);
        Assert.assertEquals((Object)value, (Object)1234);
    }

    @Test
    public void testshort() {
        short value = (Short)this.config.getValue("tck.config.test.javaconfig.converter.shortvalue", Short.TYPE);
        Assert.assertEquals((short)value, (short)1234);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testShort_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.shortvalue.broken", Short.class);
    }

    @Test
    public void testGetShortConverter() {
        Short value = (Short)((Converter)this.config.getConverter(Short.class).get()).convert("1234");
        Assert.assertEquals((Object)value, (Object)1234);
    }

    @Test
    public void testGetshortConverter() {
        short value = (Short)((Converter)this.config.getConverter(Short.TYPE).get()).convert("1234");
        Assert.assertEquals((short)value, (short)1234);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetShortConverter_Broken() {
        ((Converter)this.config.getConverter(Short.class).get()).convert("xxx");
    }

    @Test
    public void testInteger() {
        Integer value = (Integer)this.config.getValue("tck.config.test.javaconfig.converter.integervalue", Integer.class);
        Assert.assertEquals((Object)value, (Object)1234);
    }

    @Test
    public void testInt() {
        int value = (Integer)this.config.getValue("tck.config.test.javaconfig.converter.integervalue", Integer.TYPE);
        Assert.assertEquals((int)value, (int)1234);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInteger_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.integervalue.broken", Integer.class);
    }

    @Test
    public void testGetIntegerConverter() {
        Integer value = (Integer)((Converter)this.config.getConverter(Integer.class).get()).convert("1234");
        Assert.assertEquals((Object)value, (Object)1234);
    }

    @Test
    public void testGetIntConverter() {
        int value = (Integer)((Converter)this.config.getConverter(Integer.TYPE).get()).convert("1234");
        Assert.assertEquals((int)value, (int)1234);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetIntegerConverter_Broken() {
        ((Converter)this.config.getConverter(Integer.class).get()).convert("xxx");
    }

    @Test
    public void testLong() {
        Long value = (Long)this.config.getValue("tck.config.test.javaconfig.converter.longvalue", Long.class);
        Assert.assertEquals((Object)value, (Object)1234567890L);
    }

    @Test
    public void testlong() {
        long primitiveValue = (Long)this.config.getValue("tck.config.test.javaconfig.converter.longvalue", Long.TYPE);
        Assert.assertEquals((long)primitiveValue, (long)1234567890L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLong_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.longvalue.broken", Long.class);
    }

    @Test
    public void testGetLongConverter() {
        Long value = (Long)((Converter)this.config.getConverter(Long.class).get()).convert("1234567890");
        Assert.assertEquals((Object)value, (Object)1234567890L);
    }

    @Test
    public void testGetlongConverter() {
        long primitiveValue = (Long)((Converter)this.config.getConverter(Long.TYPE).get()).convert("1234567890");
        Assert.assertEquals((long)primitiveValue, (long)1234567890L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetLongConverter_Broken() {
        ((Converter)this.config.getConverter(Long.class).get()).convert("alfasdf");
    }

    @Test
    public void testFloat() {
        Float value = (Float)this.config.getValue("tck.config.test.javaconfig.converter.floatvalue", Float.class);
        Assert.assertEquals((Object)value, (Object)new Float(12.34f));
    }

    @Test
    public void testfloat() {
        float value = ((Float)this.config.getValue("tck.config.test.javaconfig.converter.floatvalue", Float.TYPE)).floatValue();
        Assert.assertEquals((float)value, (float)12.34f);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFloat_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.floatvalue.broken", Float.class);
    }

    @Test
    public void testGetFloatConverter() {
        Float value = (Float)((Converter)this.config.getConverter(Float.class).get()).convert("12.34");
        Assert.assertEquals((Object)value, (Object)new Float(12.34f));
    }

    @Test
    public void testGetfloatConverter() {
        float value = ((Float)((Converter)this.config.getConverter(Float.TYPE).get()).convert("12.34")).floatValue();
        Assert.assertEquals((float)value, (float)12.34f);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetFloatConverter_Broken() {
        ((Converter)this.config.getConverter(Float.class).get()).convert("alfasdf");
    }

    @Test
    public void testDouble() {
        Double value = (Double)this.config.getValue("tck.config.test.javaconfig.converter.doublevalue", Double.class);
        Assert.assertEquals((Object)value, (Object)new Double(12.34));
    }

    @Test
    public void testdouble() {
        double value = (Double)this.config.getValue("tck.config.test.javaconfig.converter.doublevalue", Double.TYPE);
        Assert.assertEquals((double)value, (double)12.34);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDouble_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.doublevalue.broken", Double.class);
    }

    @Test
    public void testGetDoubleConverter() {
        Double value = (Double)((Converter)this.config.getConverter(Double.class).get()).convert("12.34");
        Assert.assertEquals((Object)value, (Object)new Double(12.34));
    }

    @Test
    public void testGetdoubleConverter() {
        double value = (Double)((Converter)this.config.getConverter(Double.TYPE).get()).convert("12.34");
        Assert.assertEquals((double)value, (double)12.34);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetDoubleConverter_Broken() {
        ((Converter)this.config.getConverter(Double.class).get()).convert("alfasdf");
    }

    @Test
    public void testChar() {
        Character value = (Character)this.config.getValue("tck.config.test.javaconfig.converter.charvalue", Character.class);
        Assert.assertEquals((Object)value, (Object)Character.valueOf('c'));
    }

    @Test
    public void testchar() {
        char value = ((Character)this.config.getValue("tck.config.test.javaconfig.converter.charvalue", Character.TYPE)).charValue();
        Assert.assertEquals((char)value, (char)'c');
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testChar_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.charvalue.broken", Character.class);
    }

    @Test
    public void testGetCharConverter() {
        Character value = (Character)((Converter)this.config.getConverter(Character.class).get()).convert("c");
        Assert.assertEquals((Object)value, (Object)Character.valueOf('c'));
    }

    @Test
    public void testGetcharConverter() {
        char value = ((Character)((Converter)this.config.getConverter(Character.TYPE).get()).convert("c")).charValue();
        Assert.assertEquals((char)value, (char)'c');
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetCharConverter_Broken() {
        ((Converter)this.config.getConverter(Character.class).get()).convert("xxx");
    }

    @Test
    public void testDuration() {
        Duration value = (Duration)this.config.getValue("tck.config.test.javaconfig.converter.durationvalue", Duration.class);
        Assert.assertEquals((Object)value, (Object)Duration.parse("PT15M"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDuration_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.durationvalue.broken", Duration.class);
    }

    @Test
    public void testGetDurationCoverter() {
        Duration value = (Duration)((Converter)this.config.getConverter(Duration.class).get()).convert("PT15M");
        Assert.assertEquals((Object)value, (Object)Duration.parse("PT15M"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetDurationConverter_Broken() {
        ((Converter)this.config.getConverter(Duration.class).get()).convert("alfasdf");
    }

    @Test
    public void testLocalTime() {
        LocalTime value = (LocalTime)this.config.getValue("tck.config.test.javaconfig.converter.localtimevalue", LocalTime.class);
        Assert.assertEquals((Object)value, (Object)LocalTime.parse("10:37"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLocalTime_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.localtimevalue.broken", LocalTime.class);
    }

    @Test
    public void testGetLocalTimeConverter() {
        LocalTime value = (LocalTime)((Converter)this.config.getConverter(LocalTime.class).get()).convert("10:37");
        Assert.assertEquals((Object)value, (Object)LocalTime.parse("10:37"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetLocalTimeConverter_Broken() {
        ((Converter)this.config.getConverter(LocalTime.class).get()).convert("alfasdf");
    }

    @Test
    public void testLocalDate() {
        LocalDate value = (LocalDate)this.config.getValue("tck.config.test.javaconfig.converter.localdatevalue", LocalDate.class);
        Assert.assertEquals((Object)value, (Object)LocalDate.parse("2017-12-24"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLocalDate_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.localdatevalue.broken", LocalDate.class);
    }

    @Test
    public void testGetLocalDateConverter() {
        LocalDate value = (LocalDate)((Converter)this.config.getConverter(LocalDate.class).get()).convert("2017-12-24");
        Assert.assertEquals((Object)value, (Object)LocalDate.parse("2017-12-24"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetLocalDateConverter_Broken() {
        ((Converter)this.config.getConverter(LocalDate.class).get()).convert("alfasdf");
    }

    @Test
    public void testLocalDateTime() {
        LocalDateTime value = (LocalDateTime)this.config.getValue("tck.config.test.javaconfig.converter.localdatetimevalue", LocalDateTime.class);
        Assert.assertEquals((Object)value, (Object)LocalDateTime.parse("2017-12-24T10:25:30"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLocalDateTime_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.localdatetimevalue.broken", LocalDateTime.class);
    }

    @Test
    public void testGetLocalDateTimeConverter() {
        LocalDateTime value = (LocalDateTime)((Converter)this.config.getConverter(LocalDateTime.class).get()).convert("2017-12-24T10:25:30");
        Assert.assertEquals((Object)value, (Object)LocalDateTime.parse("2017-12-24T10:25:30"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetLocalDateTimeConverter_Broken() {
        ((Converter)this.config.getConverter(LocalDateTime.class).get()).convert("alfasdf");
    }

    @Test
    public void testOffsetDateTime() {
        OffsetDateTime value = (OffsetDateTime)this.config.getValue("tck.config.test.javaconfig.converter.offsetdatetimevalue", OffsetDateTime.class);
        Assert.assertEquals((Object)value, (Object)OffsetDateTime.parse("2007-12-03T10:15:30+01:00"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOffsetDateTime_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.offsetdatetimevalue.broken", OffsetDateTime.class);
    }

    @Test
    public void testGetOffsetDateTimeConverter() {
        OffsetDateTime value = (OffsetDateTime)((Converter)this.config.getConverter(OffsetDateTime.class).get()).convert("2007-12-03T10:15:30+01:00");
        Assert.assertEquals((Object)value, (Object)OffsetDateTime.parse("2007-12-03T10:15:30+01:00"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetOffsetDateTimeConverter_Broken() {
        ((Converter)this.config.getConverter(OffsetDateTime.class).get()).convert("alfasdf");
    }

    @Test
    public void testOffsetTime() {
        OffsetTime value = (OffsetTime)this.config.getValue("tck.config.test.javaconfig.converter.offsettimevalue", OffsetTime.class);
        OffsetTime parsed = OffsetTime.parse("13:45:30.123456789+02:00");
        Assert.assertEquals((Object)value, (Object)parsed);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOffsetTime_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.offsettimevalue.broken", OffsetTime.class);
    }

    @Test
    public void testGetOffsetTimeConverter() {
        OffsetTime value = (OffsetTime)((Converter)this.config.getConverter(OffsetTime.class).get()).convert("13:45:30.123456789+02:00");
        OffsetTime parsed = OffsetTime.parse("13:45:30.123456789+02:00");
        Assert.assertEquals((Object)value, (Object)parsed);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetOffsetTimeConverter_Broken() {
        ((Converter)this.config.getConverter(OffsetTime.class).get()).convert("alfasdf");
    }

    @Test
    public void testZoneOffset() {
        ZoneOffset value = (ZoneOffset)this.config.getValue("tck.config.test.javaconfig.converter.zoneoffsetvalue", ZoneOffset.class);
        ZoneOffset parsed = ZoneOffset.of("+02:00");
        Assert.assertEquals((Object)value, (Object)parsed);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testZoneOffset_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.zoneoffsetvalue.broken", ZoneOffset.class);
    }

    @Test
    public void testGetZoneOffsetConverter() {
        ZoneOffset value = (ZoneOffset)((Converter)this.config.getConverter(ZoneOffset.class).get()).convert("+02:00");
        ZoneOffset parsed = ZoneOffset.of("+02:00");
        Assert.assertEquals((Object)value, (Object)parsed);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetZoneOffsetConverter_Broken() {
        ((Converter)this.config.getConverter(ZoneOffset.class).get()).convert("alfasdf");
    }

    @Test
    public void testInstant() {
        Instant value = (Instant)this.config.getValue("tck.config.test.javaconfig.converter.instantvalue", Instant.class);
        Assert.assertEquals((Object)value, (Object)Instant.parse("2015-06-02T21:34:33.616Z"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInstant_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.instantvalue.broken", Instant.class);
    }

    @Test
    public void testGetInstantConverter() {
        Instant value = (Instant)((Converter)this.config.getConverter(Instant.class).get()).convert("2015-06-02T21:34:33.616Z");
        Assert.assertEquals((Object)value, (Object)Instant.parse("2015-06-02T21:34:33.616Z"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetInstantConverter_Broken() {
        ((Converter)this.config.getConverter(Instant.class).get()).convert("alfasdf");
    }

    @Test
    public void testBoolean() {
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.true", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.true", Boolean.TYPE)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.true_uppercase", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.true_mixedcase", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.false", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.one", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.zero", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.seventeen", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.yes", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.yes_uppercase", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.yes_mixedcase", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.no", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.y", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.y_uppercase", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.n", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.on", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.on_uppercase", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.on_mixedcase", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.off", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.off", Boolean.TYPE)));
    }

    @Test
    public void testGetBooleanConverter() {
        Converter converter = (Converter)this.config.getConverter(Boolean.class).get();
        Converter primitiveConverter = (Converter)this.config.getConverter(Boolean.TYPE).get();
        Assert.assertTrue((boolean)((Boolean)converter.convert("true")));
        Assert.assertTrue((boolean)((Boolean)primitiveConverter.convert("true")));
        Assert.assertTrue((boolean)((Boolean)converter.convert("TRUE")));
        Assert.assertTrue((boolean)((Boolean)converter.convert("TruE")));
        Assert.assertFalse((boolean)((Boolean)converter.convert("false")));
        Assert.assertTrue((boolean)((Boolean)converter.convert("1")));
        Assert.assertFalse((boolean)((Boolean)converter.convert("0")));
        Assert.assertFalse((boolean)((Boolean)converter.convert("17")));
        Assert.assertTrue((boolean)((Boolean)converter.convert("yes")));
        Assert.assertTrue((boolean)((Boolean)converter.convert("YES")));
        Assert.assertTrue((boolean)((Boolean)converter.convert("Yes")));
        Assert.assertFalse((boolean)((Boolean)converter.convert("no")));
        Assert.assertTrue((boolean)((Boolean)converter.convert("y")));
        Assert.assertTrue((boolean)((Boolean)converter.convert("Y")));
        Assert.assertFalse((boolean)((Boolean)converter.convert("n")));
        Assert.assertTrue((boolean)((Boolean)converter.convert("on")));
        Assert.assertTrue((boolean)((Boolean)converter.convert("ON")));
        Assert.assertTrue((boolean)((Boolean)converter.convert("oN")));
        Assert.assertFalse((boolean)((Boolean)converter.convert("off")));
        Assert.assertFalse((boolean)((Boolean)primitiveConverter.convert("off")));
    }

    @Test
    public void testCustomConverter() {
        Assert.assertEquals((String)this.bean.getNamedDuck().getName(), (String)"Hannelore");
    }

    @Test
    public void testGetCustomConverter() {
        Assert.assertEquals((String)((Duck)((Converter)this.config.getConverter(Duck.class).get()).convert("Hannelore")).getName(), (String)"Hannelore");
    }

    @Test
    public void testDuckConversionWithMultipleConverters() {
        Config config1 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverters(new Converter[]{new UpperCaseDuckConverter(), new DuckConverter()}).build();
        Config config2 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverters(new Converter[]{new DuckConverter(), new UpperCaseDuckConverter()}).build();
        Duck duck = (Duck)config1.getValue("tck.config.test.javaconfig.converter.duckname", Duck.class);
        Assert.assertNotNull((Object)duck);
        Assert.assertEquals((String)duck.getName(), (String)"HANNELORE", (String)"The converter with the highest priority (UpperCaseDuckConverter) must be used.");
        duck = (Duck)config2.getValue("tck.config.test.javaconfig.converter.duckname", Duck.class);
        Assert.assertNotNull((Object)duck);
        Assert.assertEquals((String)duck.getName(), (String)"HANNELORE", (String)"The converter with the highest priority (UpperCaseDuckConverter) must be used.");
    }

    @Test
    public void testGetDuckConverterWithMultipleConverters() {
        Config config1 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverters(new Converter[]{new UpperCaseDuckConverter(), new DuckConverter()}).build();
        Config config2 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverters(new Converter[]{new DuckConverter(), new UpperCaseDuckConverter()}).build();
        Duck duck = (Duck)((Converter)config1.getConverter(Duck.class).get()).convert("Hannelore");
        Assert.assertNotNull((Object)duck);
        Assert.assertEquals((String)duck.getName(), (String)"HANNELORE", (String)"The converter with the highest priority (UpperCaseDuckConverter) must be used.");
        duck = (Duck)((Converter)config2.getConverter(Duck.class).get()).convert("Hannelore");
        Assert.assertNotNull((Object)duck);
        Assert.assertEquals((String)duck.getName(), (String)"HANNELORE", (String)"The converter with the highest priority (UpperCaseDuckConverter) must be used.");
    }

    @Test
    public void testURLConverter() throws MalformedURLException, URISyntaxException {
        URL url = (URL)this.config.getValue("tck.config.test.javaconfig.converter.urlvalue", URL.class);
        Assert.assertTrue((boolean)AdditionalAssertions.urlEquals(url, new URL("http://microprofile.io")));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testURLConverterBroken() throws Exception {
        this.config.getValue("tck.config.test.javaconfig.converter.urlvalue.broken", URL.class);
    }

    @Test
    public void testGetURLConverter() throws MalformedURLException, URISyntaxException {
        URL url = (URL)((Converter)this.config.getConverter(URL.class).get()).convert("http://microprofile.io");
        Assert.assertTrue((boolean)AdditionalAssertions.urlEquals(url, new URL("http://microprofile.io")));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetURLConverterBroken() throws Exception {
        ((Converter)this.config.getConverter(URL.class).get()).convert("tt:--location");
    }

    @Test
    public void testURIConverter() {
        URI uri = (URI)this.config.getValue("tck.config.test.javaconfig.converter.urivalue", URI.class);
        Assert.assertEquals((Object)uri, (Object)URI.create("http://microprofile.io"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testURIConverterBroken() throws Exception {
        this.config.getValue("tck.config.test.javaconfig.converter.urivalue.broken", URI.class);
    }

    @Test
    public void testGetURIConverter() {
        URI uri = (URI)((Converter)this.config.getConverter(URI.class).get()).convert("http://microprofile.io");
        Assert.assertEquals((Object)uri, (Object)URI.create("http://microprofile.io"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetURIConverterBroken() throws Exception {
        ((Converter)this.config.getConverter(URI.class).get()).convert("space is an illegal uri character");
    }

    @Test
    public void testConverterSerialization() {
        DuckConverter original = new DuckConverter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);){
            out.writeObject(original);
        }
        catch (IOException ex) {
            Assert.fail((String)"Converter instance should be serializable, but could not serialize it", (Throwable)ex);
        }
        Object readObject = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
            readObject = in.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)"Converter instance should be serializable, but could not deserialize a previously serialized instance", (Throwable)ex);
        }
        Assert.assertEquals((String)((DuckConverter)((Converter)readObject)).convert("Donald").getName(), (String)original.convert("Donald").getName(), (String)"Converted values to be equal");
    }

    @Test
    public void testGetConverterSerialization() {
        Converter original = (Converter)this.config.getConverter(Duck.class).get();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);){
            out.writeObject(original);
        }
        catch (IOException ex) {
            Assert.fail((String)"Converter instance should be serializable, but could not serialize it", (Throwable)ex);
        }
        Object readObject = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
            readObject = in.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)"Converter instance should be serializable, but could not deserialize a previously serialized instance", (Throwable)ex);
        }
        Assert.assertEquals((String)((Duck)((Converter)readObject).convert("Donald")).getName(), (String)((Duck)original.convert("Donald")).getName(), (String)"Converted values to be equal");
    }

    @Dependent
    public static class InjectingBean {
        @Inject
        @ConfigProperty(name="tck.config.test.javaconfig.converter.duckname")
        private Duck namedDuck;

        public Duck getNamedDuck() {
            return this.namedDuck;
        }
    }
}

