/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck.converters;

import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NullConvertersTest
extends Arquillian {
    @Deployment
    public static WebArchive deployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"NullConvertersTest.war")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void nulls() {
        Config config = ConfigProvider.getConfig();
        Assert.assertThrows(NullPointerException.class, () -> NullConvertersTest.convertNull(config, Boolean.class));
        Assert.assertThrows(NullPointerException.class, () -> NullConvertersTest.convertNull(config, Byte.class));
        Assert.assertThrows(NullPointerException.class, () -> NullConvertersTest.convertNull(config, Short.class));
        Assert.assertThrows(NullPointerException.class, () -> NullConvertersTest.convertNull(config, Integer.class));
        Assert.assertThrows(NullPointerException.class, () -> NullConvertersTest.convertNull(config, Long.class));
        Assert.assertThrows(NullPointerException.class, () -> NullConvertersTest.convertNull(config, Float.class));
        Assert.assertThrows(NullPointerException.class, () -> NullConvertersTest.convertNull(config, Double.class));
        Assert.assertThrows(NullPointerException.class, () -> NullConvertersTest.convertNull(config, Character.class));
        Assert.assertThrows(NullPointerException.class, () -> NullConvertersTest.convertNull(config, OptionalInt.class));
        Assert.assertThrows(NullPointerException.class, () -> NullConvertersTest.convertNull(config, OptionalLong.class));
        Assert.assertThrows(NullPointerException.class, () -> NullConvertersTest.convertNull(config, OptionalDouble.class));
    }

    private static <T> void convertNull(Config config, Class<T> converterType) {
        config.getConverter(converterType).map(converter -> converter.convert(null)).orElseThrow(NoSuchElementException::new);
    }
}

