/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.Converter;
import org.eclipse.microprofile.config.tck.ArrayConverterBean;
import org.eclipse.microprofile.config.tck.base.AbstractTest;
import org.eclipse.microprofile.config.tck.converters.Pizza;
import org.eclipse.microprofile.config.tck.converters.PizzaConverter;
import org.eclipse.microprofile.config.tck.util.AdditionalAssertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayConverterTest
extends Arquillian {
    @Inject
    private Config config;
    @Inject
    private ArrayConverterBean converterBean;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arrayConverterTest.jar")).addPackage(PizzaConverter.class.getPackage())).addClasses(new Class[]{ArrayConverterTest.class, ArrayConverterBean.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsServiceProvider(Converter.class, new Class[]{PizzaConverter.class})).as(JavaArchive.class);
        AbstractTest.addFile(testJar, "META-INF/microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"arrayConverterTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testBooleanArrayLookupProgrammatically() {
        Object[] value = (Boolean[])this.config.getValue("tck.config.test.javaconfig.converter.booleanvalues", Boolean[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new Boolean[]{true, false, true});
        Object[] single = (Boolean[])this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.true", Boolean[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Boolean[]{true});
    }

    @Test
    public void testGetBooleanArrayConverter() {
        Object[] value = (Boolean[])((Converter)this.config.getConverter(Boolean[].class).get()).convert("true,false,true");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new Boolean[]{true, false, true});
        Object[] single = (Boolean[])((Converter)this.config.getConverter(Boolean[].class).get()).convert("true");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Boolean[]{true});
    }

    @Test
    public void testOptionalBooleanArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.booleanvalues", Boolean[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (Boolean[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new Boolean[]{true, false, true});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.configvalue.boolean.true", Boolean[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (Boolean[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Boolean[]{true});
    }

    @Test
    public void testBooleanListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.booleanvalues", Boolean.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)3);
        Assert.assertEquals((Collection)values, Arrays.asList(true, false, true));
        List single = this.config.getValues("tck.config.test.javaconfig.configvalue.boolean.true", Boolean.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(true));
    }

    @Test
    public void testOptionalBooleanListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.booleanvalues", Boolean.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List value = (List)optionalValues.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.size(), (int)3);
        Assert.assertEquals((Collection)value, Arrays.asList(true, false, true));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.configvalue.boolean.true", Boolean.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(true));
    }

    @Test
    public void testBooleanArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyBooleanArray().length, (int)3);
        Assert.assertEquals((Object[])this.converterBean.getMyBooleanArray(), (Object[])new Boolean[]{true, false, true});
        Assert.assertEquals((int)this.converterBean.getMySingleBooleanArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleBooleanArray(), (Object[])new Boolean[]{true});
    }

    @Test
    public void testGetbooleanArrayConverter() {
        boolean[] value = (boolean[])((Converter)this.config.getConverter(boolean[].class).get()).convert("true,false,true");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object)value, (Object)new Boolean[]{true, false, true});
        boolean[] single = (boolean[])((Converter)this.config.getConverter(boolean[].class).get()).convert("true");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object)single, (Object)new Boolean[]{true});
    }

    @Test
    public void testbooleanArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMybooleanArray().length, (int)3);
        Assert.assertEquals((boolean[])this.converterBean.getMybooleanArray(), (boolean[])new boolean[]{true, false, true});
        Assert.assertEquals((int)this.converterBean.getMySinglebooleanArray().length, (int)1);
        Assert.assertEquals((boolean[])this.converterBean.getMySinglebooleanArray(), (boolean[])new boolean[]{true});
    }

    @Test
    public void testbooleanListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyBooleanList().size(), (int)3);
        Assert.assertEquals(this.converterBean.getMyBooleanList(), Arrays.asList(true, false, true));
        Assert.assertEquals((int)this.converterBean.getMySingleBooleanList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleBooleanList(), Arrays.asList(true));
    }

    @Test
    public void testbooleanSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyBooleanSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyBooleanSet(), new LinkedHashSet<Boolean>(Arrays.asList(true, false, true)));
        Assert.assertEquals((int)this.converterBean.getMySingleBooleanSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleBooleanSet(), Collections.singleton(true));
    }

    @Test
    public void testStringArrayLookupProgrammatically() {
        Object[] value = (String[])this.config.getValue("tck.config.test.javaconfig.converter.stringvalues", String[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)4);
        Assert.assertEquals((Object[])value, (Object[])new String[]{"microservice", "microprofile", "m,f", "microservice"});
        Object[] single = (String[])this.config.getValue("tck.config.test.javaconfig.configvalue.key1", String[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new String[]{"value1"});
    }

    @Test
    public void testGetStringArrayConverter() {
        Object[] value = (String[])((Converter)this.config.getConverter(String[].class).get()).convert("microservice,microprofile,m\\,f,microservice");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)4);
        Assert.assertEquals((Object[])value, (Object[])new String[]{"microservice", "microprofile", "m,f", "microservice"});
        Object[] single = (String[])((Converter)this.config.getConverter(String[].class).get()).convert("value1");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new String[]{"value1"});
    }

    @Test
    public void testOptionalStringArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.stringvalues", String[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (String[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)4);
        Assert.assertEquals((Object[])value, (Object[])new String[]{"microservice", "microprofile", "m,f", "microservice"});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.configvalue.key1", String[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (String[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new String[]{"value1"});
    }

    @Test
    public void testStringListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.stringvalues", String.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)4);
        Assert.assertEquals((Collection)values, Arrays.asList("microservice", "microprofile", "m,f", "microservice"));
        List single = this.config.getValues("tck.config.test.javaconfig.configvalue.key1", String.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList("value1"));
    }

    @Test
    public void testOptionalStringListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.stringvalues", String.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)4);
        Assert.assertEquals((Collection)values, Arrays.asList("microservice", "microprofile", "m,f", "microservice"));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.configvalue.key1", String.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList("value1"));
    }

    @Test
    public void testStringArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyStringArray().length, (int)4);
        Assert.assertEquals((Object[])this.converterBean.getMyStringArray(), (Object[])new String[]{"microservice", "microprofile", "m,f", "microservice"});
        Assert.assertEquals((int)this.converterBean.getMySingleStringArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleStringArray(), (Object[])new String[]{"value1"});
    }

    @Test
    public void testStringListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyStringList().size(), (int)4);
        Assert.assertEquals(this.converterBean.getMyStringList(), Arrays.asList("microservice", "microprofile", "m,f", "microservice"));
        Assert.assertEquals((int)this.converterBean.getMySingleStringList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleStringList(), Arrays.asList("value1"));
    }

    @Test
    public void testStringSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyStringSet().size(), (int)3);
        Assert.assertEquals(this.converterBean.getMyStringSet(), new LinkedHashSet<String>(Arrays.asList("microservice", "microprofile", "m,f", "microservice")));
        Assert.assertEquals((int)this.converterBean.getMySingleStringSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleStringSet(), Collections.singleton("value1"));
    }

    @Test
    public void testIntegerArrayLookupProgrammatically() {
        Object[] value = (Integer[])this.config.getValue("tck.config.test.javaconfig.converter.integervalues", Integer[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Integer[]{1234, 9999});
        Object[] single = (Integer[])this.config.getValue("tck.config.test.javaconfig.converter.integervalue", Integer[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Integer[]{1234});
    }

    @Test
    public void testGetIntegerArrayConverter() {
        Object[] value = (Integer[])((Converter)this.config.getConverter(Integer[].class).get()).convert("1234,9999");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Integer[]{1234, 9999});
        Object[] single = (Integer[])((Converter)this.config.getConverter(Integer[].class).get()).convert("1234");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Integer[]{1234});
    }

    @Test
    public void testOptionalIntegerArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.integervalues", Integer[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (Integer[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Integer[]{1234, 9999});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.integervalue", Integer[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (Integer[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Integer[]{1234});
    }

    @Test
    public void testIntegerListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.integervalues", Integer.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(1234, 9999));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.integervalue", Integer.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(1234));
    }

    @Test
    public void testOptionalIntegerListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.integervalues", Integer.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(1234, 9999));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.integervalue", Integer.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(1234));
    }

    @Test
    public void testIntArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyIntegerArray().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyIntegerArray(), (Object[])new Integer[]{1234, 9999});
        Assert.assertEquals((int)this.converterBean.getMySingleIntegerArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleIntegerArray(), (Object[])new Integer[]{1234});
    }

    @Test
    public void testGetIntArrayConverter() {
        int[] value = (int[])((Converter)this.config.getConverter(int[].class).get()).convert("1234,9999");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object)value, (Object)new Integer[]{1234, 9999});
        int[] single = (int[])((Converter)this.config.getConverter(int[].class).get()).convert("1234");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object)single, (Object)new Integer[]{1234});
    }

    @Test
    public void testintArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyintArray().length, (int)2);
        Assert.assertEquals((Object)this.converterBean.getMyIntegerArray(), (Object)new int[]{1234, 9999});
        Assert.assertEquals((int)this.converterBean.getMySingleintArray().length, (int)1);
        Assert.assertEquals((Object)this.converterBean.getMySingleIntegerArray(), (Object)new int[]{1234});
    }

    @Test
    public void testIntListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyIntegerList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyIntegerList(), Arrays.asList(1234, 9999));
        Assert.assertEquals((int)this.converterBean.getMySingleIntegerList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleIntegerList(), Arrays.asList(1234));
    }

    @Test
    public void testIntSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyIntegerSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyIntegerSet(), new LinkedHashSet<Integer>(Arrays.asList(1234, 9999)));
        Assert.assertEquals((int)this.converterBean.getMySingleIntegerSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleIntegerSet(), Collections.singleton(1234));
    }

    @Test
    public void testLongArrayLookupProgrammatically() {
        Object[] value = (Long[])this.config.getValue("tck.config.test.javaconfig.converter.longvalues", Long[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Long[]{1234567890L, 1999999999L});
        Object[] single = (Long[])this.config.getValue("tck.config.test.javaconfig.converter.longvalue", Long[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Long[]{1234567890L});
    }

    @Test
    public void testGetLongArrayCoverter() {
        Object[] value = (Long[])((Converter)this.config.getConverter(Long[].class).get()).convert("1234567890,1999999999");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Long[]{1234567890L, 1999999999L});
        Object[] single = (Long[])((Converter)this.config.getConverter(Long[].class).get()).convert("1234567890");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Long[]{1234567890L});
    }

    @Test
    public void testOptionalLongArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.longvalues", Long[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (Long[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Long[]{1234567890L, 1999999999L});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.longvalue", Long[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (Long[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Long[]{1234567890L});
    }

    @Test
    public void testLongListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.longvalues", Long.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(1234567890L, 1999999999L));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.longvalue", Long.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(1234567890L));
    }

    @Test
    public void testOptionalLongListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.longvalues", Long.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(1234567890L, 1999999999L));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.longvalue", Long.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(1234567890L));
    }

    @Test
    public void testLongArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLongArray().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyLongArray(), (Object[])new Long[]{1234567890L, 1999999999L});
        Assert.assertEquals((int)this.converterBean.getMySingleLongArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleLongArray(), (Object[])new Long[]{1234567890L});
    }

    @Test
    public void testGetlongArrayCoverter() {
        long[] value = (long[])((Converter)this.config.getConverter(long[].class).get()).convert("1234567890,1999999999");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object)value, (Object)new Long[]{1234567890L, 1999999999L});
        long[] single = (long[])((Converter)this.config.getConverter(long[].class).get()).convert("1234567890");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object)single, (Object)new Long[]{1234567890L});
    }

    @Test
    public void testlongArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMylongArray().length, (int)2);
        Assert.assertEquals((long[])this.converterBean.getMylongArray(), (long[])new long[]{1234567890L, 1999999999L});
        Assert.assertEquals((int)this.converterBean.getMySinglelongArray().length, (int)1);
        Assert.assertEquals((long[])this.converterBean.getMySinglelongArray(), (long[])new long[]{1234567890L});
    }

    @Test
    public void testLongListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLongList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLongList(), Arrays.asList(1234567890L, 1999999999L));
        Assert.assertEquals((int)this.converterBean.getMySingleLongList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleLongList(), Arrays.asList(1234567890L));
    }

    @Test
    public void testLongSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLongSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLongSet(), new LinkedHashSet<Long>(Arrays.asList(1234567890L, 1999999999L)));
        Assert.assertEquals((int)this.converterBean.getMySingleLongSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleLongSet(), Collections.singleton(1234567890L));
    }

    @Test
    public void testFloatArrayLookupProgrammatically() {
        Object[] value = (Float[])this.config.getValue("tck.config.test.javaconfig.converter.floatvalues", Float[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Float[]{Float.valueOf(12.34f), Float.valueOf(99.99f)});
        Object[] single = (Float[])this.config.getValue("tck.config.test.javaconfig.converter.floatvalue", Float[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Float[]{Float.valueOf(12.34f)});
    }

    @Test
    public void testGetFloatArrayConverter() {
        Object[] value = (Float[])((Converter)this.config.getConverter(Float[].class).get()).convert("12.34,99.99");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Float[]{Float.valueOf(12.34f), Float.valueOf(99.99f)});
        Object[] single = (Float[])((Converter)this.config.getConverter(Float[].class).get()).convert("12.34");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Float[]{Float.valueOf(12.34f)});
    }

    @Test
    public void testOptionalFloatArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.floatvalues", Float[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (Float[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Float[]{Float.valueOf(12.34f), Float.valueOf(99.99f)});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.floatvalue", Float[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (Float[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Float[]{Float.valueOf(12.34f)});
    }

    @Test
    public void testFloatListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.floatvalues", Float.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(Float.valueOf(12.34f), Float.valueOf(99.99f)));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.floatvalue", Float.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(Float.valueOf(12.34f)));
    }

    @Test
    public void testOptionalFloatListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.floatvalues", Float.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(Float.valueOf(12.34f), Float.valueOf(99.99f)));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.floatvalue", Float.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(Float.valueOf(12.34f)));
    }

    @Test
    public void testFloatArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyFloatArray().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyFloatArray(), (Object[])new Float[]{Float.valueOf(12.34f), Float.valueOf(99.99f)});
        Assert.assertEquals((int)this.converterBean.getMySingleFloatArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleFloatArray(), (Object[])new Float[]{Float.valueOf(12.34f)});
    }

    @Test
    public void testGetfloatArrayConverter() {
        float[] value = (float[])((Converter)this.config.getConverter(float[].class).get()).convert("12.34,99.99");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object)value, (Object)new Float[]{Float.valueOf(12.34f), Float.valueOf(99.99f)});
        float[] single = (float[])((Converter)this.config.getConverter(float[].class).get()).convert("12.34");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object)single, (Object)new Float[]{Float.valueOf(12.34f)});
    }

    @Test
    public void testfloatArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyfloatArray().length, (int)2);
        Assert.assertEquals((float[])this.converterBean.getMyfloatArray(), (float[])new float[]{12.34f, 99.99f});
        Assert.assertEquals((int)this.converterBean.getMySinglefloatArray().length, (int)1);
        Assert.assertEquals((float[])this.converterBean.getMySinglefloatArray(), (float[])new float[]{12.34f});
    }

    @Test
    public void testFloatListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyFloatList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyFloatList(), Arrays.asList(Float.valueOf(12.34f), Float.valueOf(99.99f)));
        Assert.assertEquals((int)this.converterBean.getMySingleFloatList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleFloatList(), Arrays.asList(Float.valueOf(12.34f)));
    }

    @Test
    public void testFloatSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyFloatSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyFloatSet(), new LinkedHashSet<Float>(Arrays.asList(Float.valueOf(12.34f), Float.valueOf(99.99f))));
        Assert.assertEquals((int)this.converterBean.getMySingleFloatSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleFloatSet(), Collections.singleton(Float.valueOf(12.34f)));
    }

    @Test
    public void testDoubleArrayLookupProgrammatically() {
        Object[] value = (Double[])this.config.getValue("tck.config.test.javaconfig.converter.doublevalues", Double[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Double[]{12.34, 99.9999});
        Object[] single = (Double[])this.config.getValue("tck.config.test.javaconfig.converter.doublevalue", Double[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Double[]{12.34});
    }

    @Test
    public void testGetDoubleArrayConverter() {
        Object[] value = (Double[])((Converter)this.config.getConverter(Double[].class).get()).convert("12.34,99.9999");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Double[]{12.34, 99.9999});
        Object[] single = (Double[])((Converter)this.config.getConverter(Double[].class).get()).convert("12.34");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Double[]{12.34});
    }

    @Test
    public void testOptionalDoubleArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.doublevalues", Double[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (Double[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Double[]{12.34, 99.9999});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.doublevalue", Double[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (Double[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Double[]{12.34});
    }

    @Test
    public void testDoubleListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.doublevalues", Double.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(12.34, 99.9999));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.doublevalue", Double.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(12.34));
    }

    @Test
    public void testOptionalDoubleListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.doublevalues", Double.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(12.34, 99.9999));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.doublevalue", Double.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(12.34));
    }

    @Test
    public void testDoubleArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDoubleArray().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyDoubleArray(), (Object[])new Double[]{12.34, 99.9999});
        Assert.assertEquals((int)this.converterBean.getMySingleDoubleArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleDoubleArray(), (Object[])new Double[]{12.34});
    }

    @Test
    public void testGetdoubleArrayConverter() {
        double[] value = (double[])((Converter)this.config.getConverter(double[].class).get()).convert("12.34,99.9999");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object)value, (Object)new Double[]{12.34, 99.9999});
        double[] single = (double[])((Converter)this.config.getConverter(double[].class).get()).convert("12.34");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object)single, (Object)new Double[]{12.34});
    }

    @Test
    public void testdoubleArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMydoubleArray().length, (int)2);
        Assert.assertEquals((double[])this.converterBean.getMydoubleArray(), (double[])new double[]{12.34, 99.9999});
        Assert.assertEquals((int)this.converterBean.getMySingledoubleArray().length, (int)1);
        Assert.assertEquals((double[])this.converterBean.getMySingledoubleArray(), (double[])new double[]{12.34});
    }

    @Test
    public void testDoubleListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDoubleList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyDoubleList(), Arrays.asList(12.34, 99.9999));
        Assert.assertEquals((int)this.converterBean.getMySingleDoubleList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleDoubleList(), Arrays.asList(12.34));
    }

    @Test
    public void testDoubleSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDoubleSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyDoubleSet(), new LinkedHashSet<Double>(Arrays.asList(12.34, 99.9999)));
        Assert.assertEquals((int)this.converterBean.getMySingleDoubleSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleDoubleSet(), Collections.singleton(12.34));
    }

    @Test
    public void testDurationArrayLookupProgrammatically() {
        Object[] value = (Duration[])this.config.getValue("tck.config.test.javaconfig.converter.durationvalues", Duration[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Duration[]{Duration.parse("PT15M"), Duration.parse("PT20M")});
        Object[] single = (Duration[])this.config.getValue("tck.config.test.javaconfig.converter.durationvalue", Duration[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Duration[]{Duration.parse("PT15M")});
    }

    @Test
    public void testGetDurationArrayConverter() {
        Object[] value = (Duration[])((Converter)this.config.getConverter(Duration[].class).get()).convert("PT15M,PT20M");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Duration[]{Duration.parse("PT15M"), Duration.parse("PT20M")});
        Object[] single = (Duration[])((Converter)this.config.getConverter(Duration[].class).get()).convert("PT15M");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Duration[]{Duration.parse("PT15M")});
    }

    @Test
    public void testOptionalDurationArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.durationvalues", Duration[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (Duration[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Duration[]{Duration.parse("PT15M"), Duration.parse("PT20M")});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.durationvalue", Duration[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (Duration[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Duration[]{Duration.parse("PT15M")});
    }

    @Test
    public void testDurationListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.durationvalues", Duration.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(Duration.parse("PT15M"), Duration.parse("PT20M")));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.durationvalue", Duration.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(Duration.parse("PT15M")));
    }

    @Test
    public void testOptionalDurationListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.durationvalues", Duration.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(Duration.parse("PT15M"), Duration.parse("PT20M")));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.durationvalue", Duration.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(Duration.parse("PT15M")));
    }

    @Test
    public void testDurationArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDurationArray().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyDurationArray(), (Object[])new Duration[]{Duration.parse("PT15M"), Duration.parse("PT20M")});
        Assert.assertEquals((int)this.converterBean.getMySingleDurationArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleDurationArray(), (Object[])new Duration[]{Duration.parse("PT15M")});
    }

    @Test
    public void testDurationListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDurationList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyDurationList(), Arrays.asList(Duration.parse("PT15M"), Duration.parse("PT20M")));
        Assert.assertEquals((int)this.converterBean.getMySingleDurationList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleDurationList(), Arrays.asList(Duration.parse("PT15M")));
    }

    @Test
    public void testDurationSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDurationSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyDurationSet(), new LinkedHashSet<Duration>(Arrays.asList(Duration.parse("PT15M"), Duration.parse("PT20M"))));
        Assert.assertEquals((int)this.converterBean.getMySingleDurationSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleDurationSet(), Collections.singleton(Duration.parse("PT15M")));
    }

    @Test
    public void testLocalTimeArrayLookupProgrammatically() {
        Object[] value = (LocalTime[])this.config.getValue("tck.config.test.javaconfig.converter.localtimevalues", LocalTime[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalTime[]{LocalTime.parse("10:37"), LocalTime.parse("11:44")});
        Object[] single = (LocalTime[])this.config.getValue("tck.config.test.javaconfig.converter.localtimevalue", LocalTime[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new LocalTime[]{LocalTime.parse("10:37")});
    }

    @Test
    public void testGetLocalTimeArrayConverter() {
        Object[] value = (LocalTime[])((Converter)this.config.getConverter(LocalTime[].class).get()).convert("10:37,11:44");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalTime[]{LocalTime.parse("10:37"), LocalTime.parse("11:44")});
        Object[] single = (LocalTime[])((Converter)this.config.getConverter(LocalTime[].class).get()).convert("10:37");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new LocalTime[]{LocalTime.parse("10:37")});
    }

    @Test
    public void testOptionalLocalTimeArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.localtimevalues", LocalTime[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (LocalTime[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalTime[]{LocalTime.parse("10:37"), LocalTime.parse("11:44")});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.localtimevalue", LocalTime[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (LocalTime[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new LocalTime[]{LocalTime.parse("10:37")});
    }

    @Test
    public void testLocalTimeListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.localtimevalues", LocalTime.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(LocalTime.parse("10:37"), LocalTime.parse("11:44")));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.localtimevalue", LocalTime.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(LocalTime.parse("10:37")));
    }

    @Test
    public void testOptionalLocalTimeListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.localtimevalues", LocalTime.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(LocalTime.parse("10:37"), LocalTime.parse("11:44")));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.localtimevalue", LocalTime.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(LocalTime.parse("10:37")));
    }

    @Test
    public void testLocalTimeArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocaltimeArray().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyLocaltimeArray(), (Object[])new LocalTime[]{LocalTime.parse("10:37"), LocalTime.parse("11:44")});
        Assert.assertEquals((int)this.converterBean.getMySingleLocaltimeArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleLocaltimeArray(), (Object[])new LocalTime[]{LocalTime.parse("10:37")});
    }

    @Test
    public void testLocalTimeListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalTimeList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalTimeList(), Arrays.asList(LocalTime.parse("10:37"), LocalTime.parse("11:44")));
        Assert.assertEquals((int)this.converterBean.getMySingleLocalTimeList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleLocalTimeList(), Arrays.asList(LocalTime.parse("10:37")));
    }

    @Test
    public void testLocalTimeSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalTimeSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalTimeSet(), new LinkedHashSet<LocalTime>(Arrays.asList(LocalTime.parse("10:37"), LocalTime.parse("11:44"))));
        Assert.assertEquals((int)this.converterBean.getMySingleLocalTimeSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleLocalTimeSet(), Collections.singleton(LocalTime.parse("10:37")));
    }

    @Test
    public void testLocalDateArrayLookupProgrammatically() {
        Object[] value = (LocalDate[])this.config.getValue("tck.config.test.javaconfig.converter.localdatevalues", LocalDate[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalDate[]{LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29")});
        Object[] single = (LocalDate[])this.config.getValue("tck.config.test.javaconfig.converter.localdatevalue", LocalDate[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new LocalDate[]{LocalDate.parse("2017-12-24")});
    }

    @Test
    public void testGetLocalDateArrayConverter() {
        Object[] value = (LocalDate[])((Converter)this.config.getConverter(LocalDate[].class).get()).convert("2017-12-24,2017-11-29");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalDate[]{LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29")});
        Object[] single = (LocalDate[])((Converter)this.config.getConverter(LocalDate[].class).get()).convert("2017-12-24");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new LocalDate[]{LocalDate.parse("2017-12-24")});
    }

    @Test
    public void testOptionalLocalDateArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.localdatevalues", LocalDate[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (LocalDate[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalDate[]{LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29")});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.localdatevalue", LocalDate[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (LocalDate[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new LocalDate[]{LocalDate.parse("2017-12-24")});
    }

    @Test
    public void testLocalDateListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.localdatevalues", LocalDate.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29")));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.localdatevalue", LocalDate.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(LocalDate.parse("2017-12-24")));
    }

    @Test
    public void testOptionalLocalDateListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.localdatevalues", LocalDate.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29")));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.localdatevalue", LocalDate.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(LocalDate.parse("2017-12-24")));
    }

    @Test
    public void testLocalDateArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalDateArray().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyLocalDateArray(), (Object[])new LocalDate[]{LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29")});
        Assert.assertEquals((int)this.converterBean.getMySingleLocalDateArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleLocalDateArray(), (Object[])new LocalDate[]{LocalDate.parse("2017-12-24")});
    }

    @Test
    public void testLocalDateListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalDateList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalDateList(), Arrays.asList(LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29")));
        Assert.assertEquals((int)this.converterBean.getMySingleLocalDateList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleLocalDateList(), Arrays.asList(LocalDate.parse("2017-12-24")));
    }

    @Test
    public void testLocalDateSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalDateSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalDateSet(), new LinkedHashSet<LocalDate>(Arrays.asList(LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29"))));
        Assert.assertEquals((int)this.converterBean.getMySingleLocalDateSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleLocalDateSet(), Collections.singleton(LocalDate.parse("2017-12-24")));
    }

    @Test
    public void testLocalDateTimeArrayLookupProgrammatically() {
        Object[] value = (LocalDateTime[])this.config.getValue("tck.config.test.javaconfig.converter.localdatetimevalues", LocalDateTime[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalDateTime[]{LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33")});
        Object[] single = (LocalDateTime[])this.config.getValue("tck.config.test.javaconfig.converter.localdatetimevalue", LocalDateTime[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new LocalDateTime[]{LocalDateTime.parse("2017-12-24T10:25:30")});
    }

    @Test
    public void testGetLocalDateTimeArrayConverter() {
        Object[] value = (LocalDateTime[])((Converter)this.config.getConverter(LocalDateTime[].class).get()).convert("2017-12-24T10:25:30,2017-12-24T10:25:33");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalDateTime[]{LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33")});
        Object[] single = (LocalDateTime[])((Converter)this.config.getConverter(LocalDateTime[].class).get()).convert("2017-12-24T10:25:30");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new LocalDateTime[]{LocalDateTime.parse("2017-12-24T10:25:30")});
    }

    @Test
    public void testOptionalLocalDateTimeArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.localdatetimevalues", LocalDateTime[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (LocalDateTime[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalDateTime[]{LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33")});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.localdatetimevalue", LocalDateTime[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (LocalDateTime[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new LocalDateTime[]{LocalDateTime.parse("2017-12-24T10:25:30")});
    }

    @Test
    public void testLocalDateTimeListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.localdatetimevalues", LocalDateTime.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33")));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.localdatetimevalue", LocalDateTime.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(LocalDateTime.parse("2017-12-24T10:25:30")));
    }

    @Test
    public void testOptionalLocalDateTimeListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.localdatetimevalues", LocalDateTime.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33")));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.localdatetimevalue", LocalDateTime.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(LocalDateTime.parse("2017-12-24T10:25:30")));
    }

    @Test
    public void testLocalDateTimeArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalDateTimeArray().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyLocalDateTimeArray(), (Object[])new LocalDateTime[]{LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33")});
        Assert.assertEquals((int)this.converterBean.getMySingleLocalDateTimeArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleLocalDateTimeArray(), (Object[])new LocalDateTime[]{LocalDateTime.parse("2017-12-24T10:25:30")});
    }

    @Test
    public void testLocalDateTimeListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalDateTimeList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalDateTimeList(), Arrays.asList(LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33")));
        Assert.assertEquals((int)this.converterBean.getMySingleLocalDateTimeList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleLocalDateTimeList(), Arrays.asList(LocalDateTime.parse("2017-12-24T10:25:30")));
    }

    @Test
    public void testLocalDateTimeSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalDateTimeSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalDateTimeSet(), new LinkedHashSet<LocalDateTime>(Arrays.asList(LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33"))));
        Assert.assertEquals((int)this.converterBean.getMySingleLocalDateTimeSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleLocalDateTimeSet(), Collections.singleton(LocalDateTime.parse("2017-12-24T10:25:30")));
    }

    @Test
    public void testOffsetDateTimeArrayLookupProgrammatically() {
        Object[] value = (OffsetDateTime[])this.config.getValue("tck.config.test.javaconfig.converter.offsetdatetimevalues", OffsetDateTime[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new OffsetDateTime[]{OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00")});
        Object[] single = (OffsetDateTime[])this.config.getValue("tck.config.test.javaconfig.converter.offsetdatetimevalue", OffsetDateTime[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new OffsetDateTime[]{OffsetDateTime.parse("2007-12-03T10:15:30+01:00")});
    }

    @Test
    public void testGetOffsetDateTimeArrayConverter() {
        Object[] value = (OffsetDateTime[])((Converter)this.config.getConverter(OffsetDateTime[].class).get()).convert("2007-12-03T10:15:30+01:00,2007-12-03T10:15:30+02:00");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new OffsetDateTime[]{OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00")});
        Object[] single = (OffsetDateTime[])((Converter)this.config.getConverter(OffsetDateTime[].class).get()).convert("2007-12-03T10:15:30+01:00");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new OffsetDateTime[]{OffsetDateTime.parse("2007-12-03T10:15:30+01:00")});
    }

    @Test
    public void testOptionalOffsetDateTimeArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.offsetdatetimevalues", OffsetDateTime[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (OffsetDateTime[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new OffsetDateTime[]{OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00")});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.offsetdatetimevalue", OffsetDateTime[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (OffsetDateTime[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new OffsetDateTime[]{OffsetDateTime.parse("2007-12-03T10:15:30+01:00")});
    }

    @Test
    public void testOffsetDateTimeListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.offsetdatetimevalues", OffsetDateTime.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00")));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.offsetdatetimevalue", OffsetDateTime.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(OffsetDateTime.parse("2007-12-03T10:15:30+01:00")));
    }

    @Test
    public void testOptionalOffsetDateTimeListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.offsetdatetimevalues", OffsetDateTime.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00")));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.offsetdatetimevalue", OffsetDateTime.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(OffsetDateTime.parse("2007-12-03T10:15:30+01:00")));
    }

    @Test
    public void testOffsetDateTimeArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetDateTimeArray().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyOffsetDateTimeArray(), (Object[])new OffsetDateTime[]{OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00")});
        Assert.assertEquals((int)this.converterBean.getMySingleOffsetDateTimeArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleOffsetDateTimeArray(), (Object[])new OffsetDateTime[]{OffsetDateTime.parse("2007-12-03T10:15:30+01:00")});
    }

    @Test
    public void testOffsetDateTimeListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetDateTimeList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyOffsetDateTimeList(), Arrays.asList(OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00")));
        Assert.assertEquals((int)this.converterBean.getMySingleOffsetDateTimeList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleOffsetDateTimeList(), Arrays.asList(OffsetDateTime.parse("2007-12-03T10:15:30+01:00")));
    }

    @Test
    public void testOffsetDateTimeSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetDateTimeSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyOffsetDateTimeSet(), new LinkedHashSet<OffsetDateTime>(Arrays.asList(OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00"))));
        Assert.assertEquals((int)this.converterBean.getMySingleOffsetDateTimeSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleOffsetDateTimeSet(), Collections.singleton(OffsetDateTime.parse("2007-12-03T10:15:30+01:00")));
    }

    @Test
    public void testOffsetTimeArrayLookupProgrammatically() {
        Object[] value = (OffsetTime[])this.config.getValue("tck.config.test.javaconfig.converter.offsettimevalues", OffsetTime[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new OffsetTime[]{OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00")});
        Object[] single = (OffsetTime[])this.config.getValue("tck.config.test.javaconfig.converter.offsettimevalue", OffsetTime[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new OffsetTime[]{OffsetTime.parse("13:45:30.123456789+02:00")});
    }

    @Test
    public void testGetOffsetTimeArrayConverter() {
        Object[] value = (OffsetTime[])((Converter)this.config.getConverter(OffsetTime[].class).get()).convert("13:45:30.123456789+02:00,13:45:30.123456789+03:00");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new OffsetTime[]{OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00")});
        Object[] single = (OffsetTime[])((Converter)this.config.getConverter(OffsetTime[].class).get()).convert("13:45:30.123456789+02:00");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new OffsetTime[]{OffsetTime.parse("13:45:30.123456789+02:00")});
    }

    @Test
    public void testOptionalOffsetTimeArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.offsettimevalues", OffsetTime[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (OffsetTime[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new OffsetTime[]{OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00")});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.offsettimevalue", OffsetTime[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (OffsetTime[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new OffsetTime[]{OffsetTime.parse("13:45:30.123456789+02:00")});
    }

    @Test
    public void testOffsetTimeListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.offsettimevalues", OffsetTime.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00")));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.offsettimevalue", OffsetTime.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(OffsetTime.parse("13:45:30.123456789+02:00")));
    }

    @Test
    public void testOptionalOffsetTimeListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.offsettimevalues", OffsetTime.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00")));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.offsettimevalue", OffsetTime.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(OffsetTime.parse("13:45:30.123456789+02:00")));
    }

    @Test
    public void testOffsetTimeArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetTimeArray().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyOffsetTimeArray(), (Object[])new OffsetTime[]{OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00")});
        Assert.assertEquals((int)this.converterBean.getMySingleOffsetTimeArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleOffsetTimeArray(), (Object[])new OffsetTime[]{OffsetTime.parse("13:45:30.123456789+02:00")});
    }

    @Test
    public void testOffsetTimeListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetTimeList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyOffsetTimeList(), Arrays.asList(OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00")));
        Assert.assertEquals((int)this.converterBean.getMySingleOffsetTimeList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleOffsetTimeList(), Arrays.asList(OffsetTime.parse("13:45:30.123456789+02:00")));
    }

    @Test
    public void testOffsetTimeSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetTimeSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyOffsetTimeSet(), new LinkedHashSet<OffsetTime>(Arrays.asList(OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00"))));
        Assert.assertEquals((int)this.converterBean.getMySingleOffsetTimeSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleOffsetTimeSet(), Collections.singleton(OffsetTime.parse("13:45:30.123456789+02:00")));
    }

    @Test
    public void testInstantArrayLookupProgrammatically() {
        Object[] value = (Instant[])this.config.getValue("tck.config.test.javaconfig.converter.instantvalues", Instant[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Instant[]{Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z")});
        Object[] single = (Instant[])this.config.getValue("tck.config.test.javaconfig.converter.instantvalue", Instant[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Instant[]{Instant.parse("2015-06-02T21:34:33.616Z")});
    }

    @Test
    public void testGetInstantArrayConverter() {
        Object[] value = (Instant[])((Converter)this.config.getConverter(Instant[].class).get()).convert("2015-06-02T21:34:33.616Z,2017-06-02T21:34:33.616Z");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Instant[]{Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z")});
        Object[] single = (Instant[])((Converter)this.config.getConverter(Instant[].class).get()).convert("2015-06-02T21:34:33.616Z");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Instant[]{Instant.parse("2015-06-02T21:34:33.616Z")});
    }

    @Test
    public void testOptionalInstantArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.instantvalues", Instant[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (Instant[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Instant[]{Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z")});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.instantvalue", Instant[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (Instant[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Instant[]{Instant.parse("2015-06-02T21:34:33.616Z")});
    }

    @Test
    public void testInstantListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.instantvalues", Instant.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z")));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.instantvalue", Instant.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(Instant.parse("2015-06-02T21:34:33.616Z")));
    }

    @Test
    public void testOptionalInstantListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.instantvalues", Instant.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertEquals((Collection)values, Arrays.asList(Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z")));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.instantvalue", Instant.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(Instant.parse("2015-06-02T21:34:33.616Z")));
    }

    @Test
    public void testInstantArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyInstantArray().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyInstantArray(), (Object[])new Instant[]{Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z")});
        Assert.assertEquals((int)this.converterBean.getMySingleInstantArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleInstantArray(), (Object[])new Instant[]{Instant.parse("2015-06-02T21:34:33.616Z")});
    }

    @Test
    public void testInstantListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyInstantList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyInstantList(), Arrays.asList(Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z")));
        Assert.assertEquals((int)this.converterBean.getMySingleInstantList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleInstantList(), Arrays.asList(Instant.parse("2015-06-02T21:34:33.616Z")));
    }

    @Test
    public void testInstantSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyInstantSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyInstantList(), new LinkedHashSet<Instant>(Arrays.asList(Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z"))));
        Assert.assertEquals((int)this.converterBean.getMySingleInstantSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleInstantSet(), Collections.singleton(Instant.parse("2015-06-02T21:34:33.616Z")));
    }

    @Test
    public void testUrlArrayLookupProgrammatically() throws MalformedURLException, URISyntaxException {
        URL[] value = (URL[])this.config.getValue("tck.config.test.javaconfig.converter.urlvalues", URL[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        URL[] expectedValue = new URL[]{new URL("http://microprofile.io"), new URL("http://openliberty.io"), new URL("http://microprofile.io")};
        AdditionalAssertions.assertURLArrayEquals(value, expectedValue);
        URL[] single = (URL[])this.config.getValue("tck.config.test.javaconfig.converter.urlvalue", URL[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        URL[] expectedSingleValue = new URL[]{new URL("http://microprofile.io")};
        AdditionalAssertions.assertURLArrayEquals(single, expectedSingleValue);
    }

    @Test
    public void testGetUrlArrayConverter() throws MalformedURLException, URISyntaxException {
        URL[] value = (URL[])((Converter)this.config.getConverter(URL[].class).get()).convert("http://microprofile.io,http://openliberty.io,http://microprofile.io");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        URL[] expectedValue = new URL[]{new URL("http://microprofile.io"), new URL("http://openliberty.io"), new URL("http://microprofile.io")};
        AdditionalAssertions.assertURLArrayEquals(value, expectedValue);
        URL[] single = (URL[])((Converter)this.config.getConverter(URL[].class).get()).convert("http://microprofile.io");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        URL[] expectedSingleValue = new URL[]{new URL("http://microprofile.io")};
        AdditionalAssertions.assertURLArrayEquals(single, expectedSingleValue);
    }

    @Test
    public void testOptionalUrlArrayLookupProgrammatically() throws MalformedURLException, URISyntaxException {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.urlvalues", URL[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        URL[] value = (URL[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        URL[] expectedValue = new URL[]{new URL("http://microprofile.io"), new URL("http://openliberty.io"), new URL("http://microprofile.io")};
        AdditionalAssertions.assertURLArrayEquals(value, expectedValue);
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.urlvalue", URL[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        URL[] single = (URL[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        URL[] expectedSingleValue = new URL[]{new URL("http://microprofile.io")};
        AdditionalAssertions.assertURLArrayEquals(single, expectedSingleValue);
    }

    @Test
    public void testUrlListLookupProgrammatically() throws MalformedURLException, URISyntaxException {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.urlvalues", URL.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)3);
        List<URL> expectedValue = Arrays.asList(new URL("http://microprofile.io"), new URL("http://openliberty.io"), new URL("http://microprofile.io"));
        AdditionalAssertions.assertURLListEquals(values, expectedValue);
        List single = this.config.getValues("tck.config.test.javaconfig.converter.urlvalue", URL.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        List<URL> expectedSingleValue = Arrays.asList(new URL("http://microprofile.io"));
        Assert.assertEquals((Collection)single, expectedSingleValue);
    }

    @Test
    public void testOptionalUrlListLookupProgrammatically() throws MalformedURLException, URISyntaxException {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.urlvalues", URL.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)3);
        List<URL> expectedValue = Arrays.asList(new URL("http://microprofile.io"), new URL("http://openliberty.io"), new URL("http://microprofile.io"));
        AdditionalAssertions.assertURLListEquals(values, expectedValue);
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.urlvalue", URL.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        List<URL> expectedSingleValue = Arrays.asList(new URL("http://microprofile.io"));
        Assert.assertEquals((Collection)single, expectedSingleValue);
    }

    @Test
    public void testUrlArrayInjection() throws MalformedURLException, URISyntaxException {
        URL[] values = this.converterBean.getMyUrlArray();
        Assert.assertEquals((int)values.length, (int)3);
        URL[] expectedValue = new URL[]{new URL("http://microprofile.io"), new URL("http://openliberty.io"), new URL("http://microprofile.io")};
        AdditionalAssertions.assertURLArrayEquals(values, expectedValue);
        Assert.assertEquals((int)this.converterBean.getMySingleUrlArray().length, (int)1);
        URL[] expectedSingleValue = new URL[]{new URL("http://microprofile.io")};
        AdditionalAssertions.assertURLArrayEquals(this.converterBean.getMySingleUrlArray(), expectedSingleValue);
    }

    @Test
    public void testURLListInjection() throws MalformedURLException, URISyntaxException {
        List<URL> values = this.converterBean.getMyUrlList();
        Assert.assertEquals((int)values.size(), (int)3);
        List<URL> expectedValue = Arrays.asList(new URL("http://microprofile.io"), new URL("http://openliberty.io"), new URL("http://microprofile.io"));
        AdditionalAssertions.assertURLListEquals(values, expectedValue);
        Assert.assertEquals((int)this.converterBean.getMySingleUrlList().size(), (int)1);
        List<URL> expectedSingleValue = Arrays.asList(new URL("http://microprofile.io"));
        Assert.assertEquals(this.converterBean.getMySingleUrlList(), expectedSingleValue);
    }

    @Test
    public void testURLSetInjection() throws MalformedURLException, URISyntaxException {
        Set<URL> values = this.converterBean.getMyUrlSet();
        Assert.assertEquals((int)values.size(), (int)2);
        LinkedHashSet<URL> expectedURLSet = new LinkedHashSet<URL>(Arrays.asList(new URL("http://openliberty.io"), new URL("http://microprofile.io")));
        AdditionalAssertions.assertURLSetEquals(values, expectedURLSet);
        Assert.assertEquals((int)this.converterBean.getMySingleUrlSet().size(), (int)1);
        Set<URL> expectedSingleUrlSet = Collections.singleton(new URL("http://microprofile.io"));
        AdditionalAssertions.assertURLSetEquals(this.converterBean.getMySingleUrlSet(), expectedSingleUrlSet);
    }

    @Test
    public void testUriArrayLookupProgrammatically() {
        Object[] value = (URI[])this.config.getValue("tck.config.test.javaconfig.converter.urlvalues", URI[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new URI[]{URI.create("http://microprofile.io"), URI.create("http://openliberty.io"), URI.create("http://microprofile.io")});
        Object[] single = (URI[])this.config.getValue("tck.config.test.javaconfig.converter.urlvalue", URI[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new URI[]{URI.create("http://microprofile.io")});
    }

    @Test
    public void testGetUriArrayConverter() {
        Object[] value = (URI[])((Converter)this.config.getConverter(URI[].class).get()).convert("http://microprofile.io,http://openliberty.io,http://microprofile.io");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new URI[]{URI.create("http://microprofile.io"), URI.create("http://openliberty.io"), URI.create("http://microprofile.io")});
        Object[] single = (URI[])((Converter)this.config.getConverter(URI[].class).get()).convert("http://microprofile.io");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new URI[]{URI.create("http://microprofile.io")});
    }

    @Test
    public void testOptionalUriArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.urlvalues", URI[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (URI[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new URI[]{URI.create("http://microprofile.io"), URI.create("http://openliberty.io"), URI.create("http://microprofile.io")});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.urlvalue", URI[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (URI[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new URI[]{URI.create("http://microprofile.io")});
    }

    @Test
    public void testUriListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.urlvalues", URI.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)3);
        Assert.assertEquals((Collection)values, Arrays.asList(URI.create("http://microprofile.io"), URI.create("http://openliberty.io"), URI.create("http://microprofile.io")));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.urlvalue", URI.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(URI.create("http://microprofile.io")));
    }

    @Test
    public void testOptionalUriListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.urlvalues", URI.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)3);
        Assert.assertEquals((Collection)values, Arrays.asList(URI.create("http://microprofile.io"), URI.create("http://openliberty.io"), URI.create("http://microprofile.io")));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.urlvalue", URI.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(URI.create("http://microprofile.io")));
    }

    @Test
    public void testUriArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyUriArray().length, (int)3);
        Assert.assertEquals((Object[])this.converterBean.getMyUriArray(), (Object[])new URI[]{URI.create("http://microprofile.io"), URI.create("http://openliberty.io"), URI.create("http://microprofile.io")});
        Assert.assertEquals((int)this.converterBean.getMySingleUriArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySingleUriArray(), (Object[])new URI[]{URI.create("http://microprofile.io")});
    }

    @Test
    public void testUriListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyUriList().size(), (int)3);
        Assert.assertEquals(this.converterBean.getMyUriList(), Arrays.asList(URI.create("http://microprofile.io"), URI.create("http://openliberty.io"), URI.create("http://microprofile.io")));
        Assert.assertEquals((int)this.converterBean.getMySingleUriList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleUriList(), Arrays.asList(URI.create("http://microprofile.io")));
    }

    @Test
    public void testUriSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyUriSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyUriSet(), new LinkedHashSet<URI>(Arrays.asList(URI.create("http://openliberty.io"), URI.create("http://microprofile.io"))));
        Assert.assertEquals((int)this.converterBean.getMySingleUriSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySingleUriSet(), Collections.singleton(URI.create("http://microprofile.io")));
    }

    @Test
    public void testCustomTypeArrayLookupProgrammatically() {
        Object[] value = (Pizza[])this.config.getValue("tck.config.test.javaconfig.converter.array.pizza", Pizza[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new Pizza[]{new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small")});
        Object[] single = (Pizza[])this.config.getValue("tck.config.test.javaconfig.converter.pizza", Pizza[].class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Pizza[]{new Pizza("cheese,mushroom", "large")});
    }

    @Test
    public void testGetCustomTypeArrayConverter() {
        Object[] value = (Pizza[])((Converter)this.config.getConverter(Pizza[].class).get()).convert("large:cheese\\,mushroom,medium:chicken,small:pepperoni");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new Pizza[]{new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small")});
        Object[] single = (Pizza[])((Converter)this.config.getConverter(Pizza[].class).get()).convert("large:cheese\\,mushroom");
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Pizza[]{new Pizza("cheese,mushroom", "large")});
    }

    @Test
    public void testOptionalCustomTypeArrayLookupProgrammatically() {
        Optional optionalValue = this.config.getOptionalValue("tck.config.test.javaconfig.converter.array.pizza", Pizza[].class);
        Assert.assertTrue((boolean)optionalValue.isPresent());
        Object[] value = (Pizza[])optionalValue.get();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new Pizza[]{new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small")});
        Optional optionalSingle = this.config.getOptionalValue("tck.config.test.javaconfig.converter.pizza", Pizza[].class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        Object[] single = (Pizza[])optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.length, (int)1);
        Assert.assertEquals((Object[])single, (Object[])new Pizza[]{new Pizza("cheese,mushroom", "large")});
    }

    @Test
    public void testCustomTypeListLookupProgrammatically() {
        List values = this.config.getValues("tck.config.test.javaconfig.converter.array.pizza", Pizza.class);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)3);
        Assert.assertEquals((Collection)values, Arrays.asList(new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small")));
        List single = this.config.getValues("tck.config.test.javaconfig.converter.pizza", Pizza.class);
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(new Pizza("cheese,mushroom", "large")));
    }

    @Test
    public void testOptionalCustomTypeListLookupProgrammatically() {
        Optional optionalValues = this.config.getOptionalValues("tck.config.test.javaconfig.converter.array.pizza", Pizza.class);
        Assert.assertTrue((boolean)optionalValues.isPresent());
        List values = (List)optionalValues.get();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((int)values.size(), (int)3);
        Assert.assertEquals((Collection)values, Arrays.asList(new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small")));
        Optional optionalSingle = this.config.getOptionalValues("tck.config.test.javaconfig.converter.pizza", Pizza.class);
        Assert.assertTrue((boolean)optionalSingle.isPresent());
        List single = (List)optionalSingle.get();
        Assert.assertNotNull((Object)single);
        Assert.assertEquals((int)single.size(), (int)1);
        Assert.assertEquals((Collection)single, Arrays.asList(new Pizza("cheese,mushroom", "large")));
    }

    @Test
    public void testCustomTypeArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyPizzaArray().length, (int)3);
        Assert.assertEquals((Object[])this.converterBean.getMyPizzaArray(), (Object[])new Pizza[]{new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small")});
        Assert.assertEquals((int)this.converterBean.getMySinglePizzaArray().length, (int)1);
        Assert.assertEquals((Object[])this.converterBean.getMySinglePizzaArray(), (Object[])new Pizza[]{new Pizza("cheese,mushroom", "large")});
    }

    @Test
    public void testCustomTypeListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyPizzaList().size(), (int)3);
        Assert.assertEquals(this.converterBean.getMyPizzaList(), Arrays.asList(new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small")));
        Assert.assertEquals((int)this.converterBean.getMySinglePizzaList().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySinglePizzaList(), Arrays.asList(new Pizza("cheese,mushroom", "large")));
    }

    @Test
    public void testCustomTypeSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyPizzaSet().size(), (int)3);
        Assert.assertEquals(this.converterBean.getMyPizzaSet(), new LinkedHashSet<Pizza>(Arrays.asList(new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small"))));
        Assert.assertEquals((int)this.converterBean.getMySinglePizzaSet().size(), (int)1);
        Assert.assertEquals(this.converterBean.getMySinglePizzaSet(), Collections.singleton(new Pizza("cheese,mushroom", "large")));
    }
}

