/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.tck.Location;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigPropertiesTest
extends Arquillian {
    @Inject
    private BeanOne customerBeanOne;
    @Inject
    @ConfigProperties(prefix="client")
    private BeanOne clientBeanOne;
    @Inject
    @ConfigProperties
    private BeanOne beanOne;
    @Inject
    private BeanTwo beanTwo;
    @Inject
    @ConfigProperties(prefix="my")
    private BeanTwo myBeanTwo;
    @Inject
    private BeanFour myBeanFour;
    @Inject
    private BeanThree beanThree;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ConfigPropertiesTest.jar")).addClasses(new Class[]{ConfigPropertiesTest.class, BeanOne.class, BeanTwo.class, BeanThree.class, BeanFour.class, Location.class})).addAsManifestResource((Asset)new StringAsset("customer.name=Bob\ncustomer.age=24\ncustomer.location=2 Hook Road, Winchester, Hampshire, SO21 2JN, UK\ncustomer.job=Developer\ncustomer.new.hobbies=Badminton,Tennis\nclient.name=Rob\nclient.age=25\nclient.location=22 Hook Road, Winchester, Hampshire, SO21 2JN, UK\nclient.job=Engineer\nclient.new.hobbies=Football,Tennis\nname=Harry\nage=21\nnationality=UK\nlocation=222 Hook Road, Winchester, Hampshire, SO21 2JN, UK\njob=Plumber\nnew.hobbies=Volleyball\nhost=localhost\nport=9080\nendpoint=woof\nmy.host=myhost\nmy.port=9081\nmy.endpoint=poof\nother.name=Holly\nother.age=20\nother.nationality=USA\n"), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ConfigPropertiesTest.war")).addAsLibrary((Archive)testJar);
    }

    @Test
    public void testConfigPropertiesPlainInjection() {
        Assert.assertEquals((String)"Bob", (String)this.customerBeanOne.getName());
        Assert.assertEquals((int)24, (int)this.customerBeanOne.age);
        Assert.assertEquals((String)"Developer", (String)this.customerBeanOne.job);
        Assert.assertEquals((Object[])new String[]{"Badminton", "Tennis"}, (Object[])this.customerBeanOne.hobbies);
        Assert.assertEquals((Object)new Location("2 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)this.customerBeanOne.location);
    }

    @Test
    public void testConfigPropertiesWithPrefix() {
        Assert.assertEquals((String)"Rob", (String)this.clientBeanOne.getName());
        Assert.assertEquals((int)25, (int)this.clientBeanOne.age);
        Assert.assertEquals((String)"Engineer", (String)this.clientBeanOne.job);
        Assert.assertEquals((Object[])new String[]{"Football", "Tennis"}, (Object[])this.clientBeanOne.hobbies);
        Assert.assertEquals((Object)new Location("22 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)this.clientBeanOne.location);
        BeanOne bo = (BeanOne)CDI.current().select(BeanOne.class, new Annotation[]{ConfigProperties.Literal.of((String)"client")}).get();
        Assert.assertEquals((String)"Rob", (String)bo.getName());
        Assert.assertEquals((int)25, (int)bo.age);
        Assert.assertEquals((String)"Engineer", (String)bo.job);
        Assert.assertEquals((Object[])new String[]{"Football", "Tennis"}, (Object[])bo.hobbies);
        Assert.assertEquals((Object)new Location("22 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)bo.location);
    }

    @Test
    public void testConfigPropertiesWithoutPrefix() {
        Assert.assertEquals((String)"Harry", (String)this.beanOne.getName());
        Assert.assertEquals((int)21, (int)this.beanOne.age);
        Assert.assertEquals((String)"Plumber", (String)this.beanOne.job);
        Assert.assertEquals((Object[])new String[]{"Volleyball"}, (Object[])this.beanOne.hobbies);
        Assert.assertEquals((Object)new Location("222 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)this.beanOne.location);
        BeanOne bo = (BeanOne)CDI.current().select(BeanOne.class, new Annotation[]{ConfigProperties.Literal.NO_PREFIX}).get();
        Assert.assertEquals((String)"Harry", (String)bo.getName());
        Assert.assertEquals((int)21, (int)bo.age);
        Assert.assertEquals((String)"Plumber", (String)bo.job);
        Assert.assertEquals((Object[])new String[]{"Volleyball"}, (Object[])bo.hobbies);
        Assert.assertEquals((Object)new Location("222 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)bo.location);
    }

    @Test
    public void testConfigPropertiesNoPrefixOnBean() {
        Assert.assertEquals((String)"localhost", (String)this.beanTwo.getHost());
        Assert.assertEquals((int)9080, (int)this.beanTwo.port);
        Assert.assertEquals((String)"woof", (String)this.beanTwo.endpoint);
    }

    @Test
    public void testConfigPropertiesNoPrefixOnBeanThenSupplyPrefix() {
        Assert.assertEquals((String)"myhost", (String)this.myBeanTwo.getHost());
        Assert.assertEquals((int)9081, (int)this.myBeanTwo.port);
        Assert.assertEquals((String)"poof", (String)this.myBeanTwo.endpoint);
    }

    @Test
    public void testNoConfigPropertiesAnnotationInjection() {
        Assert.assertNull((Object)this.beanThree.name);
        Assert.assertEquals((int)0, (int)this.beanThree.age);
        Assert.assertNull((Object)this.beanThree.getNationality());
    }

    @Test
    public void testConfigPropertiesDefaultOnBean() {
        Assert.assertEquals((String)"mycloud.org", (String)this.myBeanFour.getHost());
        Assert.assertEquals((int)9080, (int)this.myBeanFour.port);
        Assert.assertFalse((boolean)this.myBeanFour.location.isPresent());
    }

    @ConfigProperties(prefix="cloud")
    public static class BeanFour {
        @ConfigProperty(name="a.host", defaultValue="mycloud.org")
        private String host;
        public int port = 9080;
        public Optional<String> location;

        public String getHost() {
            return this.host;
        }
    }

    public static class BeanThree {
        public String name;
        public int age;
        private String nationality;

        public String getNationality() {
            return this.nationality;
        }
    }

    @ConfigProperties
    @RequestScoped
    public static class BeanTwo {
        private String host;
        int port;
        String endpoint;

        public String getHost() {
            return this.host;
        }
    }

    @ConfigProperties(prefix="customer")
    public static class BeanOne {
        private String name;
        int age;
        public Location location;
        protected String job;
        @ConfigProperty(name="new.hobbies")
        public String[] hobbies;

        public String getName() {
            return this.name;
        }
    }
}

