/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.tck.Location;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigPropertiesTest
extends Arquillian {
    @Inject
    private BeanOne customerBeanOne;
    @Inject
    @ConfigProperties(prefix="client")
    private BeanOne clientBeanOne;
    @Inject
    @ConfigProperties
    private BeanOne beanOne;
    @Inject
    private BeanTwo beanTwo;
    @Inject
    @ConfigProperties(prefix="my")
    private BeanTwo myBeanTwo;
    @Inject
    private BeanFour myBeanFour;
    @Inject
    private BeanThree beanThree;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ConfigPropertiesTest.jar")).addClasses(new Class[]{ConfigPropertiesTest.class, BeanOne.class, BeanTwo.class, BeanThree.class, Location.class})).addAsManifestResource((Asset)new StringAsset("customer.name=Bob\ncustomer.age=24\ncustomer.location=2 Hook Road, Winchester, Hampshire, SO21 2JN, UK\ncustomer.job=Developer\ncustomer.new.hobbies=Badminton, Tennis\nclient.name=Rob\nclient.age=25\nclient.location=22 Hook Road, Winchester, Hampshire, SO21 2JN, UK\nclient.job=Engineer\nclient.new.hobbies=Football, Tennis\nname=Hob\nage=26\nlocation=222 Hook Road, Winchester, Hampshire, SO21 2JN, UK\njob=Plumber\nnew.hobbies=Volleyball\nhost=localhost\nport=9080\nendpoint=woof\nmy.host=myhost\nmy.port=9081\nmy.endpoint=poof\nname=Harry\nage=21\nnationality=UK\nother$name=Holly\nother$age=20\nother$nationality=USA\n"), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ConfigPropertiesTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testConfigPropertiesPlainInjection() {
        Assert.assertEquals((String)"Bob", (String)this.customerBeanOne.getName());
        Assert.assertEquals((int)24, (int)this.customerBeanOne.age);
        Assert.assertEquals((String)"Developer", (String)this.customerBeanOne.job);
        Assert.assertEquals((Object[])new String[]{"Badminton", "Tennis"}, (Object[])this.customerBeanOne.hobbies);
        Assert.assertEquals((Object)new Location("2 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)this.customerBeanOne.location);
    }

    @Test
    public void testConfigPropertiesProgrammatic() {
        Config config = ConfigProvider.getConfig();
        BeanOne cBeanOne = (BeanOne)config.getConfigProperties(BeanOne.class);
        Assert.assertEquals((String)"Bob", (String)cBeanOne.getName());
        Assert.assertEquals((int)24, (int)cBeanOne.age);
        Assert.assertEquals((String)"Developer", (String)cBeanOne.job);
        Assert.assertEquals((Object[])new String[]{"Badminton", "Tennis"}, (Object[])cBeanOne.hobbies);
        Assert.assertEquals((Object)new Location("2 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)cBeanOne.location);
    }

    @Test
    public void testConfigPropertiesWithPrefix() {
        Assert.assertEquals((String)"Rob", (String)this.clientBeanOne.getName());
        Assert.assertEquals((int)25, (int)this.clientBeanOne.age);
        Assert.assertEquals((String)"Engineer", (String)this.clientBeanOne.job);
        Assert.assertEquals((Object[])new String[]{"Football", "Tennis"}, (Object[])this.clientBeanOne.hobbies);
        Assert.assertEquals((Object)new Location("22 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)this.clientBeanOne.location);
        BeanOne bo = (BeanOne)CDI.current().select(BeanOne.class, new Annotation[]{ConfigProperties.Literal.of((String)"client.")}).get();
        Assert.assertEquals((String)"Rob", (String)bo.getName());
        Assert.assertEquals((int)25, (int)bo.age);
        Assert.assertEquals((String)"Engineer", (String)bo.job);
        Assert.assertEquals((Object[])new String[]{"Football", "Tennis"}, (Object[])bo.hobbies);
        Assert.assertEquals((Object)new Location("22 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)bo.location);
    }

    @Test
    public void testConfigPropertiesWithPrefixProgrammatic() {
        Config config = ConfigProvider.getConfig();
        BeanOne cBeanOne = (BeanOne)config.getConfigProperties(BeanOne.class, "client.");
        Assert.assertEquals((String)"Rob", (String)cBeanOne.getName());
        Assert.assertEquals((int)25, (int)cBeanOne.age);
        Assert.assertEquals((String)"Engineer", (String)cBeanOne.job);
        Assert.assertEquals((Object[])new String[]{"Football", "Tennis"}, (Object[])cBeanOne.hobbies);
        Assert.assertEquals((Object)new Location("22 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)cBeanOne.location);
    }

    @Test
    public void testConfigPropertiesWithoutPrefix() {
        Assert.assertEquals((String)"Hob", (String)this.beanOne.getName());
        Assert.assertEquals((int)26, (int)this.beanOne.age);
        Assert.assertEquals((String)"Plumber", (String)this.beanOne.job);
        Assert.assertEquals((Object[])new String[]{"Volleyball"}, (Object[])this.beanOne.hobbies);
        Assert.assertEquals((Object)new Location("222 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)this.beanOne.location);
        BeanOne bo = (BeanOne)CDI.current().select(BeanOne.class, new Annotation[]{ConfigProperties.Literal.NOPREFIX}).get();
        Assert.assertEquals((String)"Hob", (String)bo.getName());
        Assert.assertEquals((int)26, (int)bo.age);
        Assert.assertEquals((String)"Plumber", (String)bo.job);
        Assert.assertEquals((Object[])new String[]{"Volleyball"}, (Object[])bo.hobbies);
        Assert.assertEquals((Object)new Location("222 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)bo.location);
    }

    @Test
    public void testConfigPropertiesWithoutPrefixProgrammatic() {
        Config config = ConfigProvider.getConfig();
        BeanOne beanOne = (BeanOne)config.getConfigProperties(BeanOne.class, "");
        Assert.assertEquals((String)"Hob", (String)beanOne.getName());
        Assert.assertEquals((int)26, (int)beanOne.age);
        Assert.assertEquals((String)"Plumber", (String)beanOne.job);
        Assert.assertEquals((Object[])new String[]{"Volleyball"}, (Object[])beanOne.hobbies);
        Assert.assertEquals((Object)new Location("222 Hook Road, Winchester, Hampshire, SO21 2JN, UK"), (Object)beanOne.location);
    }

    @Test
    public void testConfigPropertiesNoPrefixOnBean() {
        Assert.assertEquals((String)"localhost", (String)this.beanTwo.getHost());
        Assert.assertEquals((Object)"9080", (Object)this.beanTwo.port);
        Assert.assertEquals((String)"woof", (String)this.beanTwo.endpoint);
    }

    @Test
    public void testConfigPropertiesNoPrefixOnBeanProgrammatic() {
        Config config = ConfigProvider.getConfig();
        BeanTwo myBeanTwo = (BeanTwo)config.getConfigProperties(BeanTwo.class);
        Assert.assertEquals((String)"localhost", (String)myBeanTwo.getHost());
        Assert.assertEquals((Object)"9080", (Object)myBeanTwo.port);
        Assert.assertEquals((String)"woof", (String)myBeanTwo.endpoint);
    }

    @Test
    public void testConfigPropertiesNoPrefixOnBeanThenSupplyPrefix() {
        Assert.assertEquals((String)"myhost", (String)this.myBeanTwo.getHost());
        Assert.assertEquals((Object)"9081", (Object)this.myBeanTwo.port);
        Assert.assertEquals((String)"poof", (String)this.myBeanTwo.endpoint);
    }

    @Test
    public void testConfigPropertiesNoPrefixOnBeanThenSupplyPrefixProgrammatic() {
        Config config = ConfigProvider.getConfig();
        BeanTwo myBeanTwo = (BeanTwo)config.getConfigProperties(BeanTwo.class, "my.");
        Assert.assertEquals((String)"myhost", (String)myBeanTwo.getHost());
        Assert.assertEquals((Object)"9081", (Object)myBeanTwo.port);
        Assert.assertEquals((String)"poof", (String)myBeanTwo.endpoint);
    }

    @Test
    public void testNoConfigPropertiesAnnotationNoPrefixProgrammatic() {
        Config config = ConfigProvider.getConfig();
        BeanThree myBeanThree = (BeanThree)config.getConfigProperties(BeanThree.class);
        Assert.assertEquals((String)"Harry", (String)myBeanThree.name);
        Assert.assertEquals((int)21, (int)myBeanThree.age);
        Assert.assertEquals((String)"UK", (String)myBeanThree.getNationality());
        BeanThree anotherThree = (BeanThree)config.getConfigProperties(BeanThree.class, null);
        Assert.assertEquals((String)"Harry", (String)anotherThree.name);
        Assert.assertEquals((int)21, (int)anotherThree.age);
        Assert.assertEquals((String)"UK", (String)anotherThree.getNationality());
    }

    @Test
    public void testNoConfigPropertiesAnnotationWithPrefixProgrammatic() {
        Config config = ConfigProvider.getConfig();
        BeanThree myBeanThree = (BeanThree)config.getConfigProperties(BeanThree.class, "other$");
        Assert.assertEquals((String)"Holly", (String)myBeanThree.name);
        Assert.assertEquals((int)20, (int)myBeanThree.age);
        Assert.assertEquals((String)"USA", (String)myBeanThree.getNationality());
    }

    @Test
    public void testNoConfigPropertiesAnnotationInjection() {
        Assert.assertNull((Object)this.beanThree.name);
        Assert.assertEquals((int)0, (int)this.beanThree.age);
        Assert.assertNull((Object)this.beanThree.getNationality());
    }

    @Test
    public void testConfigPropertiesDefaultOnBean() {
        Assert.assertEquals((String)"mycloud.org", (String)this.myBeanFour.getHost());
        Assert.assertEquals((Object)"9080", (Object)this.myBeanFour.port);
        Assert.assertFalse((boolean)this.myBeanFour.location.isPresent());
    }

    @Test
    public void testConfigPropertiesDefaultOnBeanPL() {
        Config config = ConfigProvider.getConfig();
        BeanFour myBeanFour = (BeanFour)config.getConfigProperties(BeanFour.class);
        Assert.assertEquals((String)"mycloud.org", (String)myBeanFour.getHost());
        Assert.assertEquals((Object)"9080", (Object)myBeanFour.port);
        Assert.assertFalse((boolean)myBeanFour.location.isPresent());
    }

    @ConfigProperties(prefix="cloud.")
    @Dependent
    public static class BeanFour {
        @ConfigProperty(name="a.host", defaultValue="mycloud.org")
        private String host;
        public int port = 9080;
        public Optional<String> location;

        public String getHost() {
            return this.host;
        }
    }

    @Dependent
    public static class BeanThree {
        public String name;
        public int age;
        private String nationality;

        public String getNationality() {
            return this.nationality;
        }
    }

    @ConfigProperties
    @RequestScoped
    public static class BeanTwo {
        private String host;
        int port;
        String endpoint;

        public String getHost() {
            return this.host;
        }
    }

    @ConfigProperties(prefix="customer.")
    @Dependent
    public static class BeanOne {
        private String name;
        int age;
        public Location location;
        protected String job;
        @ConfigProperty(name="new.hobbies")
        public String[] hobbies;

        public String getName() {
            return this.name;
        }
    }
}

