/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.tck.base.AbstractTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigProviderTest
extends Arquillian {
    @Inject
    private Config config;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"configProviderTest.jar")).addPackage(AbstractTest.class.getPackage())).addClass(ConfigProviderTest.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        AbstractTest.addFile(testJar, "META-INF/microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"configProviderTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testEnvironmentConfigSource() {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> envEntry : env.entrySet()) {
            Assert.assertEquals((String)envEntry.getValue(), (String)((String)this.config.getValue(envEntry.getKey(), String.class)));
        }
    }

    @Test
    public void testPropertyConfigSource() {
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> propEntry : properties.entrySet()) {
            String propValue = (String)propEntry.getValue();
            if (propValue == null || propValue.length() <= 0) continue;
            Assert.assertEquals((String)propValue, (String)((String)this.config.getValue((String)propEntry.getKey(), String.class)));
        }
    }

    @Test
    public void testDynamicValueInPropertyConfigSource() {
        String configKey = "tck.config.test.systemproperty.dynamic.value";
        String configValue = "myDynamicValue;";
        System.setProperty(configKey, configValue);
        Assert.assertEquals((String)((String)this.config.getValue(configKey, String.class)), (String)configValue);
    }

    @Test
    public void testJavaConfigPropertyFilesConfigSource() {
        Assert.assertEquals((String)((String)this.config.getValue("tck.config.test.javaconfig.properties.key1", String.class)), (String)"VALue1");
    }

    @Test
    public void testNonExistingConfigKey() {
        Assert.assertFalse((boolean)this.config.getOptionalValue("tck.config.test.keydoesnotexist", String.class).isPresent());
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testNonExistingConfigKeyGet() {
        this.config.getValue("tck.config.test.keydoesnotexist", String.class);
    }

    @Test
    public void testGetConfigSources() {
        Iterable configSources = this.config.getConfigSources();
        Assert.assertNotNull((Object)configSources);
        int prevOrdinal = Integer.MAX_VALUE;
        for (ConfigSource configSource : configSources) {
            Assert.assertTrue((configSource.getOrdinal() <= prevOrdinal ? 1 : 0) != 0);
            prevOrdinal = configSource.getOrdinal();
        }
    }

    @Test
    public void testInjectedConfigSerializable() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);){
            out.writeObject(this.config);
        }
        catch (IOException ex) {
            Assert.fail((String)"Injected config should be serializable, but could not serialize it", (Throwable)ex);
        }
        Object readObject = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
            readObject = in.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)"Injected config should be serializable, but could not deserialize a previously serialized instance", (Throwable)ex);
        }
        MatcherAssert.assertThat((String)"Deserialized object", readObject, (Matcher)CoreMatchers.instanceOf(Config.class));
    }
}

