/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.tck.matchers.AdditionalMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class CDIPlainInjectionTest
extends Arquillian {
    @Deployment
    public static Archive deployment() {
        return ((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{CDIPlainInjectionTest.class, SimpleValuesBean.class, DynamicValuesBean.class, AdditionalMatchers.class, TestConfigSource.class})).addAsServiceProvider(ConfigSource.class, new Class[]{TestConfigSource.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void can_inject_simple_values_when_defined() {
        this.ensure_all_property_values_are_defined();
        SimpleValuesBean bean = this.getBeanOfType(SimpleValuesBean.class);
        MatcherAssert.assertThat((Object)bean.stringProperty, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"text")));
        MatcherAssert.assertThat((Object)bean.boolProperty, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)bean.intProperty, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)5)));
        MatcherAssert.assertThat((Object)bean.longProperty, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10L)));
        MatcherAssert.assertThat((Object)bean.floatProperty, (Matcher)Matchers.is(AdditionalMatchers.floatCloseTo(10.5f, 0.1f)));
        MatcherAssert.assertThat((Object)bean.doubleProperty, (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)11.5, (double)0.1)));
        MatcherAssert.assertThat((Object)bean.doublePropertyWithDefaultValue, (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)3.1415, (double)0.1)));
    }

    @Test
    public void can_inject_dynamic_values_via_CDI_provider() {
        this.clear_all_property_values();
        DynamicValuesBean bean = this.getBeanOfType(DynamicValuesBean.class);
        this.ensure_all_property_values_are_defined();
        MatcherAssert.assertThat((Object)bean.getIntProperty(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)5)));
    }

    private void ensure_all_property_values_are_defined() {
        System.setProperty("my.string.property", "text");
        System.setProperty("my.boolean.property", "true");
        System.setProperty("my.int.property", "5");
        System.setProperty("my.long.property", "10");
        System.setProperty("my.float.property", "10.5");
        System.setProperty("my.double.property", "11.5");
    }

    private void clear_all_property_values() {
        System.getProperties().remove("my.string.property");
        System.getProperties().remove("my.boolean.property");
        System.getProperties().remove("my.int.property");
        System.getProperties().remove("my.long.property");
        System.getProperties().remove("my.float.property");
        System.getProperties().remove("my.double.property");
    }

    private <T> T getBeanOfType(Class<T> beanClass) {
        return (T)CDI.current().select(beanClass, new Annotation[0]).get();
    }

    public static class TestConfigSource
    implements ConfigSource {
        private Map<String, String> properties = new HashMap<String, String>();

        public TestConfigSource() {
            this.properties.put("my.string.property", "text");
            this.properties.put("my.boolean.property", "true");
            this.properties.put("my.int.property", "5");
            this.properties.put("my.long.property", "10");
            this.properties.put("my.float.property", "10.5");
            this.properties.put("my.double.property", "11.5");
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public String getValue(String propertyName) {
            return this.properties.get(propertyName);
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    @Dependent
    public static class DynamicValuesBean {
        @Inject
        @ConfigProperty(name="my.int.property")
        private Provider<Integer> intPropertyProvider;

        public Integer getIntProperty() {
            return (Integer)this.intPropertyProvider.get();
        }
    }

    @Dependent
    public static class SimpleValuesBean {
        @Inject
        @ConfigProperty(name="my.string.property")
        private String stringProperty;
        @Inject
        @ConfigProperty(name="my.boolean.property")
        private Boolean boolProperty;
        @Inject
        @ConfigProperty(name="my.int.property")
        private Integer intProperty;
        @Inject
        @ConfigProperty(name="my.long.property")
        private Long longProperty;
        @Inject
        @ConfigProperty(name="my.float.property")
        private Float floatProperty;
        @Inject
        @ConfigProperty(name="my.double.property")
        private Double doubleProperty;
        @Inject
        @ConfigProperty(name="my.not.configured.double.property", defaultValue="3.1415")
        private Double doublePropertyWithDefaultValue;
    }
}

