/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.trs.server;

import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.lyo.core.trs.Base;
import org.eclipse.lyo.core.trs.ChangeEvent;
import org.eclipse.lyo.core.trs.ChangeLog;
import org.eclipse.lyo.core.trs.Creation;
import org.eclipse.lyo.core.trs.Deletion;
import org.eclipse.lyo.core.trs.Modification;
import org.eclipse.lyo.core.trs.Page;
import org.eclipse.lyo.oslc4j.core.model.IResource;
import org.eclipse.lyo.oslc4j.trs.server.HistoryData;
import org.eclipse.lyo.oslc4j.trs.server.PagedTrs;
import org.eclipse.lyo.oslc4j.trs.server.TRSUtil;
import org.eclipse.lyo.oslc4j.trs.server.TrsEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InmemPagedTrs
implements PagedTrs,
TrsEventHandler {
    private static final Logger log = LoggerFactory.getLogger(InmemPagedTrs.class);
    private final int changelogPageLimit;
    private final URI uriBase;
    private final AtomicLong trsOrderId = new AtomicLong();
    private final int basePageLimit;
    private final String baseRelativePath;
    private final String changeLogRelativePath;
    private final Map<URI, Base> baseResources = new ConcurrentHashMap<URI, Base>();
    private final Map<URI, ChangeLog> changelogResources = new ConcurrentHashMap<URI, ChangeLog>();

    public InmemPagedTrs(int basePageLimit, int changelogPageLimit, URI uriBase, String baseRelativePath, String changeLogRelativePath, Collection<URI> baseResourceUris) {
        this.basePageLimit = basePageLimit;
        this.changelogPageLimit = changelogPageLimit;
        this.uriBase = uriBase;
        this.baseRelativePath = baseRelativePath;
        this.changeLogRelativePath = changeLogRelativePath;
        this.initBase(baseResourceUris);
    }

    public InmemPagedTrs(int basePageLimit, int changelogPageLimit, URI uriBase, Collection<URI> baseResourceUris) {
        this.basePageLimit = basePageLimit;
        this.changelogPageLimit = changelogPageLimit;
        this.uriBase = uriBase;
        this.baseRelativePath = "base";
        this.changeLogRelativePath = "changelog";
        this.initBase(baseResourceUris);
    }

    @Override
    public Base getBaseResource(Integer pageId) {
        URI uri = this.basePageUriForPage(pageId);
        return this.getBaseResource(uri);
    }

    @Override
    public Base getBaseResource(URI uri) {
        return this.baseResources.get(uri);
    }

    @Override
    public Base getBaseFirst() {
        return this.baseResources.values().iterator().next();
    }

    @Override
    public Base getNext(Base base) {
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil".equals(base.getNextPage().getNextPage().toString())) {
            return null;
        }
        return this.getBaseResource(base.getNextPage().getNextPage());
    }

    @Override
    public int basePageCount() {
        return this.baseResources.size();
    }

    @Override
    public ChangeLog getChangeLog(Integer pageId) {
        URI uri = this.changelogUriForPage(pageId);
        return this.getChangeLog(uri);
    }

    @Override
    public ChangeLog getChangeLog(URI uri) {
        return this.changelogResources.get(uri);
    }

    @Override
    public ChangeLog getChangeLogLast() {
        return this.getLastChangelogPage();
    }

    @Override
    public ChangeLog getPrevious(ChangeLog changeLog) {
        if (changeLog.getPrevious() == null) {
            return null;
        }
        return this.getChangeLog(changeLog.getPrevious());
    }

    @Override
    public int changelogPageCount() {
        return this.changelogResources.size();
    }

    @Override
    public void onCreated(IResource resource) {
        HistoryData instance = HistoryData.getInstance(new Date(), resource.getAbout(), "Created");
        this.onHistoryData(instance);
    }

    @Override
    public void onModified(IResource resource) {
        HistoryData instance = HistoryData.getInstance(new Date(), resource.getAbout(), "Modified");
        this.onHistoryData(instance);
    }

    @Override
    public void onDeleted(URI resourceUri) {
        HistoryData instance = HistoryData.getInstance(new Date(), resourceUri, "Deleted");
        this.onHistoryData(instance);
    }

    public synchronized void onHistoryData(HistoryData event) {
        ChangeLog changeLog = this.findOrCreateChangelogPage();
        ChangeEvent changeEvent = this.createChangeEvent(event);
        changeLog.getChange().add(changeEvent);
    }

    private ChangeEvent createChangeEvent(long changeOrder, URI trackedResourceUri, URI eventUri, String histDataType) {
        Creation ce;
        if (changeOrder >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Switch ChangeEvents to use longs");
        }
        if (Objects.equals(histDataType, "Created")) {
            ce = new Creation(eventUri, trackedResourceUri, (long)((int)changeOrder));
        } else if (Objects.equals(histDataType, "Modified")) {
            ce = new Modification(eventUri, trackedResourceUri, (long)((int)changeOrder));
        } else if (Objects.equals(histDataType, "Deleted")) {
            ce = new Deletion(eventUri, trackedResourceUri, (long)((int)changeOrder));
        } else {
            log.error("Change Event {} has unknown kind: {}", (Object)trackedResourceUri, (Object)histDataType);
            throw new IllegalArgumentException();
        }
        return ce;
    }

    private ChangeEvent createChangeEvent(HistoryData event) {
        long order = this.nextCutoff();
        URI ceUri = this.createUuidUrn();
        if (order >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Switch ChangeEvents to use longs");
        }
        return this.createChangeEvent((int)order, event.getUri(), ceUri, event.getType());
    }

    private synchronized void initBase(Collection<URI> baseResourceUris) {
        Base base = this.findOrCreateBase();
        int remainingResources = this.calcRemainingResources(base);
        for (URI resourceUris : baseResourceUris) {
            if (remainingResources < 1) {
                base = this.findOrCreateBase();
                remainingResources = this.calcRemainingResources(base);
            }
            base.getMembers().add(resourceUris);
            --remainingResources;
        }
    }

    private synchronized Base findOrCreateBase() {
        Base base;
        if (this.baseResources.isEmpty()) {
            base = this.createBase();
        } else {
            Base lastBase = this.getLastBaseResource();
            if (this.isBaseFull(lastBase)) {
                base = this.createBase();
                lastBase.getNextPage().setNextPage(base.getNextPage().getAbout());
            } else {
                base = lastBase;
            }
        }
        return base;
    }

    private synchronized Base createBase() {
        Base base = new Base();
        base.setAbout(this.createBaseUri());
        base.setNextPage(this.createBasePage(base));
        base.setCutoffEvent(URI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil"));
        log.debug("Adding a new Base resource");
        this.baseResources.put(base.getNextPage().getAbout(), base);
        return base;
    }

    private Page createBasePage(Base base) {
        Page basePage = new Page();
        basePage.setAbout(this.nextBasePageUri());
        basePage.setNextPage(URI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil"));
        basePage.setPageOf(base);
        return basePage;
    }

    private synchronized ChangeLog findOrCreateChangelogPage() {
        ChangeLog page;
        if (this.changelogResources.isEmpty()) {
            page = this.createChangelogPage(null);
        } else {
            ChangeLog lastPage = this.getLastChangelogPage();
            if (this.isChangelogPageFull(lastPage)) {
                URI newAbout = this.nextChangelogUri();
                this.changelogResources.remove(lastPage.getAbout() != null ? lastPage.getAbout() : TRSUtil.NIL_URI);
                lastPage.setAbout(newAbout);
                this.changelogResources.put(newAbout, lastPage);
                page = this.createChangelogPage(lastPage.getAbout());
            } else {
                page = lastPage;
            }
        }
        return page;
    }

    private synchronized ChangeLog createChangelogPage(URI previous) {
        ChangeLog changelog = new ChangeLog();
        changelog.setAbout(null);
        changelog.setPrevious(previous);
        URI mapKey = TRSUtil.NIL_URI;
        if (this.changelogResources.get(mapKey) != null) {
            throw new IllegalStateException("A new changeLog page is being created, without first converting the last changelog into a non-local resource");
        }
        this.changelogResources.put(mapKey, changelog);
        return changelog;
    }

    private int calcRemainingResources(Base base) {
        int remaining = this.basePageLimit - base.getMembers().size();
        if (remaining < 0) {
            log.warn("Base contains more resources than it should!");
        }
        return Math.max(remaining, 0);
    }

    private boolean isBaseFull(Base base) {
        return this.calcRemainingResources(base) == 0;
    }

    private boolean isChangelogPageFull(ChangeLog changeLog) {
        return changeLog.getChange().size() >= this.changelogPageLimit;
    }

    private ChangeLog getLastChangelogPage() {
        return this.changelogResources.get(TRSUtil.NIL_URI);
    }

    private Base getLastBaseResource() {
        return this.baseResources.get(this.lastBasePageUri());
    }

    private URI createBaseUri() {
        return this.getUriBuilder().path(this.baseRelativePath).build(new Object[0]);
    }

    private URI lastBasePageUri() {
        int pageId = this.baseResources.size();
        return this.basePageUriForPage(pageId);
    }

    private URI nextBasePageUri() {
        int pageId = this.baseResources.size() + 1;
        return this.basePageUriForPage(pageId);
    }

    private URI basePageUriForPage(int pageId) {
        if (pageId < 1) {
            throw new IllegalArgumentException("Page id must be >= 1");
        }
        return this.getUriBuilder().path(this.baseRelativePath).path(String.valueOf(pageId)).build(new Object[0]);
    }

    private URI nextChangelogUri() {
        return this.changelogUriForPage(this.changelogResources.size());
    }

    private URI changelogUriForPage(int pageId) {
        if (pageId < 1) {
            throw new IllegalArgumentException("Page id must be >= 1");
        }
        return this.getUriBuilder().path(this.changeLogRelativePath).path(String.valueOf(pageId)).build(new Object[0]);
    }

    private long nextCutoff() {
        return this.trsOrderId.incrementAndGet();
    }

    private UriBuilder getUriBuilder() {
        return UriBuilder.fromUri((URI)this.uriBase);
    }

    private URI createUuidUrn() {
        return URI.create(String.format("urn:uuid:%s", UUID.randomUUID().toString()));
    }
}

