/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.lyo.core.trs.ChangeEvent;
import org.eclipse.lyo.core.trs.ChangeLog;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderUtil {
    private static final Logger log = LoggerFactory.getLogger(ProviderUtil.class);

    public static boolean isNotEmptySingletonArray(Object[] changeLogs) {
        return changeLogs != null && changeLogs.length == 1;
    }

    public static boolean isNotEmpty(Object[] deletions) {
        return deletions != null && deletions.length > 0;
    }

    public static boolean isNilUri(URI currentPageUri) {
        return currentPageUri == null || currentPageUri.toString().equals(RDF.nil.getURI());
    }

    public static boolean changeLogContainsEvent(URI syncPointUri, ChangeLog changeLog) {
        for (ChangeEvent changeEvent : changeLog.getChange()) {
            if (!changeEvent.getAbout().equals(syncPointUri)) continue;
            return true;
        }
        return false;
    }

    public static List<ChangeEvent> optimizedChangesList(List<ChangeLog> changeLogs, URI lastProcessedChangeEventUri) {
        Collections.reverse(changeLogs);
        ChangeLog firstChangeLog = changeLogs.get(0);
        ArrayList<ChangeEvent> firstChangelogEvents = firstChangeLog.getChange();
        firstChangelogEvents.sort(Comparator.comparing(ChangeEvent::getOrder));
        firstChangeLog.setChange(new ArrayList(firstChangelogEvents));
        int indexOfSync = -1;
        for (ChangeEvent changeEvent : firstChangelogEvents) {
            if (!changeEvent.getAbout().equals(lastProcessedChangeEventUri)) continue;
            indexOfSync = firstChangelogEvents.indexOf(changeEvent);
            break;
        }
        firstChangelogEvents = new ArrayList<ChangeEvent>(firstChangelogEvents.subList(indexOfSync + 1, firstChangelogEvents.size()));
        firstChangeLog.setChange(firstChangelogEvents);
        ArrayList<ChangeEvent> changesToProcess = new ArrayList<ChangeEvent>();
        for (ChangeLog changeLog : changeLogs) {
            changesToProcess.addAll(changeLog.getChange());
        }
        changesToProcess.sort(Comparator.comparing(ChangeEvent::getOrder));
        List<ChangeEvent> list = ProviderUtil.compressChanges(changesToProcess);
        return list;
    }

    public static List<URI> baseChangeEventsOptimizationSafe(List<ChangeEvent> compressedChangesList, List<URI> baseMembers) {
        Set compressedUris = compressedChangesList.stream().map(AbstractResource::getAbout).collect(Collectors.toSet());
        ArrayList<URI> filteredBase = new ArrayList<URI>(baseMembers.size());
        for (URI baseMember : baseMembers) {
            if (!compressedUris.contains(baseMember)) {
                filteredBase.add(baseMember);
                continue;
            }
            log.debug("Removing {} from the base because it has been updated since in the changelog", (Object)baseMember);
        }
        return filteredBase;
    }

    private static List<ChangeEvent> compressChanges(List<ChangeEvent> changesToProcess) {
        ArrayList<Object> reducedChangesList;
        HashMap<URI, ChangeEvent> resToChangeEventMap = new HashMap<URI, ChangeEvent>();
        for (ChangeEvent changeToProcess : changesToProcess) {
            resToChangeEventMap.put(changeToProcess.getChanged(), changeToProcess);
        }
        if (!resToChangeEventMap.isEmpty()) {
            reducedChangesList = new ArrayList(resToChangeEventMap.values());
            reducedChangesList.sort(Comparator.comparing(ChangeEvent::getOrder));
        } else {
            reducedChangesList = new ArrayList<ChangeEvent>();
        }
        return reducedChangesList;
    }
}

