/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.util;

import java.io.IOException;
import java.net.URI;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.update.UpdateExecution;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.eclipse.lyo.core.trs.ChangeEvent;
import org.eclipse.lyo.core.trs.Creation;
import org.eclipse.lyo.core.trs.Deletion;
import org.eclipse.lyo.core.trs.Modification;
import org.eclipse.lyo.trs.client.util.RdfUtil;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.SPARQLRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlUtil {
    static Logger logger = LoggerFactory.getLogger(SparqlUtil.class);

    public static String createGraphQuery(String namedGraphUrl) {
        String query = "CREATE GRAPH <" + namedGraphUrl + ">";
        logger.debug("query for creation of graph: " + namedGraphUrl);
        logger.debug(query);
        return query;
    }

    public static String createGraphQuery(URI namedGraphUrl) {
        return SparqlUtil.createGraphQuery(namedGraphUrl.toASCIIString());
    }

    public static String dropGraphQuery(String namedGraphUrl) {
        String query = "DROP GRAPH <" + namedGraphUrl + ">";
        logger.debug("query for removal of graph: " + namedGraphUrl);
        logger.debug(query);
        return query;
    }

    public static String removeAllTriplesInGraphQuery(String namedGraphUrl) {
        String query = "WITH <" + namedGraphUrl + ">\nDELETE\n{?s ?p ?o }\nWHERE\n{\nGRAPH <" + namedGraphUrl + ">\n{\n?s ?p ?o\n}\n}\n";
        logger.debug("query for removal of all triples from graph: " + namedGraphUrl);
        logger.debug(query);
        return query;
    }

    public static String addTriplesToGraphQuery(String namedGraphUrl, Model jenaModel) {
        try {
            String nTripleRepresentation = RdfUtil.modelToNTriple(jenaModel);
            return SparqlUtil.addTriplesToGraphQuery(namedGraphUrl, nTripleRepresentation);
        }
        catch (IOException e) {
            logger.error("Cannot append triples from the model to the query", (Throwable)e);
            return null;
        }
    }

    public static String addTriplesToGraphQuery(URI namedGraphUrl, Model jenaModel) {
        return SparqlUtil.addTriplesToGraphQuery(namedGraphUrl.toASCIIString(), jenaModel);
    }

    public static String addTriplesToGraphQuery(String namedGraphUrl, String triples) {
        String query = "INSERT DATA\n{\n  GRAPH <" + namedGraphUrl + ">\n{\n" + triples + "\n}\n}";
        logger.debug("query for creation of triples in graph: " + namedGraphUrl);
        logger.debug(query);
        return query;
    }

    public static String getChangeEventQuery(ChangeEvent changeEvent, Model model) {
        if (changeEvent instanceof Creation) {
            return SparqlUtil.getCreationEventQuery(changeEvent, model);
        }
        if (changeEvent instanceof Deletion) {
            return SparqlUtil.getDeletionEventQuery(changeEvent);
        }
        if (changeEvent instanceof Modification) {
            return SparqlUtil.getModificationEventQuery(changeEvent, model);
        }
        return null;
    }

    public static String getModificationEventQuery(ChangeEvent changeEvent, Model model) {
        String result = "";
        String changeEventTarget = changeEvent.getChanged().toString();
        String dropGraphQuery = SparqlUtil.dropGraphQuery(changeEventTarget);
        String addGraphQuery = SparqlUtil.createGraphQuery(changeEventTarget);
        String addTriplesToNamedGraphQuery = SparqlUtil.addTriplesToGraphQuery(changeEventTarget, model);
        result = result.concat(dropGraphQuery);
        result = result.concat(";\n");
        result = result.concat(addGraphQuery);
        result = result.concat(";\n");
        result = result.concat(addTriplesToNamedGraphQuery);
        return result;
    }

    public static String getModificationEventQuery(ChangeEvent changeEvent, String triples) {
        String changeEventTarget = changeEvent.getChanged().toString();
        return SparqlUtil.getModificationEventQuery(changeEventTarget, triples);
    }

    public static String getModificationEventQuery(String changeEventTarget, String triples) {
        String result = "";
        String dropGraphQuery = SparqlUtil.dropGraphQuery(changeEventTarget);
        String addGraphQuery = SparqlUtil.createGraphQuery(changeEventTarget);
        String addTriplesToNamedGraphQuery = SparqlUtil.addTriplesToGraphQuery(changeEventTarget, triples);
        result = result.concat(dropGraphQuery);
        result = result.concat(";\n");
        result = result.concat(addGraphQuery);
        result = result.concat(";\n");
        result = result.concat(addTriplesToNamedGraphQuery);
        return result;
    }

    public static String getCreationEventQuery(ChangeEvent changeEvent, Model model) {
        String result = "";
        String changeEventTarget = changeEvent.getChanged().toString();
        String addGraphQuery = SparqlUtil.createGraphQuery(changeEventTarget);
        String addTriplesToNamedGraphQuery = SparqlUtil.addTriplesToGraphQuery(changeEventTarget, model);
        result = result.concat(addGraphQuery);
        result = result.concat(";\n");
        result = result.concat(addTriplesToNamedGraphQuery);
        return result;
    }

    public static String getDeletionEventQuery(ChangeEvent changeEvent) {
        String result = "";
        String changeEventTarget = changeEvent.getChanged().toString();
        String dropGraphQuery = SparqlUtil.dropGraphQuery(changeEventTarget);
        result = result.concat(dropGraphQuery);
        return result;
    }

    public static void createGraph(String namedGraphUrl, String serviceUrl) {
        UpdateRequest request = UpdateFactory.create();
        request.add(SparqlUtil.createGraphQuery(namedGraphUrl));
        UpdateExecution processor = UpdateExecutionFactory.createRemote((UpdateRequest)request, (String)serviceUrl);
        processor.execute();
    }

    public static void dropGraph(String namedGraphUrl, String serviceUrl) {
        UpdateRequest request = UpdateFactory.create();
        request.add(SparqlUtil.dropGraphQuery(namedGraphUrl));
        UpdateExecution processor = UpdateExecutionFactory.createRemote((UpdateRequest)request, (String)serviceUrl);
        processor.execute();
    }

    public static void addTriplesToNamedGraph(Model jenaModel, String namedGraphUrl, String serviceUrl) {
        UpdateRequest request = UpdateFactory.create();
        request.add(SparqlUtil.addTriplesToGraphQuery(namedGraphUrl, jenaModel));
        UpdateExecution processor = UpdateExecutionFactory.createRemote((UpdateRequest)request, (String)serviceUrl);
        processor.execute();
    }

    public static void removeAllTriplesInNamedGraph(String namedGraphUrl, String serviceUrl) {
        UpdateRequest request = UpdateFactory.create();
        request.add(SparqlUtil.removeAllTriplesInGraphQuery(namedGraphUrl));
        UpdateExecution processor = UpdateExecutionFactory.createRemote((UpdateRequest)request, (String)serviceUrl);
        processor.execute();
    }

    public static void processChangeEvent(ChangeEvent changeEvent, Model model, String serviceUrl) {
        String changeEventQuery = SparqlUtil.getChangeEventQuery(changeEvent, model);
        SparqlUtil.processQuery(changeEventQuery, serviceUrl);
    }

    public static void processQuery(String query, String serviceUrl) {
        UpdateRequest request = UpdateFactory.create();
        request.add(query);
        UpdateExecution processor = UpdateExecutionFactory.createRemote((UpdateRequest)request, (String)serviceUrl);
        processor.execute();
    }

    public static void processQuery_sesame(String query, String serviceUrl, String user, String pwd) {
        SPARQLRepository repo = new SPARQLRepository(serviceUrl);
        repo.setUsernameAndPassword(user, pwd);
        repo.init();
        RepositoryConnection rc = repo.getConnection();
        SparqlUtil.processQuery_sesame(query, rc);
    }

    public static void processQuery_sesame(String query, RepositoryConnection conn) {
        Update u = conn.prepareUpdate(query);
        u.execute();
    }

    public static RepositoryConnection getRepoConnection(String queryEndpoint, String user, String pwd) {
        SPARQLRepository repo = new SPARQLRepository(queryEndpoint);
        if (user != null && pwd != null && !user.isEmpty() && !pwd.isEmpty()) {
            repo.setUsernameAndPassword(user, pwd);
        }
        repo.init();
        try {
            RepositoryConnection conn = repo.getConnection();
            return conn;
        }
        catch (RepositoryException e) {
            logger.error("error getting sparql repo connection !", (Throwable)e);
            return null;
        }
    }

    public static RepositoryConnection getRepoConnection(String queryEndpoint, String updateEndPoint, String user, String pwd) {
        SPARQLRepository repo = new SPARQLRepository(queryEndpoint, updateEndPoint);
        if (user != null && pwd != null && !user.isEmpty() && !pwd.isEmpty()) {
            repo.setUsernameAndPassword(user, pwd);
        }
        repo.init();
        try {
            RepositoryConnection conn = repo.getConnection();
            return conn;
        }
        catch (RepositoryException e) {
            logger.error("error getting sparql repo connection !", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TupleQueryResult evalQuery(String queryEndpoint, String user, String pwd, String query) {
        TupleQueryResult result = null;
        try (RepositoryConnection conn = SparqlUtil.getRepoConnection(queryEndpoint, user, pwd, query);){
            result = conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();
        }
        return result;
    }

    public static void evalUpdate(RepositoryConnection conn, String sparqlQuery) {
        try {
            conn.prepareUpdate(QueryLanguage.SPARQL, sparqlQuery).execute();
        }
        catch (Exception e) {
            logger.error("error during the execution of the query !", (Throwable)e);
        }
    }

    public static TupleQueryResult evalQuery(RepositoryConnection conn, String sparqlQuery) {
        TupleQueryResult result = null;
        try {
            result = conn.prepareTupleQuery(QueryLanguage.SPARQL, sparqlQuery).evaluate();
        }
        catch (Exception e) {
            logger.error("error during the execution of the query !", (Throwable)e);
        }
        return result;
    }

    public static String appendSparqldQuery(String appending, String appended) {
        if (appending != null && !appending.isEmpty()) {
            if (!appending.endsWith(";")) {
                appending = appending.concat(";");
            }
            if (!appending.endsWith("\n")) {
                appending = appending.concat("\n");
            }
        }
        appending = appending.concat(appended);
        return appending;
    }

    public void processTripleAdditionQuery(RepositoryConnection conn, String triples, String graphName) {
        String addTriplesToGraphQuery = SparqlUtil.addTriplesToGraphQuery(graphName, triples);
        SparqlUtil.processQuery_sesame(addTriplesToGraphQuery, conn);
    }

    public static String linkTriple(String src, String dst, String linkType) {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + src + ">");
        sb.append(" ");
        sb.append("<" + linkType + ">");
        sb.append(" ");
        sb.append("<" + dst + ">");
        sb.append(" .");
        return sb.toString();
    }
}

