/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.eclipse.lyo.client.IOslcClient;
import org.eclipse.lyo.client.OslcClient;
import org.eclipse.lyo.trs.client.config.TrsConsumerConfiguration;
import org.eclipse.lyo.trs.client.config.TrsProviderConfiguration;
import org.eclipse.lyo.trs.client.handlers.ConcurrentTrsProviderHandler;
import org.eclipse.lyo.trs.client.handlers.IProviderHandler;
import org.eclipse.lyo.trs.client.handlers.TrsProviderHandler;
import org.eclipse.lyo.trs.client.handlers.sparql.SparqlBatchingHandler;
import org.eclipse.lyo.trs.client.handlers.sparql.SparqlDirectHandler;
import org.eclipse.lyo.trs.client.util.ITrackedResourceClient;
import org.eclipse.lyo.trs.client.util.TrackedResourceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrsConsumerUtils {
    private static final Logger log = LoggerFactory.getLogger(TrsConsumerUtils.class);

    public static List<IProviderHandler> buildHandlersSequential(TrsConsumerConfiguration consumerConfig, Collection<TrsProviderConfiguration> providerConfigs) {
        return TrsConsumerUtils.buildHandlers(consumerConfig, providerConfigs, TrsConsumerUtils::providerFor);
    }

    public static List<IProviderHandler> buildHandlersConcurrent(TrsConsumerConfiguration consumerConfig, Collection<TrsProviderConfiguration> providerConfigs) {
        return TrsConsumerUtils.buildHandlers(consumerConfig, providerConfigs, TrsConsumerUtils::concurrentProviderFor);
    }

    public static List<IProviderHandler> buildHandlers(TrsConsumerConfiguration consumerConfig, Collection<TrsProviderConfiguration> providerConfigs, BiFunction<TrsConsumerConfiguration, TrsProviderConfiguration, IProviderHandler> function) {
        ArrayList<IProviderHandler> providers = new ArrayList<IProviderHandler>();
        for (TrsProviderConfiguration cfg : providerConfigs) {
            IProviderHandler trsProvider = function.apply(consumerConfig, cfg);
            providers.add(trsProvider);
        }
        return providers;
    }

    private static IProviderHandler providerFor(TrsConsumerConfiguration consumerConfig, TrsProviderConfiguration cfg) {
        ITrackedResourceClient trsClient = TrsConsumerUtils.trsClientFactory(consumerConfig.getHttpClient());
        SparqlDirectHandler handler = new SparqlDirectHandler(consumerConfig.getSparqlUpdateUrl());
        TrsProviderHandler providerHandler = new TrsProviderHandler(cfg.getTrsUri(), trsClient, handler);
        return providerHandler;
    }

    private static IProviderHandler concurrentProviderFor(TrsConsumerConfiguration consumerConfig, TrsProviderConfiguration cfg) {
        ITrackedResourceClient trsClient = TrsConsumerUtils.trsClientFactory(consumerConfig.getHttpClient());
        SparqlBatchingHandler handler = new SparqlBatchingHandler(consumerConfig.getSparqlUpdateUrl(), consumerConfig.getSparqlUsername(), consumerConfig.getSparqlPassword());
        ConcurrentTrsProviderHandler providerHandler = new ConcurrentTrsProviderHandler(cfg.getTrsUri(), trsClient, handler);
        return providerHandler;
    }

    private static ITrackedResourceClient trsClientFactory(OslcClient httpClient) {
        return new TrackedResourceClient((IOslcClient)httpClient);
    }
}

