/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.handlers.sparql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.lyo.core.trs.ChangeEvent;
import org.eclipse.lyo.core.trs.Deletion;
import org.eclipse.lyo.trs.client.handlers.IProviderEventHandler;
import org.eclipse.lyo.trs.client.model.BaseMember;
import org.eclipse.lyo.trs.client.model.ChangeEventMessageTR;
import org.eclipse.lyo.trs.client.util.SparqlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlBatchingHandler
implements IProviderEventHandler {
    private static final Logger log = LoggerFactory.getLogger(SparqlBatchingHandler.class);
    private final List<String> queries = new ArrayList<String>();
    private final String sparqlUpdateService;
    private final String sparql_baseAuth_userName;
    private final String sparql_baseAuth_pwd;

    public SparqlBatchingHandler(String sparqlUpdateService, String sparql_baseAuth_userName, String sparql_baseAuth_pwd) {
        this.sparqlUpdateService = sparqlUpdateService;
        this.sparql_baseAuth_userName = sparql_baseAuth_userName;
        this.sparql_baseAuth_pwd = sparql_baseAuth_pwd;
    }

    @Override
    public void finishCycle() {
        log.debug("number of processed queries: " + this.queries.size());
        String finalQueryString = this.buildYugeQuery(this.queries);
        log.debug("sending Update SPARQL Query to server");
        SparqlUtil.processQuery_sesame(finalQueryString, this.sparqlUpdateService, this.sparql_baseAuth_userName, this.sparql_baseAuth_pwd);
        log.debug("Update SPARQL Queries successful!");
        this.queries.clear();
    }

    @Override
    public void handleBaseMember(BaseMember baseMember) {
        StringBuilder query = new StringBuilder();
        String graphCreationQuery = SparqlUtil.createGraphQuery(baseMember.getUri());
        String addTriplesToGraphQuery = SparqlUtil.addTriplesToGraphQuery(baseMember.getUri(), baseMember.getModel());
        query.append(graphCreationQuery);
        query.append("; \n");
        query.append(addTriplesToGraphQuery);
        this.queries.add(query.toString());
    }

    @Override
    public void handleChangeEvent(ChangeEventMessageTR eventMessageTR) {
        ChangeEvent event = eventMessageTR.getChangeEvent();
        log.debug("creating query for resource " + event.getChanged().toString() + " change event ");
        if (event instanceof Deletion) {
            String query = SparqlUtil.getChangeEventQuery(event, null);
            this.queries.add(query);
        } else {
            String query = SparqlUtil.getChangeEventQuery(event, eventMessageTR.getTrackedResourceModel());
            this.queries.add(query);
        }
    }

    @Override
    public void rebase() {
        log.warn("Rebase");
    }

    private String buildYugeQuery(List<String> queries) {
        StringBuilder queriesStringBuilder = new StringBuilder();
        for (String query : queries) {
            queriesStringBuilder.append(query);
            queriesStringBuilder.append("; \n");
        }
        queriesStringBuilder.replace(queriesStringBuilder.lastIndexOf("; \n"), queriesStringBuilder.lastIndexOf("; \n") + 1, "");
        String finalQueryString = queriesStringBuilder.toString();
        log.debug(finalQueryString);
        return finalQueryString;
    }
}

