/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.shacl;

import java.net.URI;

public enum DataType {
    Boolean("http://www.w3.org/2001/XMLSchema#boolean"),
    DateTime("http://www.w3.org/2001/XMLSchema#dateTime"),
    Date("http://www.w3.org/2001/XMLSchema#date"),
    Decimal("http://www.w3.org/2001/XMLSchema#decimal"),
    Double("http://www.w3.org/2001/XMLSchema#double"),
    Float("http://www.w3.org/2001/XMLSchema#float"),
    Integer("http://www.w3.org/2001/XMLSchema#integer"),
    String("http://www.w3.org/2001/XMLSchema#string"),
    XMLLiteral("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"),
    Resource("http://open-services.net/ns/core#Resource");

    private final String uri;

    private DataType(String uri) {
        this.uri = uri;
    }

    public String toString() {
        return this.uri;
    }

    public static DataType fromString(String string) {
        DataType[] values;
        for (DataType value : values = DataType.values()) {
            if (!value.uri.equals(string)) continue;
            return value;
        }
        return null;
    }

    public static DataType fromURI(URI uri) {
        return DataType.fromString(uri.toString());
    }
}

