/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.shacl;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRdfCollectionType;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.eclipse.lyo.shacl.Property;

@OslcNamespace(value="http://www.w3.org/ns/shacl#")
@OslcName(value="Shape")
@OslcResourceShape(title="Shacl Resource Shape", describes={"http://www.w3.org/ns/shacl#Shape"})
public final class Shape
extends AbstractResource {
    private final Map<URI, Property> properties = new HashMap<URI, Property>();
    private URI targetClass;
    private URI targetNode;
    private URI targetSubjectsOf;
    private URI targetObjectsOf;
    private URI isDefinedBy;
    private String label;
    private URI type;
    private boolean isClosed;
    private List<URI> ignoredProperties;
    private boolean readShaclAnnotations = false;

    public Shape() {
    }

    public Shape(URI about) {
        super(about);
    }

    public String toString() {
        return "Shape [targetClass=" + this.targetClass + ", properties=" + this.properties + "]";
    }

    public void addIgnoredProperties(URI ignoredPropertyPredicate) {
        this.ignoredProperties.add(ignoredPropertyPredicate);
    }

    public void addProperty(Property property) {
        this.properties.put(property.getPath(), property);
    }

    public void removeProperty(URI predicate) {
        this.properties.remove(predicate);
    }

    public Property getShaclProperty(URI definition) {
        return this.properties.get(definition);
    }

    @OslcDescription(value="Type or types of resource described by this shape")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcReadOnly
    @OslcTitle(value="RDF Type")
    public URI getType() {
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    @OslcDescription(value="Type or types of resource described by this shape")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#targetClass")
    @OslcReadOnly
    @OslcTitle(value="targetClass")
    public URI getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(URI targetClass) {
        this.targetClass = targetClass;
    }

    @OslcDescription(value="Type or types of resource described by this shape")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#targetSubjectsOf")
    @OslcReadOnly
    @OslcTitle(value="targetSubjectsOf")
    public URI getTargetSubjectsOf() {
        return this.targetSubjectsOf;
    }

    public void setTargetSubjectsOf(URI targetSubjectsOf) {
        this.targetSubjectsOf = targetSubjectsOf;
    }

    @OslcDescription(value="Type or types of resource described by this shape")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#targetObjectsOf")
    @OslcReadOnly
    @OslcTitle(value="targetObjectsOf")
    public URI getTargetObjectsOf() {
        return this.targetObjectsOf;
    }

    public void setTargetObjectsOf(URI targetObjectsOf) {
        this.targetObjectsOf = targetObjectsOf;
    }

    @OslcDescription(value="The properties that are allowed or required by this shape")
    @OslcName(value="property")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#property")
    @OslcRange(value={"http://www.w3.org/ns/shacl#Property"})
    @OslcReadOnly
    @OslcTitle(value="Properties")
    @OslcValueType(value=ValueType.LocalResource)
    public List<Property> getShaclProperties() {
        return ImmutableList.copyOf((Object[])this.properties.values().toArray(new Property[this.properties.size()]));
    }

    public void setShaclProperties(List<Property> properties) {
        this.properties.clear();
        if (properties != null) {
            for (Property prop : properties) {
                this.properties.put(prop.getPath(), prop);
            }
        }
    }

    @OslcDescription(value="Specified Is Defined By")
    @OslcPropertyDefinition(value="http://www.w3.org/2000/01/rdf-schema#isDefinedBy")
    @OslcTitle(value="isDefinedBy")
    public URI getIsDefinedBy() {
        return this.isDefinedBy;
    }

    public void setIsDefinedBy(URI isDefinedBy) {
        this.isDefinedBy = isDefinedBy;
    }

    @OslcDescription(value="Specified Label")
    @OslcPropertyDefinition(value="http://www.w3.org/2000/01/rdf-schema#label")
    @OslcTitle(value="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @OslcDescription(value="Focus Node")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#targetNode")
    @OslcReadOnly
    @OslcTitle(value="targetNode")
    public URI getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(URI targetNode) {
        this.targetNode = targetNode;
    }

    @OslcDescription(value="If set to true, the model is not allowed to have any other property apart from those in shapes graph.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#closed")
    @OslcValueType(value=ValueType.Boolean)
    @OslcTitle(value="Closed")
    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    @OslcDescription(value="Optional SHACL list of properties that are also permitted in addition to those explicitly enumerated via sh:property..")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#ignoredProperties")
    @OslcTitle(value="IgnoredProperties")
    @OslcRdfCollectionType
    public List<URI> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public void setIgnoredProperties(List<URI> ignoredProperties) {
        this.ignoredProperties = ignoredProperties;
    }

    public boolean isReadShaclAnnotations() {
        return this.readShaclAnnotations;
    }

    public void setReadShaclAnnotations(boolean useShaclAnnotations) {
        this.readShaclAnnotations = useShaclAnnotations;
    }
}

