/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.server.oauth.consumerstore;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.util.FileManager;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.lyo.server.oauth.core.consumer.AbstractConsumerStore;
import org.eclipse.lyo.server.oauth.core.consumer.ConsumerStoreException;
import org.eclipse.lyo.server.oauth.core.consumer.LyoOAuthConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemConsumerStore
extends AbstractConsumerStore {
    protected static final String LYO_OAUTH_NAMESPACE = "http://eclipse.org/lyo/server/oauth#";
    protected static final String CONSUMER_RESOURCE = "http://eclipse.org/lyo/server/oauth#Consumer";
    protected static final String CALLBACK_URL = "http://eclipse.org/lyo/server/oauth#callback";
    protected static final String CONSUMER_NAME = "http://eclipse.org/lyo/server/oauth#consumerName";
    protected static final String CONSUMER_KEY = "http://eclipse.org/lyo/server/oauth#consumerKey";
    protected static final String CONSUMER_SECRET = "http://eclipse.org/lyo/server/oauth#consumerSecret";
    protected static final String PROVISIONAL = "http://eclipse.org/lyo/server/oauth#provisional";
    protected static final String TRUSTED = "http://eclipse.org/lyo/server/oauth#trusted";
    private static final Logger log = LoggerFactory.getLogger(FileSystemConsumerStore.class);
    public static final String AES_CIPHER = "AES/GCM/NoPadding";
    private Model model;
    private String oauthStore;
    private String encryptionKey;

    public FileSystemConsumerStore(String oauthStoreRoot) throws SQLException, ConsumerStoreException, ClassNotFoundException {
        this.oauthStore = oauthStoreRoot;
        this.createModel();
        this.loadConsumers();
    }

    public FileSystemConsumerStore(String oauthStoreRoot, String encryptionKey) throws SQLException, ConsumerStoreException, ClassNotFoundException {
        this.oauthStore = oauthStoreRoot;
        this.encryptionKey = encryptionKey;
        this.createModel();
        this.loadConsumers();
    }

    public FileSystemConsumerStore(Model model, String oauthStoreRoot) throws ConsumerStoreException {
        this.oauthStore = oauthStoreRoot;
        this.model = model;
        this.loadConsumers();
    }

    protected void createModel() {
        try {
            this.model = FileManager.get().loadModel(this.oauthStore);
        }
        catch (Exception e) {
            this.model = ModelFactory.createDefaultModel();
        }
    }

    protected void writeModel() throws FileNotFoundException {
        Model writeModel = ModelFactory.createDefaultModel();
        writeModel.add(this.model);
        FileOutputStream os = new FileOutputStream(this.oauthStore);
        writeModel.write((OutputStream)os, "RDF/XML-ABBREV");
    }

    protected synchronized void loadConsumers() throws ConsumerStoreException {
        ResIterator i = this.model.listResourcesWithProperty(RDF.type, (RDFNode)this.model.createResource(CONSUMER_RESOURCE));
        while (i.hasNext()) {
            Resource consumerResource = (Resource)i.next();
            try {
                this.add(this.fromResource(consumerResource));
            }
            catch (PropertyNotFoundException e) {
                log.error("Could not load consumer " + String.valueOf(consumerResource.getProperty(this.model.createProperty(CONSUMER_NAME))) + " (" + String.valueOf(consumerResource.getProperty(this.model.createProperty(CONSUMER_KEY))) + ")", (Throwable)e);
            }
            catch (UnsupportedEncodingException ue) {
                throw new ConsumerStoreException((Throwable)ue);
            }
            catch (JenaException e) {
                throw new ConsumerStoreException((Throwable)e);
            }
        }
    }

    public synchronized LyoOAuthConsumer addConsumer(LyoOAuthConsumer consumer) throws ConsumerStoreException {
        if (this.model == null) {
            throw new ConsumerStoreException("Consumer store not initialized.");
        }
        try {
            this.removeProperties(consumer);
            this.toResource(consumer);
            LyoOAuthConsumer retConsumer = this.add(consumer);
            this.writeModel();
            return retConsumer;
        }
        catch (FileNotFoundException | UnsupportedEncodingException ue) {
            throw new ConsumerStoreException((Throwable)ue);
        }
    }

    public synchronized LyoOAuthConsumer removeConsumer(String consumerKey) throws ConsumerStoreException {
        if (this.model == null) {
            throw new ConsumerStoreException("Consumer store not initialized.");
        }
        try {
            this.removeProperties(consumerKey);
            LyoOAuthConsumer retConsumer = this.remove(consumerKey);
            this.writeModel();
            return retConsumer;
        }
        catch (FileNotFoundException fe) {
            throw new ConsumerStoreException((Throwable)fe);
        }
    }

    public LyoOAuthConsumer updateConsumer(LyoOAuthConsumer consumer) throws ConsumerStoreException {
        return this.addConsumer(consumer);
    }

    public void closeConsumerStore() {
        try {
            this.writeModel();
        }
        catch (Exception e) {
            log.error("Error finalizing model to disk");
        }
        this.model.close();
    }

    protected void removeProperties(String consumerKey) {
        ResIterator i = this.model.listResourcesWithProperty(this.model.createProperty(CONSUMER_KEY), (RDFNode)this.model.createLiteral(consumerKey));
        while (i.hasNext()) {
            ((Resource)i.next()).removeProperties();
        }
    }

    protected void removeProperties(LyoOAuthConsumer consumer) {
        this.removeProperties(consumer.consumerKey);
    }

    protected Resource toResource(LyoOAuthConsumer consumer) throws UnsupportedEncodingException {
        Resource resource = this.model.createResource();
        resource.addProperty(RDF.type, (RDFNode)this.model.createResource(CONSUMER_RESOURCE));
        resource.addProperty(this.model.createProperty(CONSUMER_NAME), consumer.getName());
        resource.addProperty(this.model.createProperty(CONSUMER_KEY), consumer.consumerKey);
        String encodedSecret = null;
        encodedSecret = this.encryptionKey != null ? new String(this.encrypt(consumer.consumerSecret, this.encryptionKey)) : new String(Base64.getEncoder().encode(consumer.consumerSecret.getBytes("UTF8")), "UTF8");
        resource.addProperty(this.model.createProperty(CONSUMER_SECRET), encodedSecret);
        resource.addProperty(this.model.createProperty(PROVISIONAL), consumer.isProvisional() ? "true" : "false");
        resource.addProperty(this.model.createProperty(TRUSTED), consumer.isTrusted() ? "true" : "false");
        return resource;
    }

    protected LyoOAuthConsumer fromResource(Resource resource) throws UnsupportedEncodingException {
        String key = resource.getRequiredProperty(this.model.createProperty(CONSUMER_KEY)).getString();
        String encodedSecret = resource.getRequiredProperty(this.model.createProperty(CONSUMER_SECRET)).getString();
        String secret = null;
        secret = this.encryptionKey != null ? new String(this.decrypt(encodedSecret, this.encryptionKey)) : new String(Base64.getDecoder().decode(encodedSecret.getBytes("UTF8")), "UTF8");
        LyoOAuthConsumer consumer = new LyoOAuthConsumer(key, secret);
        consumer.setName(resource.getRequiredProperty(this.model.createProperty(CONSUMER_NAME)).getString());
        String provisional = resource.getProperty(this.model.createProperty(PROVISIONAL)).getString();
        consumer.setProvisional("true".equals(provisional));
        String trusted = resource.getProperty(this.model.createProperty(TRUSTED)).getString();
        consumer.setTrusted("true".equals(trusted));
        return consumer;
    }

    protected String encrypt(String plainText, String encryptionKey) {
        log.debug("Entering encrypt method in EncryptionUtil class");
        String encryptedText = null;
        try {
            Cipher cipher = Cipher.getInstance(AES_CIPHER);
            SecretKey secretKey = this.getSecreteKey(encryptionKey);
            byte[] plainTextByte = plainText.getBytes(StandardCharsets.UTF_8);
            cipher.init(1, secretKey);
            byte[] encryptedByte = cipher.doFinal(plainTextByte);
            Base64.Encoder encoder = Base64.getEncoder();
            encryptedText = encoder.encodeToString(encryptedByte);
        }
        catch (GeneralSecurityException e) {
            log.error("Failed to encrypt Consumer configuration file data: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        log.debug("Exiting encrypt method in EncryptionUtil class");
        return encryptedText;
    }

    protected String decrypt(String encryptedText, String decryptionKey) {
        log.debug("Entering decrypt method in EncryptionUtil class");
        String decryptedText = null;
        try {
            Cipher cipher = Cipher.getInstance(AES_CIPHER);
            SecretKey secretKey = this.getSecreteKey(decryptionKey);
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] encryptedTextByte = decoder.decode(encryptedText);
            cipher.init(2, secretKey);
            byte[] decryptedByte = cipher.doFinal(encryptedTextByte);
            decryptedText = new String(decryptedByte, StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException e) {
            log.error("Failed to decrypt Consumer configuration file data: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        log.debug("Exiting decrypt method in EncryptionUtil class");
        return decryptedText;
    }

    protected SecretKey getSecreteKey(String encryptionKey) {
        log.debug("Entering getSecreteKey method in EncryptionUtil class");
        log.debug("Secret key length should be 16, 24 or 32 bytes");
        byte[] encoded = Base64.getDecoder().decode(encryptionKey);
        SecretKeySpec secretKey = new SecretKeySpec(encoded, "AES");
        log.debug("Exiting getSecreteKey method");
        return secretKey;
    }
}

