/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.server.oauth.consumerstore;

import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.tdb.TDBFactory;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.lyo.server.oauth.core.consumer.AbstractConsumerStore;
import org.eclipse.lyo.server.oauth.core.consumer.ConsumerStoreException;
import org.eclipse.lyo.server.oauth.core.consumer.LyoOAuthConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfConsumerStore
extends AbstractConsumerStore {
    protected static final String LYO_OAUTH_NAMESPACE = "http://eclipse.org/lyo/server/oauth#";
    protected static final String CONSUMER_RESOURCE = "http://eclipse.org/lyo/server/oauth#Consumer";
    protected static final String CALLBACK_URL = "http://eclipse.org/lyo/server/oauth#callback";
    protected static final String CONSUMER_NAME = "http://eclipse.org/lyo/server/oauth#consumerName";
    protected static final String CONSUMER_KEY = "http://eclipse.org/lyo/server/oauth#consumerKey";
    protected static final String CONSUMER_SECRET = "http://eclipse.org/lyo/server/oauth#consumerSecret";
    protected static final String PROVISIONAL = "http://eclipse.org/lyo/server/oauth#provisional";
    protected static final String TRUSTED = "http://eclipse.org/lyo/server/oauth#trusted";
    protected static final String DB = "RDFStore";
    private static final Logger log = LoggerFactory.getLogger(RdfConsumerStore.class);
    private Model model;
    private Dataset dataset;

    public RdfConsumerStore() throws ConsumerStoreException, ClassNotFoundException {
        this.createDataset();
        if (this.dataset != null) {
            this.createModel(this.dataset);
            this.loadConsumers();
        }
    }

    public RdfConsumerStore(Dataset dataset) throws ConsumerStoreException {
        this.dataset = dataset;
        this.createModel(this.dataset);
        this.loadConsumers();
    }

    public RdfConsumerStore(Model model) throws ConsumerStoreException {
        this.createDataset();
        if (this.dataset != null) {
            this.model = model;
            this.dataset.setDefaultModel(this.model);
            this.loadConsumers();
        }
    }

    protected void createDataset() {
        try {
            this.dataset = TDBFactory.createDataset((String)DB);
        }
        catch (Exception e) {
            log.error("Could not create dataset for OAuth consumer store.", (Throwable)e);
        }
    }

    protected void createModel(Dataset dataset) {
        try {
            this.model = dataset.getDefaultModel();
        }
        catch (Exception e) {
            log.error("Could not create model for OAuth consumer store.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadConsumers() throws ConsumerStoreException {
        try {
            this.model.enterCriticalSection(true);
            ResIterator i = this.model.listResourcesWithProperty(RDF.type, (RDFNode)this.model.createResource(CONSUMER_RESOURCE));
            while (i.hasNext()) {
                Resource consumerResource = (Resource)i.next();
                try {
                    this.add(this.fromResource(consumerResource));
                }
                catch (PropertyNotFoundException e) {
                    log.error("Could not load consumer " + String.valueOf(consumerResource.getProperty(this.model.createProperty(CONSUMER_NAME))) + " (" + String.valueOf(consumerResource.getProperty(this.model.createProperty(CONSUMER_KEY))) + ")", (Throwable)e);
                }
                catch (JenaException e) {
                    throw new ConsumerStoreException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    public LyoOAuthConsumer addConsumer(LyoOAuthConsumer consumer) throws ConsumerStoreException {
        if (this.model == null) {
            throw new ConsumerStoreException("Consumer store not initialized.");
        }
        try {
            this.model.enterCriticalSection(false);
            this.model.executeInTxn(() -> {
                this.removeProperties(consumer);
                this.toResource(consumer);
            });
            LyoOAuthConsumer lyoOAuthConsumer = this.add(consumer);
            return lyoOAuthConsumer;
        }
        catch (JenaException e) {
            throw new ConsumerStoreException((Throwable)e);
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    public LyoOAuthConsumer removeConsumer(String consumerKey) throws ConsumerStoreException {
        if (this.model == null) {
            throw new ConsumerStoreException("Consumer store not initialized.");
        }
        try {
            this.model.enterCriticalSection(false);
            this.model.executeInTxn(() -> this.removeProperties(consumerKey));
            LyoOAuthConsumer lyoOAuthConsumer = this.remove(consumerKey);
            return lyoOAuthConsumer;
        }
        catch (JenaException e) {
            throw new ConsumerStoreException((Throwable)e);
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    public LyoOAuthConsumer updateConsumer(LyoOAuthConsumer consumer) throws ConsumerStoreException {
        return this.addConsumer(consumer);
    }

    public void closeConsumerStore() {
        if (this.model != null) {
            this.model.close();
        }
        if (this.dataset != null) {
            this.dataset.close();
        }
    }

    protected void removeProperties(String consumerKey) {
        ResIterator i = this.model.listResourcesWithProperty(this.model.createProperty(CONSUMER_KEY), (RDFNode)this.model.createLiteral(consumerKey));
        while (i.hasNext()) {
            ((Resource)i.next()).removeProperties();
        }
    }

    protected void removeProperties(LyoOAuthConsumer consumer) {
        this.removeProperties(consumer.consumerKey);
    }

    protected Resource toResource(LyoOAuthConsumer consumer) {
        Resource resource = this.model.createResource();
        resource.addProperty(RDF.type, (RDFNode)this.model.createResource(CONSUMER_RESOURCE));
        resource.addProperty(this.model.createProperty(CONSUMER_NAME), consumer.getName());
        resource.addProperty(this.model.createProperty(CONSUMER_KEY), consumer.consumerKey);
        resource.addProperty(this.model.createProperty(CONSUMER_SECRET), consumer.consumerSecret);
        resource.addProperty(this.model.createProperty(PROVISIONAL), consumer.isProvisional() ? "true" : "false");
        resource.addProperty(this.model.createProperty(TRUSTED), consumer.isTrusted() ? "true" : "false");
        return resource;
    }

    protected LyoOAuthConsumer fromResource(Resource resource) {
        String key = resource.getRequiredProperty(this.model.createProperty(CONSUMER_KEY)).getString();
        String secret = resource.getRequiredProperty(this.model.createProperty(CONSUMER_SECRET)).getString();
        LyoOAuthConsumer consumer = new LyoOAuthConsumer(key, secret);
        consumer.setName(resource.getRequiredProperty(this.model.createProperty(CONSUMER_NAME)).getString());
        String provisional = resource.getProperty(this.model.createProperty(PROVISIONAL)).getString();
        consumer.setProvisional("true".equals(provisional));
        String trusted = resource.getProperty(this.model.createProperty(TRUSTED)).getString();
        consumer.setTrusted("true".equals(trusted));
        return consumer;
    }
}

