/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.trs;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.lyo.core.trs.Page;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcHidden;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;

@OslcNamespace(value="http://www.w3.org/ns/ldp#")
@OslcName(value="Container")
@OslcResourceShape(title="Tracked Resource Set Base Shape", describes={"http://www.w3.org/ns/ldp#Container"})
public class Base
extends AbstractResource {
    private final List<URI> members = new CopyOnWriteArrayList<URI>();
    private URI cutoffEvent;
    private Page nextPage;

    @OslcName(value="member")
    @OslcDescription(value="A member Resource of the Resource Set.")
    @OslcPropertyDefinition(value="http://www.w3.org/2000/01/rdf-schema#member")
    @OslcTitle(value="Member")
    public List<URI> getMembers() {
        return this.members;
    }

    public void setMembers(List<URI> members) {
        if (members == null) {
            throw new IllegalArgumentException("Members list must not be null");
        }
        this.members.clear();
        this.members.addAll(members);
    }

    @OslcName(value="cutoffEvent")
    @OslcDescription(value="The most recent Change Log entry that is accounted for in this Base. When rdf:nil, the Base is an enumeration at the start of time.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core/trs#cutoffEvent")
    @OslcTitle(value="Cutoff Event")
    public URI getCutoffEvent() {
        return this.cutoffEvent;
    }

    public void setCutoffEvent(URI cutoffEvent) {
        this.cutoffEvent = cutoffEvent;
    }

    @OslcHidden(value=true)
    public Page getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(Page nextPage) {
        this.nextPage = nextPage;
    }
}

