/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.trs;

public class HttpConstants {
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String DATE = "Date";
    public static final String PRAGMA = "Pragma";
    public static final String TRAILER = "Trailer";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String NO_CACHE = "no-cache";
    public static final String NO_STORE = "no-store";
    public static final String MAX_AGE = "max-age";
    public static final String MAX_STALE = "max-stale";
    public static final String MIN_FRESH = "min-fresh";
    public static final String S_MAXAGE = "s-maxage";
    public static final String PROXY_MAXAGE = "s-maxage";
    public static final String ONLY_IF_CACHED = "only-if-cached";
    public static final String MUST_REVALIDATE = "must-revalidate";
    public static final String PROXY_REVALIDATE = "proxy-revalidate";
    public static final String NO_TRANSFORM = "no-transform";
    public static final String DEFAULT_LIFETIME = "x-jfs-default-lifetime";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String AUTHORIZATION = "Authorization";
    public static final String EXPECT = "Expect";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String LINK = "Link";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String X_METHOD_OVERRIDE = "X-Method-Override";
    public static final String X_LAST_MODIFIED_XSD = "X-Last-Modified-XSD";
    public static final String X_LAST_MODIFIED_USER = "X-Last-Modified-User";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String TE = "TE";
    public static final String NAME_HEADER = "Name";
    public static final String SECURITY_CONTEXT_HEADER = "X-Jazz-Owning-Context";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String AGE = "Age";
    public static final String ETAG = "ETag";
    public static final String LOCATION = "Location";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String SERVER = "Server";
    public static final String VARY = "Vary";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String LAST_MODIFIED_USER = "X-Last-Modified-User";
    public static final String LAST_MODIFIED_XSD = "X-Last-Modified-XSD";
    public static final String X_OAUTH_AUTHORIZATION_URL = "X-jazz-web-oauth-url";
    public static final String X_JAZZ_AUTHORIZATION_GUIDANCE = "X-Jazz-Authorization-Guidance";
    public static final String X_JAZZ_CREATOR = "X-Jazz-Creator";
    public static final String X_JAZZ_CREATED = "X-Jazz-Created";
    public static final String X_JAZZ_CONTRIBUTOR = "X-Jazz-Contributor";
    public static final String X_JAZZ_MODIFIED = "X-Jazz-Modified";
    public static final String X_JAZZ_CURRENT = "X-Jazz-Current";
    public static final String X_JAZZ_REVISION = "X-Jazz-Revision";
    public static final String X_JAZZ_ARCHIVED = "X-Jazz-Archived";
    public static final String X_JAZZ_FORCE_ORDERING = "X-Jazz-Force-Ordering";
    public static final String X_JAZZ_CSRF_PREVENT = "X-Jazz-CSRF-Prevent";
    public static final String OSLC_CORE_VER = "OSLC-Core-Version";
    public static final String ALLOW = "Allow";
    public static final String COOKIE = "Cookie";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String EXPIRES = "Expires";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String KEEP_ALIVE = "Keep-Alive";
    public static final String WILDCARD = "*";
    public static final String WEAK_ETAG_PREFIX = "W/";
    public static final String GZIP = "gzip";
    public static final String SSL = "SSL";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String FORWARD_SLASH = "/";
    public static final String BACKWARDS_SLASH = "\\";
    public static final String CLOSE = "Close";
    public static final String CHARSET = "charset";
    public static final String OK = "OK";
    public static final String AMPERSAND = "&";
    public static final String COLON = ":";
    public static final String COLON_SLASH_SLASH = "://";
    public static final String COMMA = ",";
    public static final String EMPTY = "";
    public static final String EQUALS = "=";
    public static final String HASH = "#";
    public static final String PERIOD = ".";
    public static final String PLUS = "+";
    public static final String QUESTION = "?";
    public static final String SLASH = "/";
    public static final String SPACE = " ";
    public static final String STAR = "*";
    public static final String SEMI_COLON = ";";
    public static final String CONTEXT = "context";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int DEFAULT_PAGE_SIZE = 100;
    public static final String PAGE_SIZE = "pageSize";
    public static final String QUERY = "query";
    public static final String SEARCH = "q";
    public static final String SIZE = "size";
    public static final String ITERATE = "iterate";
    public static final String URL = "url";
    public static final String REVISION = "revision";
    public static final String URL_ENCODED_SPACE = "%20";
    public static final String URL_ENCODED_PLUS = "%2B";
    public static final String CT_ANY = "*";
    public static final String CT_ANY_ANY = "*/*";
    public static final String CT_APPLICATION_ATOM_XML = "application/atom+xml";
    public static final String CT_APPLICATION_JAVASCRIPT = "application/javascript";
    public static final String CT_APPLICATION_JSON = "application/json";
    public static final String CT_APPLICATION_JSONREQUEST = "application/jsonrequest";
    public static final String CT_APPLICATION_NTRIPLES = "application/ntriples";
    public static final String CT_APPLICATION_SPARQL_QUERY = "application/sparql-query";
    public static final String CT_APPLICATION_SPARQL_RESULTS_JSON = "application/sparql-results+json";
    public static final String CT_APPLICATION_SPARQL_RESULTS_XML = "application/sparql-results+xml";
    public static final String CT_APPLICATION_TURTLE = "application/x-turtle";
    public static final String CT_APPLICATION_RDF_XML = "application/rdf+xml";
    public static final String CT_APPLICATION_XML = "application/xml";
    public static final String CT_APPLICATION_ZIP = "application/zip";
    public static final String CT_APPLICATION_URL_ENCODED = "application/x-www-form-urlencoded";
    public static final String CT_APPLICATION_XHTML = "application/xhtml+xml";
    public static final String CT_APPLICATION_INDEX_SPEC = "application/net.jazz.foundation.indexer+xml";
    public static final String CT_TEXT_JSON = "text/json";
    public static final String CT_TEXT_N3 = "text/n3";
    public static final String CT_TEXT_PLAIN = "text/plain";
    public static final String CT_TEXT_TURTLE = "text/turtle";
    public static final String CT_TEXT_HTML = "text/html";
    public static final String CT_TEXT_XML = "text/xml";
    public static final String CT_TEXT_CSS = "text/css";
    public static final String CT_TEXT_JAVASCRIPT = "text/javascript";
    public static final String CT_RDF_XML = "RDF/XML";

    public static enum HttpMethod {
        OPTIONS("OPTIONS"),
        GET("GET"),
        HEAD("HEAD"),
        POST("POST"),
        PUT("PUT"),
        DELETE("DELETE"),
        TRACE("TRACE"),
        CONNECT("CONNECT");

        private final String _name;

        private HttpMethod(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public static HttpMethod fromString(String name) {
            if (name == null) {
                return null;
            }
            for (HttpMethod mType : HttpMethod.values()) {
                if (!mType.toString().equalsIgnoreCase(name)) continue;
                return mType;
            }
            return null;
        }
    }
}

