/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.query;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.eclipse.lyo.client.query.OslcQuery;
import org.eclipse.lyo.oslc4j.core.exception.LyoModelException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OslcQueryResult
implements Iterator<OslcQueryResult> {
    private static final Logger log = LoggerFactory.getLogger(OslcQueryResult.class);
    public static final Property DEFAULT_MEMBER_PROPERTY = RDFS.member;
    public static final String SELECT_ANY_MEMBER = "org.eclipse.lyo.client.oslc.query.selectAnyMember";
    private final OslcQuery query;
    private final Response response;
    private final InputStream inputStream;
    private final int pageNumber;
    private Property memberProperty = DEFAULT_MEMBER_PROPERTY;
    private Model rdfModel;
    private Resource infoResource;
    private Resource membersResource;
    private String nextPageUrl = "";
    private boolean rdfInitialized = false;

    @Deprecated
    public OslcQueryResult(OslcQuery query, Response response) {
        this.query = query;
        this.response = response;
        this.inputStream = (InputStream)response.readEntity(InputStream.class);
        this.pageNumber = 1;
    }

    public OslcQueryResult(OslcQuery query, InputStream inputStream) {
        this.query = query;
        this.response = null;
        this.inputStream = inputStream;
        this.pageNumber = 1;
    }

    private OslcQueryResult(OslcQueryResult prev) {
        this.query = new OslcQuery(prev);
        this.response = this.query.getResponse();
        this.inputStream = (InputStream)this.response.readEntity(InputStream.class);
        this.membersResource = prev.membersResource;
        this.memberProperty = prev.memberProperty;
        this.pageNumber = prev.pageNumber + 1;
    }

    private synchronized void initializeRdf() {
        if (!this.rdfInitialized) {
            this.rdfInitialized = true;
            this.rdfModel = ModelFactory.createDefaultModel();
            this.rdfModel.read(this.inputStream, this.query.getCapabilityUrl());
            Property rdfType = this.rdfModel.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
            Property responseInfo = this.rdfModel.createProperty("http://open-services.net/ns/core#", "ResponseInfo");
            ResIterator iter = this.rdfModel.listResourcesWithProperty(rdfType, (RDFNode)responseInfo);
            List responseInfos = iter.toList();
            this.infoResource = null;
            this.membersResource = this.rdfModel.getResource(this.query.getCapabilityUrl());
            if (responseInfos.isEmpty()) {
                return;
            }
            this.infoResource = this.tryFindOnlyResponseInfo(responseInfos);
            if (this.infoResource != null) {
                log.debug("Found exactly one ResponseInfo");
                return;
            }
            log.trace("Cannot find exactly one ResponseInfo");
            this.infoResource = this.tryFindOnlyWithNextPage(responseInfos);
            if (this.infoResource != null) {
                log.debug("Found exactly one ResponseInfo with nextPage");
                return;
            }
            log.trace("Cannot find exactly one ResponseInfo with nextPage");
            this.infoResource = this.tryFindExactResponseInfoUri(responseInfos);
            if (this.infoResource != null) {
                log.debug("Found a ResponseInfo whose URI matches the query URI exactly");
                return;
            }
            log.trace("Cannot a ResponseInfo whose URI matches the query URI exactly");
            this.infoResource = this.tryFindPrefixedResponseInfoUri(responseInfos);
            if (this.infoResource != null) {
                log.debug("Found exactly one ResponseInfo whose URI starts with the query URI");
                return;
            }
            log.trace("Cannot find exactly one ResponseInfo whose URI starts with the query URI");
            if (this.infoResource == null) {
                throw new IllegalStateException("Failed to find an appropriate ResponseInfo object");
            }
        }
    }

    private Resource tryFindOnlyWithNextPage(List<Resource> responseInfos) {
        Property nextPagePredicate = this.rdfModel.getProperty("http://open-services.net/ns/core#", "nextPage");
        List<Resource> responsesWithNextPage = responseInfos.stream().filter(ri -> ri.getProperty(nextPagePredicate) != null).toList();
        if (responsesWithNextPage.size() == 1) {
            return responsesWithNextPage.get(0);
        }
        if (responsesWithNextPage.size() > 1) {
            log.warn("Multiple ResponseInfo objects found with nextPage predicate");
        }
        return null;
    }

    private Resource tryFindPrefixedResponseInfoUri(List<Resource> responseInfos) {
        List<Resource> filteredObjects = responseInfos.stream().filter(ri -> ri.getURI().startsWith(this.query.getQueryUrl())).toList();
        if (filteredObjects.size() == 1) {
            return filteredObjects.get(0);
        }
        if (filteredObjects.size() > 1) {
            log.warn("Multiple ResponseInfo objects found starting with the same Query URI");
        }
        return null;
    }

    private Resource tryFindExactResponseInfoUri(List<Resource> responseInfos) {
        List<Resource> filteredObjects = responseInfos.stream().filter(ri -> ri.getURI().equals(this.query.getQueryUrl())).toList();
        if (filteredObjects.size() == 1) {
            return filteredObjects.get(0);
        }
        if (filteredObjects.size() > 1) {
            throw new IllegalStateException("Multiple ResponseInfo objects found with the same URI");
        }
        return null;
    }

    private Resource tryFindOnlyResponseInfo(List<Resource> responseInfos) {
        if (responseInfos.size() == 1) {
            return responseInfos.get(0);
        }
        return null;
    }

    String getNextPageUrl() {
        this.initializeRdf();
        if ((this.nextPageUrl == null || this.nextPageUrl.isEmpty()) && this.infoResource != null) {
            Property predicate = this.rdfModel.getProperty("http://open-services.net/ns/core#", "nextPage");
            StmtIterator iter = this.rdfModel.listStatements(this.infoResource, predicate, (RDFNode)null);
            if (iter.hasNext()) {
                Statement nextPage = (Statement)iter.next();
                this.nextPageUrl = nextPage.getResource().getURI();
            } else {
                this.nextPageUrl = "";
            }
        }
        return this.nextPageUrl;
    }

    @Override
    public boolean hasNext() {
        return !"".equals(this.getNextPageUrl());
    }

    @Override
    public OslcQueryResult next() {
        return new OslcQueryResult(this);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public OslcQuery getQuery() {
        return this.query;
    }

    public String getMemberProperty() {
        return this.memberProperty.getURI();
    }

    public void setMemberProperty(String memberPredicate) {
        this.memberProperty = ModelFactory.createDefaultModel().createProperty(memberPredicate);
    }

    @Deprecated
    public Response getRawResponse() {
        return this.response;
    }

    private ExtendedIterator<Statement> getMemberStatements() {
        if ("true".equalsIgnoreCase(System.getProperty(SELECT_ANY_MEMBER))) {
            return this.rdfModel.listStatements(this.membersResource, null, (RDFNode)null).filterKeep(s -> {
                String fqPredicateName = s.getPredicate().getNameSpace() + s.getPredicate().getLocalName();
                if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(fqPredicateName)) {
                    return false;
                }
                return s.getObject().isResource();
            });
        }
        return this.rdfModel.listStatements(this.membersResource, this.memberProperty, (RDFNode)null);
    }

    public String[] getMembersUrls() {
        this.initializeRdf();
        ArrayList<String> membersUrls = new ArrayList<String>();
        ExtendedIterator<Statement> iter = this.getMemberStatements();
        while (iter.hasNext()) {
            Statement member = (Statement)iter.next();
            membersUrls.add(member.getResource().getURI());
        }
        return membersUrls.toArray(new String[membersUrls.size()]);
    }

    public <T> Iterable<T> getMembers(final Class<T> clazz) {
        this.initializeRdf();
        final ExtendedIterator<Statement> iter = this.getMemberStatements();
        Iterable result = () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                Statement member = (Statement)iter.next();
                try {
                    return JenaModelHelper.fromJenaResource((Resource)((Resource)member.getObject()), (Class)clazz);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | URISyntaxException | DatatypeConfigurationException | OslcCoreApplicationException e) {
                    throw new LyoModelException(e);
                }
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
        return result;
    }

    public Iterable<Resource> getMembers() {
        this.initializeRdf();
        final ExtendedIterator<Statement> iter = this.getMemberStatements();
        Iterable<Resource> result = () -> new Iterator<Resource>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Resource next() {
                Statement member = (Statement)iter.next();
                try {
                    return (Resource)member.getObject();
                }
                catch (IllegalArgumentException | SecurityException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
        return result;
    }
}

