/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc;

import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.ConcurrentMessageProcessor;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageConsumer;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageProducer;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.jsonrpc.validation.ReflectiveMessageValidator;

public interface Launcher<T> {
    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out) {
        return Launcher.createLauncher(localService, remoteInterface, in, out, false, null);
    }

    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, boolean validate, PrintWriter trace) {
        Function<MessageConsumer, MessageConsumer> wrapper = consumer -> {
            MessageConsumer result = consumer;
            if (trace != null) {
                result = message -> {
                    trace.println(message);
                    trace.flush();
                    consumer.consume(message);
                };
            }
            if (validate) {
                result = new ReflectiveMessageValidator(result);
            }
            return result;
        };
        return Launcher.createIoLauncher(localService, remoteInterface, in, out, Executors.newCachedThreadPool(), wrapper);
    }

    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return Launcher.createIoLauncher(localService, remoteInterface, in, out, executorService, wrapper);
    }

    public static <T> Launcher<T> createIoLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        Consumer<GsonBuilder> configureGson = gsonBuilder -> {};
        return Launcher.createIoLauncher(localService, remoteInterface, in, out, executorService, wrapper, configureGson);
    }

    public static <T> Launcher<T> createIoLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, final ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper, Consumer<GsonBuilder> configureGson) {
        List<Object> localServiceList = Collections.singletonList(localService);
        List<Class<?>> remoteInterfaceList = Collections.singletonList(remoteInterface);
        MessageJsonHandler jsonHandler = Launcher.setupJsonHandler(localServiceList, remoteInterfaceList, configureGson);
        final RemoteEndpoint remoteEndpoint = Launcher.setupRemoteEndpoint(localServiceList, out, jsonHandler, wrapper);
        final MessageConsumer messageConsumer = wrapper.apply(remoteEndpoint);
        final StreamMessageProducer reader = new StreamMessageProducer(in, jsonHandler, remoteEndpoint);
        final T remoteProxy = ServiceEndpoints.toServiceObject(remoteEndpoint, remoteInterface);
        return new Launcher<T>(){

            @Override
            public Future<Void> startListening() {
                return ConcurrentMessageProcessor.startProcessing(reader, messageConsumer, executorService);
            }

            @Override
            public T getRemoteProxy() {
                return remoteProxy;
            }

            @Override
            public RemoteEndpoint getRemoteEndpoint() {
                return remoteEndpoint;
            }
        };
    }

    public static Launcher<Object> createIoLauncher(Collection<Object> localServices, Collection<Class<?>> remoteInterfaces, ClassLoader classLoader, InputStream in, OutputStream out, final ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper, Consumer<GsonBuilder> configureGson) {
        MessageJsonHandler jsonHandler = Launcher.setupJsonHandler(localServices, remoteInterfaces, configureGson);
        final RemoteEndpoint remoteEndpoint = Launcher.setupRemoteEndpoint(localServices, out, jsonHandler, wrapper);
        final MessageConsumer messageConsumer = wrapper.apply(remoteEndpoint);
        final StreamMessageProducer reader = new StreamMessageProducer(in, jsonHandler, remoteEndpoint);
        final Object remoteProxy = ServiceEndpoints.toServiceObject(remoteEndpoint, remoteInterfaces, classLoader);
        return new Launcher<Object>(){

            @Override
            public Future<Void> startListening() {
                return ConcurrentMessageProcessor.startProcessing(reader, messageConsumer, executorService);
            }

            @Override
            public Object getRemoteProxy() {
                return remoteProxy;
            }

            @Override
            public RemoteEndpoint getRemoteEndpoint() {
                return remoteEndpoint;
            }
        };
    }

    public static MessageJsonHandler setupJsonHandler(Collection<Object> localServices, Collection<Class<?>> remoteInterfaces, Consumer<GsonBuilder> configureGson) {
        LinkedHashMap<String, JsonRpcMethod> supportedMethods = new LinkedHashMap<String, JsonRpcMethod>();
        for (Class<?> interface_ : remoteInterfaces) {
            supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(interface_));
        }
        for (Object localService : localServices) {
            if (localService instanceof JsonRpcMethodProvider) {
                JsonRpcMethodProvider rpcMethodProvider = (JsonRpcMethodProvider)localService;
                supportedMethods.putAll(rpcMethodProvider.supportedMethods());
                continue;
            }
            supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(localService.getClass()));
        }
        if (configureGson != null) {
            return new MessageJsonHandler(supportedMethods, configureGson);
        }
        return new MessageJsonHandler(supportedMethods);
    }

    public static RemoteEndpoint setupRemoteEndpoint(Collection<Object> localServices, OutputStream out, MessageJsonHandler jsonHandler, Function<MessageConsumer, MessageConsumer> wrapper) {
        MessageConsumer outgoingMessageStream = new StreamMessageConsumer(out, jsonHandler);
        outgoingMessageStream = wrapper.apply(outgoingMessageStream);
        RemoteEndpoint remoteEndpoint = new RemoteEndpoint(outgoingMessageStream, ServiceEndpoints.toEndpoint(localServices));
        jsonHandler.setMethodProvider(remoteEndpoint);
        return remoteEndpoint;
    }

    public Future<Void> startListening();

    public T getRemoteProxy();

    public RemoteEndpoint getRemoteEndpoint();
}

