/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.services;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.services.AnnotationUtil;

public class GenericEndpoint
implements Endpoint {
    private static final Logger LOG = Logger.getLogger(GenericEndpoint.class.getName());
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private final LinkedHashMap<String, Function<Object, CompletableFuture<Object>>> methodHandlers = new LinkedHashMap();
    private final Object delegate;

    public GenericEndpoint(Object delegate) {
        this.delegate = delegate;
        this.recursiveFindRpcMethods(delegate, new HashSet(), new HashSet());
    }

    protected void recursiveFindRpcMethods(Object current, Set<Class<?>> visited, Set<Class<?>> visitedForDelegate) {
        AnnotationUtil.findRpcMethods(current.getClass(), visited, methodInfo -> {
            Function<Object, CompletableFuture> handler = arg -> {
                try {
                    Method method = methodInfo.method;
                    Object[] arguments = this.getArguments(method, arg);
                    return (CompletableFuture)method.invoke(current, arguments);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            if (this.methodHandlers.put(methodInfo.name, handler) != null) {
                throw new IllegalStateException("Multiple methods for name " + methodInfo.name);
            }
        });
        AnnotationUtil.findDelegateSegments(current.getClass(), visitedForDelegate, method -> {
            try {
                Object delegate = method.invoke(current, new Object[0]);
                if (delegate != null) {
                    this.recursiveFindRpcMethods(delegate, visited, visitedForDelegate);
                } else {
                    LOG.log(Level.SEVERE, "A delegate object is null, jsonrpc methods of '" + method + "' are ignored");
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected Object[] getArguments(Method method, Object arg) {
        if (arg == null) {
            return NO_ARGUMENTS;
        }
        if (method.getParameterCount() == 0) {
            LOG.warning("Unexpected params '" + arg + "' for '" + method + "' is ignored");
            return NO_ARGUMENTS;
        }
        return new Object[]{arg};
    }

    @Override
    public CompletableFuture<?> request(String method, Object parameter) {
        Function<Object, CompletableFuture<Object>> handler = this.methodHandlers.get(method);
        if (handler != null) {
            return handler.apply(parameter);
        }
        if (this.delegate instanceof Endpoint) {
            return ((Endpoint)this.delegate).request(method, parameter);
        }
        String message = "Unsupported request method: " + method;
        LOG.log(Level.WARNING, message);
        CompletableFuture exceptionalResult = new CompletableFuture();
        ResponseError error = new ResponseError(ResponseErrorCode.InvalidRequest, message, null);
        exceptionalResult.completeExceptionally(new ResponseErrorException(error));
        return exceptionalResult;
    }

    @Override
    public void notify(String method, Object parameter) {
        Function<Object, CompletableFuture<Object>> handler = this.methodHandlers.get(method);
        if (handler != null) {
            handler.apply(parameter);
            return;
        }
        if (this.delegate instanceof Endpoint) {
            ((Endpoint)this.delegate).notify(method, parameter);
            return;
        }
        LOG.log(Level.WARNING, "Unsupported notification method: " + method);
    }
}

