/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.services;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.services.AnnotationUtil;
import org.eclipse.lsp4j.jsonrpc.services.EndpointProxy;
import org.eclipse.lsp4j.jsonrpc.services.GenericEndpoint;

public final class ServiceEndpoints {
    private ServiceEndpoints() {
    }

    public static <T> T toServiceObject(Endpoint endpoint, Class<T> interface_) {
        Object newProxyInstance = Proxy.newProxyInstance(interface_.getClassLoader(), new Class[]{interface_, Endpoint.class}, (InvocationHandler)new EndpointProxy(endpoint, interface_));
        return (T)newProxyInstance;
    }

    public static Endpoint toEndpoint(Object serviceObject) {
        return new GenericEndpoint(serviceObject);
    }

    public static Map<String, JsonRpcMethod> getSupportedMethods(Class<?> type) {
        HashSet visitedTypes = new HashSet();
        return ServiceEndpoints.getSupportedMethods(type, visitedTypes);
    }

    private static Map<String, JsonRpcMethod> getSupportedMethods(Class<?> type, Set<Class<?>> visitedTypes) {
        LinkedHashMap<String, JsonRpcMethod> result = new LinkedHashMap<String, JsonRpcMethod>();
        AnnotationUtil.findRpcMethods(type, visitedTypes, methodInfo -> {
            JsonRpcMethod meth;
            if (methodInfo.isNotification) {
                meth = JsonRpcMethod.notification(methodInfo.name, methodInfo.parameterType);
            } else {
                Type returnType = methodInfo.method.getGenericReturnType();
                if (returnType instanceof ParameterizedType) {
                    ParameterizedType rType = (ParameterizedType)returnType;
                    meth = JsonRpcMethod.request(methodInfo.name, methodInfo.parameterType, rType.getActualTypeArguments()[0]);
                } else {
                    throw new IllegalStateException("Expecting return type of CompletableFuture but was : " + returnType);
                }
            }
            if (result.put(methodInfo.name, meth) != null) {
                throw new IllegalStateException("Duplicate RPC method " + methodInfo.name + ".");
            }
        });
        AnnotationUtil.findDelegateSegments(type, new HashSet(), method -> {
            Map<String, JsonRpcMethod> supportedDelegateMethods = ServiceEndpoints.getSupportedMethods(method.getReturnType(), visitedTypes);
            for (JsonRpcMethod meth : supportedDelegateMethods.values()) {
                if (result.put(meth.getMethodName(), meth) == null) continue;
                throw new IllegalStateException("Duplicate RPC method " + meth.getMethodName() + ".");
            }
        });
        return result;
    }
}

