/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageProducer;
import org.eclipse.lsp4j.jsonrpc.json.InvalidMessageException;
import org.eclipse.lsp4j.jsonrpc.json.MessageConstants;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.messages.Message;

public class StreamMessageProducer
implements MessageProducer,
Closeable,
MessageConstants {
    private final MessageJsonHandler jsonHandler;
    private InputStream input;
    private MessageConsumer callback;
    private boolean keepRunning;

    public StreamMessageProducer(InputStream input, MessageJsonHandler jsonHandler) {
        this.input = input;
        this.jsonHandler = jsonHandler;
    }

    public InputStream getInput() {
        return this.input;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    @Override
    public void listen(MessageConsumer callback) {
        this.callback = callback;
        this.keepRunning = true;
        StringBuilder headerBuilder = null;
        StringBuilder debugBuilder = null;
        boolean newLine = false;
        Headers headers = new Headers();
        while (this.keepRunning) {
            try {
                int c = this.input.read();
                if (c == -1) {
                    this.keepRunning = false;
                    continue;
                }
                if (debugBuilder == null) {
                    debugBuilder = new StringBuilder();
                }
                debugBuilder.append((char)c);
                if (c == 10) {
                    if (newLine) {
                        if (headers.contentLength < 0) {
                            this.fireError(new IllegalStateException("Missing header Content-Length in input \"" + debugBuilder + "\""));
                        } else {
                            boolean result = this.handleMessage(this.input, headers);
                            if (!result) {
                                this.keepRunning = false;
                            }
                            newLine = false;
                        }
                        headers = new Headers();
                        debugBuilder = null;
                    } else if (headerBuilder != null) {
                        this.parseHeader(headerBuilder.toString(), headers);
                        headerBuilder = null;
                    }
                    newLine = true;
                    continue;
                }
                if (c == 13) continue;
                if (headerBuilder == null) {
                    headerBuilder = new StringBuilder();
                }
                headerBuilder.append((char)c);
                newLine = false;
            }
            catch (InterruptedIOException c) {
            }
            catch (ClosedChannelException c) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void fireError(Throwable exception) {
        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
    }

    protected void parseHeader(String line, Headers headers) {
        int sepIndex = line.indexOf(58);
        if (sepIndex >= 0) {
            String key;
            switch (key = line.substring(0, sepIndex).trim()) {
                case "Content-Length": {
                    try {
                        headers.contentLength = Integer.parseInt(line.substring(sepIndex + 1).trim());
                    }
                    catch (NumberFormatException e) {
                        this.fireError(e);
                    }
                    break;
                }
                case "Content-Type": {
                    int charsetIndex = line.indexOf("charset=");
                    if (charsetIndex < 0) break;
                    headers.charset = line.substring(charsetIndex + 8).trim();
                    break;
                }
            }
        }
    }

    protected boolean handleMessage(InputStream input, Headers headers) throws IOException {
        try {
            int readResult;
            int contentLength = headers.contentLength;
            byte[] buffer = new byte[contentLength];
            for (int bytesRead = 0; bytesRead < contentLength; bytesRead += readResult) {
                readResult = input.read(buffer, bytesRead, contentLength - bytesRead);
                if (readResult != -1) continue;
                return false;
            }
            String content = new String(buffer, headers.charset);
            Message message = this.jsonHandler.parseMessage(content);
            this.callback.consume(message);
        }
        catch (UnsupportedEncodingException | InvalidMessageException e) {
            this.fireError(e);
        }
        return true;
    }

    @Override
    public void close() {
        this.keepRunning = false;
    }

    private static class Headers {
        int contentLength = -1;
        String charset = StandardCharsets.UTF_8.name();

        private Headers() {
        }
    }
}

