/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.debug.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Type;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.debug.messages.DebugNotificationMessage;
import org.eclipse.lsp4j.jsonrpc.debug.messages.DebugRequestMessage;
import org.eclipse.lsp4j.jsonrpc.debug.messages.DebugResponseMessage;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.adapters.MessageTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.MessageIssue;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;

public class DebugMessageTypeAdapter
extends MessageTypeAdapter {
    private final MessageJsonHandler handler;
    private final Gson gson;

    public DebugMessageTypeAdapter(MessageJsonHandler handler, Gson gson) {
        super(handler, gson);
        this.handler = handler;
        this.gson = gson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        in.beginObject();
        String messageType = null;
        String method = null;
        String message = null;
        int seq = 0;
        int request_seq = 0;
        Boolean rawSuccess = null;
        Object rawParams = null;
        Object rawBody = null;
        try {
            block24: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "seq": {
                        seq = in.nextInt();
                        continue block24;
                    }
                    case "request_seq": {
                        request_seq = in.nextInt();
                        continue block24;
                    }
                    case "type": {
                        messageType = in.nextString();
                        continue block24;
                    }
                    case "success": {
                        rawSuccess = in.nextBoolean();
                        continue block24;
                    }
                    case "command": {
                        method = in.nextString();
                        continue block24;
                    }
                    case "event": {
                        method = in.nextString();
                        continue block24;
                    }
                    case "message": {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            continue block24;
                        }
                        message = in.nextString();
                        continue block24;
                    }
                    case "arguments": {
                        rawParams = this.parseParams(in, method);
                        continue block24;
                    }
                    case "body": {
                        rawBody = this.parseBody(in, messageType, request_seq, method, rawSuccess);
                        continue block24;
                    }
                }
                in.skipValue();
            }
            boolean success = rawSuccess != null ? rawSuccess : false;
            Object params = this.parseParams(rawParams, method);
            Object body = this.parseBody(rawBody, messageType, request_seq, method, (Boolean)success);
            in.endObject();
            return this.createMessage(messageType, seq, request_seq, method, success, message, params, body);
        }
        catch (JsonSyntaxException | MalformedJsonException | EOFException exception) {
            if (!("request".equals(messageType) || "event".equals(messageType) || "response".equals(messageType))) {
                throw exception;
            }
            boolean success = rawSuccess != null ? rawSuccess : false;
            Message resultMessage = this.createMessage(messageType, seq, request_seq, method, success, message, rawParams, rawBody);
            MessageIssue issue = new MessageIssue("Message could not be parsed.", ResponseErrorCode.ParseError.getValue(), (Exception)exception);
            throw new MessageIssueException(resultMessage, issue);
        }
    }

    protected Object parseBody(JsonReader in, String messageType, int request_seq, String method, Boolean success) throws IOException {
        if ("event".equals(messageType)) {
            return this.parseParams(in, method);
        }
        if ("response".equals(messageType) && success != null && success.booleanValue()) {
            return super.parseResult(in, Integer.toString(request_seq));
        }
        return new JsonParser().parse(in);
    }

    protected Object parseBody(Object rawBody, String messageType, int request_seq, String method, Boolean success) {
        if ("event".equals(messageType)) {
            return this.parseParams(rawBody, method);
        }
        if ("response".equals(messageType)) {
            if (success != null && success.booleanValue()) {
                return super.parseResult(rawBody, Integer.toString(request_seq));
            }
            if (this.isNull(rawBody)) {
                return null;
            }
            if (!(rawBody instanceof JsonElement)) {
                return rawBody;
            }
            JsonElement rawJsonParams = (JsonElement)rawBody;
            return this.fromJson(rawJsonParams, (Type)((Object)Object.class));
        }
        return rawBody;
    }

    private Message createMessage(String messageType, int seq, int request_seq, String method, boolean success, String errorMessage, Object params, Object body) throws JsonParseException {
        if (messageType == null) {
            throw new JsonParseException("Unable to identify the input message. Missing 'type' field.");
        }
        switch (messageType) {
            case "request": {
                DebugRequestMessage message = new DebugRequestMessage();
                message.setId(seq);
                message.setMethod(method);
                message.setParams(params);
                return message;
            }
            case "event": {
                DebugNotificationMessage message = new DebugNotificationMessage();
                message.setId(seq);
                message.setMethod(method);
                message.setParams(body);
                return message;
            }
            case "response": {
                DebugResponseMessage message = new DebugResponseMessage();
                message.setId(request_seq);
                message.setResponseId(seq);
                message.setMethod(method);
                if (!success) {
                    ResponseError error = new ResponseError();
                    error.setCode(ResponseErrorCode.UnknownErrorCode);
                    error.setData(body);
                    if (errorMessage == null) {
                        errorMessage = "Unset error message.";
                    }
                    error.setMessage(errorMessage);
                    message.setError(error);
                } else {
                    JsonRpcMethod jsonRpcMethod;
                    String resolvedMethod;
                    MethodProvider methodProvider;
                    if (body instanceof JsonElement && (methodProvider = this.handler.getMethodProvider()) != null && (resolvedMethod = methodProvider.resolveMethod(Integer.toString(request_seq))) != null && (jsonRpcMethod = this.handler.getJsonRpcMethod(resolvedMethod)) != null) {
                        TypeAdapter typeAdapter = null;
                        Type returnType = jsonRpcMethod.getReturnType();
                        if (jsonRpcMethod.getReturnTypeAdapterFactory() != null) {
                            typeAdapter = jsonRpcMethod.getReturnTypeAdapterFactory().create(this.gson, TypeToken.get((Type)returnType));
                        }
                        JsonElement jsonElement = (JsonElement)body;
                        body = typeAdapter != null ? typeAdapter.fromJsonTree(jsonElement) : this.gson.fromJson(jsonElement, returnType);
                    }
                    message.setResult(body);
                }
                return message;
            }
        }
        throw new JsonParseException("Unable to identify the input message.");
    }

    public void write(JsonWriter out, Message message) throws IOException {
        out.beginObject();
        if (message instanceof DebugRequestMessage) {
            DebugRequestMessage requestMessage = (DebugRequestMessage)message;
            out.name("type");
            out.value("request");
            out.name("seq");
            this.writeIntId(out, (Either<String, Number>)requestMessage.getRawId());
            out.name("command");
            out.value(requestMessage.getMethod());
            out.name("arguments");
            Object params = requestMessage.getParams();
            if (params == null) {
                this.writeNullValue(out);
            } else {
                this.gson.toJson(params, params.getClass(), out);
            }
        } else if (message instanceof DebugResponseMessage) {
            DebugResponseMessage responseMessage = (DebugResponseMessage)message;
            out.name("type");
            out.value("response");
            out.name("seq");
            this.writeIntId(out, responseMessage.getRawResponseId());
            out.name("request_seq");
            this.writeIntId(out, (Either<String, Number>)responseMessage.getRawId());
            out.name("command");
            out.value(responseMessage.getMethod());
            ResponseError error = responseMessage.getError();
            if (error != null) {
                out.name("success");
                out.value(false);
                String errorMessage = error.getMessage();
                out.name("message");
                if (errorMessage == null) {
                    this.writeNullValue(out);
                } else {
                    this.gson.toJson((Object)errorMessage, errorMessage.getClass(), out);
                }
                Object errorData = error.getData();
                if (errorData != null) {
                    out.name("body");
                    this.gson.toJson(errorData, errorData.getClass(), out);
                }
            } else {
                out.name("success");
                out.value(true);
                out.name("body");
                Object result = responseMessage.getResult();
                if (result == null) {
                    this.writeNullValue(out);
                } else {
                    this.gson.toJson(result, result.getClass(), out);
                }
            }
        } else if (message instanceof DebugNotificationMessage) {
            DebugNotificationMessage notificationMessage = (DebugNotificationMessage)message;
            out.name("type");
            out.value("event");
            out.name("seq");
            this.writeIntId(out, notificationMessage.getRawId());
            out.name("event");
            out.value(notificationMessage.getMethod());
            out.name("body");
            Object params = notificationMessage.getParams();
            if (params == null) {
                this.writeNullValue(out);
            } else {
                this.gson.toJson(params, params.getClass(), out);
            }
        }
        out.endObject();
    }

    private void writeIntId(JsonWriter out, Either<String, Number> id) throws IOException {
        if (id == null) {
            this.writeNullValue(out);
        } else if (id.isLeft()) {
            out.value((long)Integer.parseInt((String)id.getLeft()));
        } else if (id.isRight()) {
            out.value((Number)id.getRight());
        }
    }

    public static class Factory
    implements TypeAdapterFactory {
        private final MessageJsonHandler handler;

        public Factory(MessageJsonHandler handler) {
            this.handler = handler;
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Message.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new DebugMessageTypeAdapter(this.handler, gson);
        }
    }
}

