/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.request;

import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.stack.ReliabilityLayerParameters;
import org.eclipse.leshan.server.request.LowerLayerConfig;

public class CoapRequestConfig
implements LowerLayerConfig {
    private final ReliabilityLayerParameters reliabilityLayerParameters;

    private CoapRequestConfig(ReliabilityLayerParameters reliabilityLayerParameters) {
        this.reliabilityLayerParameters = reliabilityLayerParameters;
    }

    public void apply(Object lowerRequest) {
        if (lowerRequest instanceof Request) {
            this.apply((Request)lowerRequest);
        }
    }

    protected void apply(Request coapRequest) {
        if (this.reliabilityLayerParameters != null) {
            coapRequest.setReliabilityLayerParameters(this.reliabilityLayerParameters);
        }
    }

    public static CoapRequestConfig reliabilityConfig(ReliabilityLayerParameters.Builder reliabilityParametersBuilder) {
        return CoapRequestConfig.builder().setReliabilityLayerParameters(reliabilityParametersBuilder.build()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ReliabilityLayerParameters reliabilityLayerParameters;

        private Builder() {
        }

        public Builder setReliabilityLayerParameters(ReliabilityLayerParameters reliabilityLayerParameters) {
            this.reliabilityLayerParameters = reliabilityLayerParameters;
            return this;
        }

        public CoapRequestConfig build() {
            return new CoapRequestConfig(this.reliabilityLayerParameters);
        }
    }
}

