/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.request;

import java.util.Collection;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.leshan.core.californium.EndpointContextUtil;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mObject;
import org.eclipse.leshan.core.node.LwM2mObjectInstance;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.codec.LwM2mNodeEncoder;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.BootstrapFinishRequest;
import org.eclipse.leshan.core.request.BootstrapWriteRequest;
import org.eclipse.leshan.core.request.CancelObservationRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequestVisitor2;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.util.StringUtils;
import org.eclipse.leshan.server.californium.observation.ObserveUtil;
import org.eclipse.leshan.server.request.LowerLayerConfig;

public class CoapRequestBuilder
implements DownlinkRequestVisitor2 {
    private Request coapRequest;
    private final Identity destination;
    private final String rootPath;
    private final String registrationId;
    private final String endpoint;
    private final boolean allowConnectionInitiation;
    private final LwM2mModel model;
    private final LwM2mNodeEncoder encoder;
    private LowerLayerConfig lowerLayerConfig;

    @Deprecated
    public CoapRequestBuilder(Identity destination, String rootPath, String registrationId, String endpoint, LwM2mModel model, LwM2mNodeEncoder encoder, boolean allowConnectionInitiation) {
        this.destination = destination;
        this.rootPath = rootPath;
        this.endpoint = endpoint;
        this.registrationId = registrationId;
        this.model = model;
        this.encoder = encoder;
        this.allowConnectionInitiation = allowConnectionInitiation;
    }

    public CoapRequestBuilder(Identity destination2, String rootPath2, String sessionId, String endpointName, LwM2mModel model2, LwM2mNodeEncoder encoder2, boolean allowConnectionInitiation2, LowerLayerConfig lowerLayerConfig) {
        this(destination2, rootPath2, sessionId, endpointName, model2, encoder2, allowConnectionInitiation2);
        this.lowerLayerConfig = lowerLayerConfig;
    }

    public void visit(ReadRequest request) {
        this.coapRequest = Request.newGet();
        if (request.getContentFormat() != null) {
            this.coapRequest.getOptions().setAccept(request.getContentFormat().getCode());
        }
        this.setTarget(this.coapRequest, request.getPath());
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(DiscoverRequest request) {
        this.coapRequest = Request.newGet();
        this.setTarget(this.coapRequest, request.getPath());
        this.coapRequest.getOptions().setAccept(40);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(WriteRequest request) {
        this.coapRequest = request.isReplaceRequest() ? Request.newPut() : Request.newPost();
        ContentFormat format = request.getContentFormat();
        this.coapRequest.getOptions().setContentFormat(format.getCode());
        this.coapRequest.setPayload(this.encoder.encode(request.getNode(), format, request.getPath(), this.model));
        this.setTarget(this.coapRequest, request.getPath());
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(WriteAttributesRequest request) {
        this.coapRequest = Request.newPut();
        this.setTarget(this.coapRequest, request.getPath());
        for (String query : request.getAttributes().toQueryParams()) {
            this.coapRequest.getOptions().addUriQuery(query);
        }
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(ExecuteRequest request) {
        this.coapRequest = Request.newPost();
        this.setTarget(this.coapRequest, request.getPath());
        if (request.getParameters() != null) {
            this.coapRequest.setPayload(request.getParameters());
            this.coapRequest.getOptions().setContentFormat(0);
        }
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(CreateRequest request) {
        this.coapRequest = Request.newPost();
        this.coapRequest.getOptions().setContentFormat(request.getContentFormat().getCode());
        Object node = request.unknownObjectInstanceId() ? new LwM2mObjectInstance((Collection)request.getResources()) : new LwM2mObject(request.getPath().getObjectId().intValue(), (Collection)request.getObjectInstances());
        this.coapRequest.setPayload(this.encoder.encode((LwM2mNode)node, request.getContentFormat(), request.getPath(), this.model));
        this.setTarget(this.coapRequest, request.getPath());
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(DeleteRequest request) {
        this.coapRequest = Request.newDelete();
        this.setTarget(this.coapRequest, request.getPath());
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(ObserveRequest request) {
        this.coapRequest = Request.newGet();
        if (request.getContentFormat() != null) {
            this.coapRequest.getOptions().setAccept(request.getContentFormat().getCode());
        }
        this.coapRequest.setObserve();
        this.setTarget(this.coapRequest, request.getPath());
        this.coapRequest.setUserContext(ObserveUtil.createCoapObserveRequestContext(this.endpoint, this.registrationId, request));
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(CancelObservationRequest request) {
        this.coapRequest = Request.newGet();
        this.coapRequest.setObserveCancel();
        this.coapRequest.setToken(request.getObservation().getId());
        if (request.getObservation().getContentFormat() != null) {
            this.coapRequest.getOptions().setAccept(request.getObservation().getContentFormat().getCode());
        }
        this.setTarget(this.coapRequest, request.getPath());
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(BootstrapWriteRequest request) {
        this.coapRequest = Request.newPut();
        this.coapRequest.setConfirmable(true);
        ContentFormat format = request.getContentFormat();
        this.coapRequest.getOptions().setContentFormat(format.getCode());
        this.coapRequest.setPayload(this.encoder.encode(request.getNode(), format, request.getPath(), this.model));
        this.setTarget(this.coapRequest, request.getPath());
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(BootstrapDiscoverRequest request) {
        this.coapRequest = Request.newGet();
        this.setTarget(this.coapRequest, request.getPath());
        this.coapRequest.getOptions().setAccept(40);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(BootstrapDeleteRequest request) {
        this.coapRequest = Request.newDelete();
        this.coapRequest.setConfirmable(true);
        EndpointContext context = EndpointContextUtil.extractContext((Identity)this.destination, (boolean)this.allowConnectionInitiation);
        this.coapRequest.setDestinationContext(context);
        this.setTarget(this.coapRequest, request.getPath());
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(BootstrapFinishRequest request) {
        this.coapRequest = Request.newPost();
        this.coapRequest.setConfirmable(true);
        EndpointContext context = EndpointContextUtil.extractContext((Identity)this.destination, (boolean)this.allowConnectionInitiation);
        this.coapRequest.setDestinationContext(context);
        if (this.rootPath != null) {
            for (String rootPathPart : this.rootPath.split("/")) {
                if (StringUtils.isEmpty((String)rootPathPart)) continue;
                this.coapRequest.getOptions().addUriPath(rootPathPart);
            }
        }
        this.coapRequest.getOptions().addUriPath("bs");
        this.applyLowerLayerConfig(this.coapRequest);
    }

    protected void setTarget(Request coapRequest, LwM2mPath path) {
        EndpointContext context = EndpointContextUtil.extractContext((Identity)this.destination, (boolean)this.allowConnectionInitiation);
        coapRequest.setDestinationContext(context);
        if (this.rootPath != null) {
            for (String rootPathPart : this.rootPath.split("/")) {
                if (StringUtils.isEmpty((String)rootPathPart)) continue;
                coapRequest.getOptions().addUriPath(rootPathPart);
            }
        }
        if (path.getObjectId() != null) {
            coapRequest.getOptions().addUriPath(Integer.toString(path.getObjectId()));
        }
        if (path.getObjectInstanceId() == null) {
            if (path.getResourceId() != null) {
                coapRequest.getOptions().addUriPath("0");
            }
        } else {
            coapRequest.getOptions().addUriPath(Integer.toString(path.getObjectInstanceId()));
        }
        if (path.getResourceId() != null) {
            coapRequest.getOptions().addUriPath(Integer.toString(path.getResourceId()));
        }
    }

    protected void applyLowerLayerConfig(Request coapRequest) {
        if (this.lowerLayerConfig != null) {
            this.lowerLayerConfig.apply((Object)coapRequest);
        }
    }

    public Request getRequest() {
        return this.coapRequest;
    }
}

