/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.eclipse.leshan.client.resource.LwM2mObjectEnabler;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.client.servers.ServerInfo;
import org.eclipse.leshan.core.SecurityMode;
import org.eclipse.leshan.core.node.LwM2mObject;
import org.eclipse.leshan.core.node.LwM2mObjectInstance;
import org.eclipse.leshan.core.request.ReadRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SecurityObjectPskStore
implements PskStore {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityObjectPskStore.class);
    protected final LwM2mObjectEnabler securityEnabler;

    public SecurityObjectPskStore(LwM2mObjectEnabler securityEnabler) {
        this.securityEnabler = securityEnabler;
    }

    public SecretKey getKey(PskPublicInformation identity) {
        if (identity == null) {
            return null;
        }
        byte[] res = null;
        LwM2mObject securities = (LwM2mObject)this.securityEnabler.read(ServerIdentity.SYSTEM, new ReadRequest(0)).getContent();
        for (LwM2mObjectInstance security : securities.getInstances().values()) {
            long securityMode = (Long)security.getResource(2).getValue();
            if (securityMode != (long)SecurityMode.PSK.code) continue;
            byte[] pskIdentity = (byte[])security.getResource(3).getValue();
            if (!Arrays.equals(identity.getBytes(), pskIdentity)) continue;
            if (res == null) {
                res = (byte[])security.getResource(5).getValue();
                continue;
            }
            LOG.warn("There is several security object instance with the same psk identity : '{}'", (Object)identity);
            return SecretUtil.create((byte[])res, (String)"PSK");
        }
        if (res != null) {
            return SecretUtil.create(res, (String)"PSK");
        }
        return null;
    }

    public SecretKey getKey(ServerNames serverNames, PskPublicInformation identity) {
        return this.getKey(identity);
    }

    public PskPublicInformation getIdentity(InetSocketAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        LwM2mObject securities = (LwM2mObject)this.securityEnabler.read(ServerIdentity.SYSTEM, new ReadRequest(0)).getContent();
        for (LwM2mObjectInstance security : securities.getInstances().values()) {
            long securityMode = (Long)security.getResource(2).getValue();
            if (securityMode != (long)SecurityMode.PSK.code) continue;
            try {
                URI uri = new URI((String)security.getResource(0).getValue());
                if (!inetAddress.equals(ServerInfo.getAddress((URI)uri))) continue;
                byte[] pskIdentity = (byte[])security.getResource(3).getValue();
                return new PskPublicInformation(new String(pskIdentity));
            }
            catch (URISyntaxException e) {
                LOG.error(String.format("Invalid URI %s", (String)security.getResource(0).getValue()), (Throwable)e);
            }
        }
        return null;
    }

    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        throw new UnsupportedOperationException();
    }
}

