/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ServerNames;

public class DefaultLeshanCertificateVerifier
implements NewAdvancedCertificateVerifier {
    private final Certificate expectedServerCertificate;
    private final List<CertificateType> supportedCertificateType;

    public DefaultLeshanCertificateVerifier(Certificate expectedServerCertificate) {
        this.expectedServerCertificate = expectedServerCertificate;
        this.supportedCertificateType = new ArrayList<CertificateType>(1);
        this.supportedCertificateType.add(CertificateType.X_509);
    }

    public List<X500Principal> getAcceptedIssuers() {
        return Collections.emptyList();
    }

    public List<CertificateType> getSupportedCertificateType() {
        return this.supportedCertificateType;
    }

    public CertificateVerificationResult verifyCertificate(ConnectionId cid, ServerNames serverName, Boolean clientUsage, boolean truncateCertificatePath, CertificateMessage message, DTLSSession session) {
        if (message.getCertificateChain() == null || message.getCertificateChain().getCertificates().size() == 0) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
            HandshakeException handshakeException = new HandshakeException("Certificate chain could not be validated : server cert chain is empty", alert);
            return new CertificateVerificationResult(cid, handshakeException, null);
        }
        Certificate receivedServerCertificate = message.getCertificateChain().getCertificates().get(0);
        if (!this.expectedServerCertificate.equals(receivedServerCertificate)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
            HandshakeException handshakeException = new HandshakeException("Certificate chain could not be validated: server certificate does not match expected one ('domain-issue certificate' usage)", alert);
            return new CertificateVerificationResult(cid, handshakeException, null);
        }
        return new CertificateVerificationResult(cid, message.getCertificateChain(), null);
    }

    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }
}

