/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.service.user.internal;

import java.util.Objects;
import javax.inject.Inject;
import org.eclipse.kapua.KapuaDuplicateExternalIdException;
import org.eclipse.kapua.KapuaDuplicateNameException;
import org.eclipse.kapua.KapuaDuplicateNameInAnotherAccountError;
import org.eclipse.kapua.KapuaEntityNotFoundException;
import org.eclipse.kapua.KapuaException;
import org.eclipse.kapua.KapuaIllegalArgumentException;
import org.eclipse.kapua.KapuaMaxNumberOfItemsReachedException;
import org.eclipse.kapua.commons.configuration.AbstractKapuaConfigurableResourceLimitedService;
import org.eclipse.kapua.commons.jpa.AbstractEntityCacheFactory;
import org.eclipse.kapua.commons.jpa.EntityManagerContainer;
import org.eclipse.kapua.commons.jpa.EntityManagerFactory;
import org.eclipse.kapua.commons.security.KapuaSecurityUtils;
import org.eclipse.kapua.commons.service.internal.cache.NamedEntityCache;
import org.eclipse.kapua.commons.setting.SettingKey;
import org.eclipse.kapua.commons.setting.system.SystemSetting;
import org.eclipse.kapua.commons.setting.system.SystemSettingKey;
import org.eclipse.kapua.commons.util.ArgumentValidator;
import org.eclipse.kapua.commons.util.CommonsValidationRegex;
import org.eclipse.kapua.commons.util.ValidationRegex;
import org.eclipse.kapua.event.ServiceEvent;
import org.eclipse.kapua.locator.KapuaProvider;
import org.eclipse.kapua.model.KapuaEntity;
import org.eclipse.kapua.model.domain.Actions;
import org.eclipse.kapua.model.domain.Domain;
import org.eclipse.kapua.model.id.KapuaId;
import org.eclipse.kapua.model.query.KapuaQuery;
import org.eclipse.kapua.model.query.predicate.QueryPredicate;
import org.eclipse.kapua.service.authorization.AuthorizationService;
import org.eclipse.kapua.service.authorization.permission.PermissionFactory;
import org.eclipse.kapua.service.user.User;
import org.eclipse.kapua.service.user.UserCreator;
import org.eclipse.kapua.service.user.UserDomains;
import org.eclipse.kapua.service.user.UserFactory;
import org.eclipse.kapua.service.user.UserListResult;
import org.eclipse.kapua.service.user.UserQuery;
import org.eclipse.kapua.service.user.UserService;
import org.eclipse.kapua.service.user.UserStatus;
import org.eclipse.kapua.service.user.UserType;
import org.eclipse.kapua.service.user.internal.UserCacheFactory;
import org.eclipse.kapua.service.user.internal.UserDAO;
import org.eclipse.kapua.service.user.internal.UserEntityManagerFactory;
import org.eclipse.kapua.service.user.internal.UserQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KapuaProvider
public class UserServiceImpl
extends AbstractKapuaConfigurableResourceLimitedService<User, UserCreator, UserService, UserListResult, UserQuery, UserFactory>
implements UserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    @Inject
    private AuthorizationService authorizationService;
    @Inject
    private PermissionFactory permissionFactory;

    public UserServiceImpl() {
        super(UserService.class.getName(), (Domain)UserDomains.USER_DOMAIN, (EntityManagerFactory)UserEntityManagerFactory.getInstance(), (AbstractEntityCacheFactory)UserCacheFactory.getInstance(), UserService.class, UserFactory.class);
    }

    public User create(UserCreator userCreator) throws KapuaException {
        User userByExternalId;
        ArgumentValidator.notNull((Object)userCreator.getScopeId().getId(), (String)"userCreator.scopeId");
        ArgumentValidator.notEmptyOrNull((String)userCreator.getName(), (String)"userCreator.name");
        ArgumentValidator.match((String)userCreator.getName(), (ValidationRegex)CommonsValidationRegex.NAME_REGEXP, (String)"userCreator.name");
        ArgumentValidator.match((String)userCreator.getEmail(), (ValidationRegex)CommonsValidationRegex.EMAIL_REGEXP, (String)"userCreator.email");
        ArgumentValidator.notNull((Object)userCreator.getUserType(), (String)"userCreator.userType");
        ArgumentValidator.notNull((Object)userCreator.getUserStatus(), (String)"userCreator.userStatus");
        if (userCreator.getUserType() == UserType.EXTERNAL) {
            ArgumentValidator.notEmptyOrNull((String)userCreator.getExternalId(), (String)"userCreator.externalId");
        } else if (userCreator.getUserType() == UserType.INTERNAL) {
            ArgumentValidator.isEmptyOrNull((String)userCreator.getExternalId(), (String)"userCreator.externalId");
        }
        int remainingChildEntities = this.allowedChildEntities(userCreator.getScopeId());
        if (remainingChildEntities <= 0) {
            LOGGER.info("Exceeded child limit - remaining: {}", (Object)remainingChildEntities);
            throw new KapuaMaxNumberOfItemsReachedException("Users");
        }
        this.authorizationService.checkPermission(this.permissionFactory.newPermission((Domain)UserDomains.USER_DOMAIN, Actions.write, userCreator.getScopeId()));
        UserQueryImpl query = new UserQueryImpl(userCreator.getScopeId());
        query.setPredicate((QueryPredicate)query.attributePredicate("name", userCreator.getName()));
        if (this.count((KapuaQuery)query) > 0L) {
            throw new KapuaDuplicateNameException(userCreator.getName());
        }
        User userByName = (User)KapuaSecurityUtils.doPrivileged(() -> this.findByName(userCreator.getName()));
        if (userByName != null) {
            throw new KapuaDuplicateNameInAnotherAccountError(userCreator.getName());
        }
        if (userCreator.getUserType() == UserType.EXTERNAL && (userByExternalId = (User)KapuaSecurityUtils.doPrivileged(() -> this.findByExternalId(userCreator.getExternalId()))) != null) {
            throw new KapuaDuplicateExternalIdException(userCreator.getExternalId());
        }
        return (User)this.entityManagerSession.doTransactedAction(EntityManagerContainer.create().onResultHandler(em -> UserDAO.create(em, userCreator)));
    }

    public User update(User user) throws KapuaException {
        ArgumentValidator.notNull((Object)user.getId().getId(), (String)"user.id");
        ArgumentValidator.notNull((Object)user.getScopeId(), (String)"user.scopeId");
        ArgumentValidator.notEmptyOrNull((String)user.getName(), (String)"user.name");
        ArgumentValidator.match((String)user.getName(), (ValidationRegex)CommonsValidationRegex.NAME_REGEXP, (String)"user.name");
        ArgumentValidator.match((String)user.getEmail(), (ValidationRegex)CommonsValidationRegex.EMAIL_REGEXP, (String)"user.email");
        ArgumentValidator.notNull((Object)user.getUserType(), (String)"user.userType");
        if (user.getUserType() == UserType.EXTERNAL) {
            ArgumentValidator.notEmptyOrNull((String)user.getExternalId(), (String)"user.externalId");
        } else if (user.getUserType() == UserType.INTERNAL) {
            ArgumentValidator.isEmptyOrNull((String)user.getExternalId(), (String)"user.externalId");
        }
        this.authorizationService.checkPermission(this.permissionFactory.newPermission((Domain)UserDomains.USER_DOMAIN, Actions.write, user.getScopeId()));
        User currentUser = this.find(user.getScopeId(), user.getId());
        if (currentUser == null) {
            throw new KapuaEntityNotFoundException("user", user.getId());
        }
        if (user.getExpirationDate() != null || !currentUser.getName().equals(user.getName())) {
            this.validateSystemUser(user.getName());
        }
        if (user.getId().equals(KapuaSecurityUtils.getSession().getUserId()) && user.getStatus().equals((Object)UserStatus.DISABLED)) {
            throw new KapuaIllegalArgumentException("status", user.getStatus().name());
        }
        if (!Objects.equals(currentUser.getUserType(), user.getUserType())) {
            throw new KapuaIllegalArgumentException("userType", user.getUserType().toString());
        }
        if (!Objects.equals(currentUser.getExternalId(), user.getExternalId())) {
            throw new KapuaIllegalArgumentException("externalId", user.getExternalId());
        }
        return (User)this.entityManagerSession.doTransactedAction(EntityManagerContainer.create().onResultHandler(em -> UserDAO.update(em, user)).onBeforeHandler(() -> {
            this.entityCache.remove(null, (KapuaEntity)user);
            return null;
        }));
    }

    public void delete(KapuaId scopeId, KapuaId userId) throws KapuaException {
        ArgumentValidator.notNull((Object)userId.getId(), (String)"user.id");
        ArgumentValidator.notNull((Object)scopeId.getId(), (String)"user.scopeId");
        this.authorizationService.checkPermission(this.permissionFactory.newPermission((Domain)UserDomains.USER_DOMAIN, Actions.delete, scopeId));
        User user = this.find(scopeId, userId);
        if (user == null) {
            throw new KapuaEntityNotFoundException("user", userId);
        }
        this.validateSystemUser(user.getName());
        this.validateSelf(user);
        this.entityManagerSession.doTransactedAction(EntityManagerContainer.create().onResultHandler(em -> UserDAO.delete(em, scopeId, userId)).onAfterHandler(emptyParam -> this.entityCache.remove(scopeId, userId)));
    }

    public void delete(User user) throws KapuaException {
        ArgumentValidator.notNull((Object)user, (String)"user");
        this.delete(user.getScopeId(), user.getId());
    }

    public User find(KapuaId scopeId, KapuaId userId) throws KapuaException {
        ArgumentValidator.notNull((Object)scopeId, (String)"scopeId");
        ArgumentValidator.notNull((Object)userId, (String)"userId");
        this.authorizationService.checkPermission(this.permissionFactory.newPermission((Domain)UserDomains.USER_DOMAIN, Actions.read, scopeId));
        return (User)this.entityManagerSession.doAction(EntityManagerContainer.create().onResultHandler(em -> UserDAO.find(em, scopeId, userId)).onBeforeHandler(() -> (User)this.entityCache.get(scopeId, userId)).onAfterHandler(entity -> this.entityCache.put((KapuaEntity)entity)));
    }

    public User findByName(String name) throws KapuaException {
        ArgumentValidator.notEmptyOrNull((String)name, (String)"name");
        return (User)this.entityManagerSession.doAction(EntityManagerContainer.create().onResultHandler(em -> this.checkReadAccess(UserDAO.findByName(em, name))).onBeforeHandler(() -> this.checkReadAccess((User)((NamedEntityCache)this.entityCache).get(null, name))).onAfterHandler(entity -> this.entityCache.put((KapuaEntity)entity)));
    }

    public User findByExternalId(String externalId) throws KapuaException {
        ArgumentValidator.notEmptyOrNull((String)externalId, (String)"externalId");
        return (User)this.entityManagerSession.doAction(EntityManagerContainer.create().onResultHandler(em -> this.checkReadAccess(UserDAO.findByExternalId(em, externalId))).onAfterHandler(entity -> this.entityCache.put((KapuaEntity)entity)));
    }

    public UserListResult query(KapuaQuery query) throws KapuaException {
        ArgumentValidator.notNull((Object)query, (String)"query");
        this.authorizationService.checkPermission(this.permissionFactory.newPermission((Domain)UserDomains.USER_DOMAIN, Actions.read, query.getScopeId()));
        return (UserListResult)this.entityManagerSession.doAction(EntityManagerContainer.create().onResultHandler(em -> UserDAO.query(em, query)));
    }

    public long count(KapuaQuery query) throws KapuaException {
        ArgumentValidator.notNull((Object)query, (String)"query");
        this.authorizationService.checkPermission(this.permissionFactory.newPermission((Domain)UserDomains.USER_DOMAIN, Actions.read, query.getScopeId()));
        return (Long)this.entityManagerSession.doAction(EntityManagerContainer.create().onResultHandler(em -> UserDAO.count(em, query)));
    }

    private User checkReadAccess(User user) throws KapuaException {
        if (user != null) {
            this.authorizationService.checkPermission(this.permissionFactory.newPermission((Domain)UserDomains.USER_DOMAIN, Actions.read, user.getScopeId()));
        }
        return user;
    }

    private void validateSystemUser(String name) throws KapuaException {
        String adminUsername = SystemSetting.getInstance().getString((SettingKey)SystemSettingKey.SYS_ADMIN_USERNAME);
        if (adminUsername.equals(name)) {
            throw new KapuaIllegalArgumentException("name", adminUsername);
        }
    }

    private void validateSelf(User user) throws KapuaException {
        if (user.getId().equals(KapuaSecurityUtils.getSession().getUserId())) {
            throw new KapuaIllegalArgumentException("name", user.getName());
        }
    }

    public void onKapuaEvent(ServiceEvent kapuaEvent) throws KapuaException {
        if (kapuaEvent == null) {
            // empty if block
        }
        LOGGER.info("UserService: received kapua event from {}, operation {}", (Object)kapuaEvent.getService(), (Object)kapuaEvent.getOperation());
        if ("account".equals(kapuaEvent.getService()) && "delete".equals(kapuaEvent.getOperation())) {
            this.deleteUserByAccountId(kapuaEvent.getScopeId(), kapuaEvent.getEntityId());
        }
    }

    private void deleteUserByAccountId(KapuaId scopeId, KapuaId accountId) throws KapuaException {
        UserQueryImpl query = new UserQueryImpl(accountId);
        UserListResult usersToDelete = this.query((KapuaQuery)query);
        for (User u : usersToDelete.getItems()) {
            this.delete(u.getScopeId(), u.getId());
        }
    }
}

