/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.service.user.internal;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.eclipse.kapua.KapuaException;
import org.eclipse.kapua.commons.model.AbstractKapuaNamedEntity;
import org.eclipse.kapua.model.KapuaNamedEntity;
import org.eclipse.kapua.model.id.KapuaId;
import org.eclipse.kapua.service.user.User;
import org.eclipse.kapua.service.user.UserStatus;
import org.eclipse.kapua.service.user.UserType;

@Entity(name="User")
@Table(name="usr_user")
public class UserImpl
extends AbstractKapuaNamedEntity
implements User {
    private static final long serialVersionUID = 4029650117581681503L;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private UserStatus status;
    @Basic
    @Column(name="display_name")
    private String displayName;
    @Basic
    @Column(name="email")
    private String email;
    @Basic
    @Column(name="phone_number")
    private String phoneNumber;
    @Enumerated(value=EnumType.STRING)
    @Column(name="user_type", updatable=false, nullable=false)
    private UserType userType;
    @Basic
    @Column(name="external_id", updatable=false)
    private String externalId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration_date")
    private Date expirationDate;

    public UserImpl() {
        this(null, null);
    }

    public UserImpl(KapuaId scopeId) {
        this(scopeId, null);
    }

    public UserImpl(KapuaId scopeId, String name) {
        super(scopeId, name);
        this.status = UserStatus.ENABLED;
        this.userType = UserType.INTERNAL;
    }

    public UserImpl(User user) throws KapuaException {
        super((KapuaNamedEntity)user);
        this.setStatus(user.getStatus());
        this.setDisplayName(user.getDisplayName());
        this.setEmail(user.getEmail());
        this.setPhoneNumber(user.getPhoneNumber());
        this.setUserType(user.getUserType());
        this.setExternalId(user.getExternalId());
        this.setExpirationDate(user.getExpirationDate());
    }

    public UserStatus getStatus() {
        return this.status;
    }

    public void setStatus(UserStatus status) {
        this.status = status;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }
}

