/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.service.user.internal;

import java.util.Objects;
import javax.inject.Inject;
import org.eclipse.kapua.KapuaEntityNotFoundException;
import org.eclipse.kapua.KapuaException;
import org.eclipse.kapua.KapuaIllegalArgumentException;
import org.eclipse.kapua.commons.configuration.AbstractKapuaConfigurableResourceLimitedService;
import org.eclipse.kapua.commons.util.ArgumentValidator;
import org.eclipse.kapua.locator.KapuaProvider;
import org.eclipse.kapua.model.id.KapuaId;
import org.eclipse.kapua.model.query.KapuaQuery;
import org.eclipse.kapua.service.authorization.AuthorizationService;
import org.eclipse.kapua.service.authorization.domain.Domain;
import org.eclipse.kapua.service.authorization.permission.Actions;
import org.eclipse.kapua.service.authorization.permission.PermissionFactory;
import org.eclipse.kapua.service.user.User;
import org.eclipse.kapua.service.user.UserCreator;
import org.eclipse.kapua.service.user.UserFactory;
import org.eclipse.kapua.service.user.UserListResult;
import org.eclipse.kapua.service.user.UserQuery;
import org.eclipse.kapua.service.user.UserService;
import org.eclipse.kapua.service.user.UserType;
import org.eclipse.kapua.service.user.internal.UserDAO;
import org.eclipse.kapua.service.user.internal.UserDomain;
import org.eclipse.kapua.service.user.internal.UserEntityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KapuaProvider
public class UserServiceImpl
extends AbstractKapuaConfigurableResourceLimitedService<User, UserCreator, UserService, UserListResult, UserQuery, UserFactory>
implements UserService {
    private static final Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    private static final Domain USER_DOMAIN = new UserDomain();
    @Inject
    private AuthorizationService authorizationService;
    @Inject
    private PermissionFactory permissionFactory;

    public UserServiceImpl() {
        super(UserService.class.getName(), USER_DOMAIN, UserEntityManagerFactory.getInstance(), UserService.class, UserFactory.class);
    }

    public User create(UserCreator userCreator) throws KapuaException {
        ArgumentValidator.notNull((Object)userCreator.getScopeId().getId(), (String)"scopeId");
        ArgumentValidator.notEmptyOrNull((String)userCreator.getName(), (String)"name");
        ArgumentValidator.match((String)userCreator.getName(), (String)"^[a-zA-Z0-9\\_\\-]{3,}$", (String)"name");
        ArgumentValidator.match((String)userCreator.getEmail(), (String)"^(\\w+)([-+.][\\w]+)*@(\\w[-\\w]*\\.){1,5}([A-Za-z]){2,4}$", (String)"email");
        ArgumentValidator.notNull((Object)userCreator.getUserType(), (String)"userType");
        ArgumentValidator.notNull((Object)userCreator.getUserStatus(), (String)"userStatus");
        if (userCreator.getUserType() != UserType.INTERNAL) {
            ArgumentValidator.notEmptyOrNull((String)userCreator.getExternalId(), (String)"externalId");
        } else {
            ArgumentValidator.isEmptyOrNull((String)userCreator.getExternalId(), (String)"externalId");
        }
        int remainingChildEntities = this.allowedChildEntities(userCreator.getScopeId());
        if (remainingChildEntities <= 0) {
            logger.info("Exceeded child limit - remaining: {}", (Object)remainingChildEntities);
            throw new KapuaIllegalArgumentException("scopeId", "max users reached");
        }
        this.authorizationService.checkPermission(this.permissionFactory.newPermission(USER_DOMAIN, Actions.write, userCreator.getScopeId()));
        return (User)this.entityManagerSession.onTransactedInsert(em -> UserDAO.create(em, userCreator));
    }

    public User update(User user) throws KapuaException {
        ArgumentValidator.notNull((Object)user.getId().getId(), (String)"id");
        ArgumentValidator.notNull((Object)user.getScopeId().getId(), (String)"accountId");
        ArgumentValidator.notEmptyOrNull((String)user.getName(), (String)"name");
        ArgumentValidator.match((String)user.getName(), (String)"^[a-zA-Z0-9\\_\\-]{3,}$", (String)"name");
        ArgumentValidator.match((String)user.getEmail(), (String)"^(\\w+)([-+.][\\w]+)*@(\\w[-\\w]*\\.){1,5}([A-Za-z]){2,4}$", (String)"email");
        if (user.getUserType() != UserType.INTERNAL) {
            ArgumentValidator.notEmptyOrNull((String)user.getExternalId(), (String)"externalId");
        } else {
            ArgumentValidator.isEmptyOrNull((String)user.getExternalId(), (String)"externalId");
        }
        this.validateSystemUser(user.getName());
        this.authorizationService.checkPermission(this.permissionFactory.newPermission(USER_DOMAIN, Actions.write, user.getScopeId()));
        return (User)this.entityManagerSession.onTransactedResult(em -> {
            User currentUser = UserDAO.find(em, user.getId());
            if (currentUser == null) {
                throw new KapuaEntityNotFoundException("user", user.getId());
            }
            if (!Objects.equals(currentUser.getUserType(), user.getUserType())) {
                throw new KapuaIllegalArgumentException("userType", user.getUserType().toString());
            }
            if (!Objects.equals(currentUser.getExternalId(), user.getExternalId())) {
                throw new KapuaIllegalArgumentException("externalId", user.getExternalId());
            }
            return UserDAO.update(em, user);
        });
    }

    public void delete(KapuaId scopeId, KapuaId userId) throws KapuaException {
        ArgumentValidator.notNull((Object)userId.getId(), (String)"id");
        ArgumentValidator.notNull((Object)scopeId.getId(), (String)"accountId");
        this.authorizationService.checkPermission(this.permissionFactory.newPermission(USER_DOMAIN, Actions.write, scopeId));
        this.entityManagerSession.onTransactedAction(em -> {
            User user = UserDAO.find(em, userId);
            if (user == null) {
                throw new KapuaEntityNotFoundException("user", userId);
            }
            this.validateSystemUser(user.getName());
            UserDAO.delete(em, userId);
        });
    }

    public void delete(User user) throws KapuaException {
        ArgumentValidator.notNull((Object)user, (String)"user");
        this.delete(user.getScopeId(), user.getId());
    }

    public User find(KapuaId accountId, KapuaId userId) throws KapuaException {
        ArgumentValidator.notNull((Object)accountId.getId(), (String)"accountId");
        ArgumentValidator.notNull((Object)userId.getId(), (String)"id");
        this.authorizationService.checkPermission(this.permissionFactory.newPermission(USER_DOMAIN, Actions.read, accountId));
        return (User)this.entityManagerSession.onResult(em -> UserDAO.find(em, userId));
    }

    public User findByName(String name) throws KapuaException {
        ArgumentValidator.notEmptyOrNull((String)name, (String)"name");
        return (User)this.entityManagerSession.onResult(em -> this.checkReadAccess(UserDAO.findByName(em, name)));
    }

    public User findByExternalId(String externalId) throws KapuaException {
        ArgumentValidator.notEmptyOrNull((String)externalId, (String)"externalId");
        return (User)this.entityManagerSession.onResult(em -> this.checkReadAccess(UserDAO.findByExternalId(em, externalId)));
    }

    public UserListResult query(KapuaQuery<User> query) throws KapuaException {
        ArgumentValidator.notNull(query, (String)"query");
        ArgumentValidator.notNull((Object)query.getScopeId(), (String)"query.scopeId");
        this.authorizationService.checkPermission(this.permissionFactory.newPermission(USER_DOMAIN, Actions.read, query.getScopeId()));
        return (UserListResult)this.entityManagerSession.onResult(em -> UserDAO.query(em, query));
    }

    public long count(KapuaQuery<User> query) throws KapuaException {
        ArgumentValidator.notNull(query, (String)"query");
        ArgumentValidator.notNull((Object)query.getScopeId(), (String)"query.scopeId");
        this.authorizationService.checkPermission(this.permissionFactory.newPermission(USER_DOMAIN, Actions.read, query.getScopeId()));
        return (Long)this.entityManagerSession.onResult(em -> UserDAO.count(em, query));
    }

    private User checkReadAccess(User user) throws KapuaException {
        if (user != null) {
            this.authorizationService.checkPermission(this.permissionFactory.newPermission(USER_DOMAIN, Actions.read, user.getScopeId()));
        }
        return user;
    }

    private void validateSystemUser(String name) throws KapuaException {
        if ("kapua-sys".equals(name)) {
            throw new KapuaIllegalArgumentException("name", "kapua-sys");
        }
    }
}

